package org.cloudfoundry.client.v2.buildpacks;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * The entity response payload for the buildpack resource
 */
@Generated(from = "_BuildpackEntity", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class BuildpackEntity extends org.cloudfoundry.client.v2.buildpacks._BuildpackEntity {
  private final @Nullable Boolean enabled;
  private final @Nullable String filename;
  private final @Nullable Boolean locked;
  private final @Nullable String name;
  private final @Nullable Integer position;
  private final @Nullable String stack;
  private final @Nullable LifecycleType lifecycle;

  private BuildpackEntity(BuildpackEntity.Builder builder) {
    this.enabled = builder.enabled;
    this.filename = builder.filename;
    this.locked = builder.locked;
    this.name = builder.name;
    this.position = builder.position;
    this.stack = builder.stack;
    this.lifecycle = builder.lifecycle;
  }

  /**
   * Whether the buildpack is enabled
   */
  @JsonProperty("enabled")
  @Override
  public @Nullable Boolean getEnabled() {
    return enabled;
  }

  /**
   * The filename
   */
  @JsonProperty("filename")
  @Override
  public @Nullable String getFilename() {
    return filename;
  }

  /**
   * Whether the buildpack is locked
   */
  @JsonProperty("locked")
  @Override
  public @Nullable Boolean getLocked() {
    return locked;
  }

  /**
   * The name
   */
  @JsonProperty("name")
  @Override
  public @Nullable String getName() {
    return name;
  }

  /**
   * The position
   */
  @JsonProperty("position")
  @Override
  public @Nullable Integer getPosition() {
    return position;
  }

  /**
   * The stack
   */
  @JsonProperty("stack")
  @Override
  public @Nullable String getStack() {
    return stack;
  }

  /**
   * The lifecycle
   */
  @JsonProperty("lifecycle")
  @Override
  public @Nullable LifecycleType getLifecycle() {
    return lifecycle;
  }

  /**
   * This instance is equal to all instances of {@code BuildpackEntity} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof BuildpackEntity
        && equalTo(0, (BuildpackEntity) another);
  }

  private boolean equalTo(int synthetic, BuildpackEntity another) {
    return Objects.equals(enabled, another.enabled)
        && Objects.equals(filename, another.filename)
        && Objects.equals(locked, another.locked)
        && Objects.equals(name, another.name)
        && Objects.equals(position, another.position)
        && Objects.equals(stack, another.stack)
        && Objects.equals(lifecycle, another.lifecycle);
  }

  /**
   * Computes a hash code from attributes: {@code enabled}, {@code filename}, {@code locked}, {@code name}, {@code position}, {@code stack}, {@code lifecycle}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(enabled);
    h += (h << 5) + Objects.hashCode(filename);
    h += (h << 5) + Objects.hashCode(locked);
    h += (h << 5) + Objects.hashCode(name);
    h += (h << 5) + Objects.hashCode(position);
    h += (h << 5) + Objects.hashCode(stack);
    h += (h << 5) + Objects.hashCode(lifecycle);
    return h;
  }

  /**
   * Prints the immutable value {@code BuildpackEntity} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "BuildpackEntity{"
        + "enabled=" + enabled
        + ", filename=" + filename
        + ", locked=" + locked
        + ", name=" + name
        + ", position=" + position
        + ", stack=" + stack
        + ", lifecycle=" + lifecycle
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_BuildpackEntity", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v2.buildpacks._BuildpackEntity {
    Boolean enabled;
    String filename;
    Boolean locked;
    String name;
    Integer position;
    String stack;
    LifecycleType lifecycle;
    @JsonProperty("enabled")
    public void setEnabled(@Nullable Boolean enabled) {
      this.enabled = enabled;
    }
    @JsonProperty("filename")
    public void setFilename(@Nullable String filename) {
      this.filename = filename;
    }
    @JsonProperty("locked")
    public void setLocked(@Nullable Boolean locked) {
      this.locked = locked;
    }
    @JsonProperty("name")
    public void setName(@Nullable String name) {
      this.name = name;
    }
    @JsonProperty("position")
    public void setPosition(@Nullable Integer position) {
      this.position = position;
    }
    @JsonProperty("stack")
    public void setStack(@Nullable String stack) {
      this.stack = stack;
    }
    @JsonProperty("lifecycle")
    public void setLifecycle(@Nullable LifecycleType lifecycle) {
      this.lifecycle = lifecycle;
    }
    @Override
    public Boolean getEnabled() { throw new UnsupportedOperationException(); }
    @Override
    public String getFilename() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getLocked() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getPosition() { throw new UnsupportedOperationException(); }
    @Override
    public String getStack() { throw new UnsupportedOperationException(); }
    @Override
    public LifecycleType getLifecycle() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static BuildpackEntity fromJson(Json json) {
    BuildpackEntity.Builder builder = BuildpackEntity.builder();
    if (json.enabled != null) {
      builder.enabled(json.enabled);
    }
    if (json.filename != null) {
      builder.filename(json.filename);
    }
    if (json.locked != null) {
      builder.locked(json.locked);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.position != null) {
      builder.position(json.position);
    }
    if (json.stack != null) {
      builder.stack(json.stack);
    }
    if (json.lifecycle != null) {
      builder.lifecycle(json.lifecycle);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link BuildpackEntity BuildpackEntity}.
   * <pre>
   * BuildpackEntity.builder()
   *    .enabled(Boolean | null) // nullable {@link BuildpackEntity#getEnabled() enabled}
   *    .filename(String | null) // nullable {@link BuildpackEntity#getFilename() filename}
   *    .locked(Boolean | null) // nullable {@link BuildpackEntity#getLocked() locked}
   *    .name(String | null) // nullable {@link BuildpackEntity#getName() name}
   *    .position(Integer | null) // nullable {@link BuildpackEntity#getPosition() position}
   *    .stack(String | null) // nullable {@link BuildpackEntity#getStack() stack}
   *    .lifecycle(org.cloudfoundry.client.v2.buildpacks.LifecycleType | null) // nullable {@link BuildpackEntity#getLifecycle() lifecycle}
   *    .build();
   * </pre>
   * @return A new BuildpackEntity builder
   */
  public static BuildpackEntity.Builder builder() {
    return new BuildpackEntity.Builder();
  }

  /**
   * Builds instances of type {@link BuildpackEntity BuildpackEntity}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_BuildpackEntity", generator = "Immutables")
  public static final class Builder {
    private Boolean enabled;
    private String filename;
    private Boolean locked;
    private String name;
    private Integer position;
    private String stack;
    private LifecycleType lifecycle;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code BuildpackEntity} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(BuildpackEntity instance) {
      return from((_BuildpackEntity) instance);
    }

    /**
     * Copy abstract value type {@code _BuildpackEntity} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_BuildpackEntity instance) {
      Objects.requireNonNull(instance, "instance");
      Boolean enabledValue = instance.getEnabled();
      if (enabledValue != null) {
        enabled(enabledValue);
      }
      String filenameValue = instance.getFilename();
      if (filenameValue != null) {
        filename(filenameValue);
      }
      Boolean lockedValue = instance.getLocked();
      if (lockedValue != null) {
        locked(lockedValue);
      }
      String nameValue = instance.getName();
      if (nameValue != null) {
        name(nameValue);
      }
      Integer positionValue = instance.getPosition();
      if (positionValue != null) {
        position(positionValue);
      }
      String stackValue = instance.getStack();
      if (stackValue != null) {
        stack(stackValue);
      }
      LifecycleType lifecycleValue = instance.getLifecycle();
      if (lifecycleValue != null) {
        lifecycle(lifecycleValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link BuildpackEntity#getEnabled() enabled} attribute.
     * @param enabled The value for enabled (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("enabled")
    public final Builder enabled(@Nullable Boolean enabled) {
      this.enabled = enabled;
      return this;
    }

    /**
     * Initializes the value for the {@link BuildpackEntity#getFilename() filename} attribute.
     * @param filename The value for filename (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("filename")
    public final Builder filename(@Nullable String filename) {
      this.filename = filename;
      return this;
    }

    /**
     * Initializes the value for the {@link BuildpackEntity#getLocked() locked} attribute.
     * @param locked The value for locked (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("locked")
    public final Builder locked(@Nullable Boolean locked) {
      this.locked = locked;
      return this;
    }

    /**
     * Initializes the value for the {@link BuildpackEntity#getName() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    public final Builder name(@Nullable String name) {
      this.name = name;
      return this;
    }

    /**
     * Initializes the value for the {@link BuildpackEntity#getPosition() position} attribute.
     * @param position The value for position (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("position")
    public final Builder position(@Nullable Integer position) {
      this.position = position;
      return this;
    }

    /**
     * Initializes the value for the {@link BuildpackEntity#getStack() stack} attribute.
     * @param stack The value for stack (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("stack")
    public final Builder stack(@Nullable String stack) {
      this.stack = stack;
      return this;
    }

    /**
     * Initializes the value for the {@link BuildpackEntity#getLifecycle() lifecycle} attribute.
     * @param lifecycle The value for lifecycle (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("lifecycle")
    public final Builder lifecycle(@Nullable LifecycleType lifecycle) {
      this.lifecycle = lifecycle;
      return this;
    }

    /**
     * Builds a new {@link BuildpackEntity BuildpackEntity}.
     * @return An immutable instance of BuildpackEntity
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public BuildpackEntity build() {
      return new BuildpackEntity(this);
    }
  }
}
