package org.cloudfoundry.client.v2.buildpacks;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * The request payload for the Get Buildpack
 */
@Generated(from = "_GetBuildpackRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class GetBuildpackRequest extends org.cloudfoundry.client.v2.buildpacks._GetBuildpackRequest {
  private final String buildpackId;

  private GetBuildpackRequest(GetBuildpackRequest.Builder builder) {
    this.buildpackId = builder.buildpackId;
  }

  /**
   * The buildpack id
   */
  @Override
  public String getBuildpackId() {
    return buildpackId;
  }

  /**
   * This instance is equal to all instances of {@code GetBuildpackRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GetBuildpackRequest
        && equalTo(0, (GetBuildpackRequest) another);
  }

  private boolean equalTo(int synthetic, GetBuildpackRequest another) {
    return buildpackId.equals(another.buildpackId);
  }

  /**
   * Computes a hash code from attributes: {@code buildpackId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + buildpackId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code GetBuildpackRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GetBuildpackRequest{"
        + "buildpackId=" + buildpackId
        + "}";
  }

  /**
   * Creates a builder for {@link GetBuildpackRequest GetBuildpackRequest}.
   * <pre>
   * GetBuildpackRequest.builder()
   *    .buildpackId(String) // required {@link GetBuildpackRequest#getBuildpackId() buildpackId}
   *    .build();
   * </pre>
   * @return A new GetBuildpackRequest builder
   */
  public static GetBuildpackRequest.Builder builder() {
    return new GetBuildpackRequest.Builder();
  }

  /**
   * Builds instances of type {@link GetBuildpackRequest GetBuildpackRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_GetBuildpackRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_BUILDPACK_ID = 0x1L;
    private long initBits = 0x1L;

    private String buildpackId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GetBuildpackRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GetBuildpackRequest instance) {
      return from((_GetBuildpackRequest) instance);
    }

    /**
     * Copy abstract value type {@code _GetBuildpackRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_GetBuildpackRequest instance) {
      Objects.requireNonNull(instance, "instance");
      this.buildpackId(instance.getBuildpackId());
      return this;
    }

    /**
     * Initializes the value for the {@link GetBuildpackRequest#getBuildpackId() buildpackId} attribute.
     * @param buildpackId The value for buildpackId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder buildpackId(String buildpackId) {
      this.buildpackId = Objects.requireNonNull(buildpackId, "buildpackId");
      initBits &= ~INIT_BIT_BUILDPACK_ID;
      return this;
    }

    /**
     * Builds a new {@link GetBuildpackRequest GetBuildpackRequest}.
     * @return An immutable instance of GetBuildpackRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GetBuildpackRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new GetBuildpackRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_BUILDPACK_ID) != 0) attributes.add("buildpackId");
      return "Cannot build GetBuildpackRequest, some of required attributes are not set " + attributes;
    }
  }
}
