package org.cloudfoundry.client.v2.jobs;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * Job entity in response payloads
 */
@Generated(from = "_JobEntity", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class JobEntity extends org.cloudfoundry.client.v2.jobs._JobEntity {
  private final @Nullable String error;
  private final @Nullable ErrorDetails errorDetails;
  private final String id;
  private final String status;

  private JobEntity(JobEntity.Builder builder) {
    this.error = builder.error;
    this.errorDetails = builder.errorDetails;
    this.id = builder.id;
    this.status = builder.status;
  }

  /**
   * The error
   */
  @JsonProperty("error")
  @Override
  public @Nullable String getError() {
    return error;
  }

  /**
   * The error details
   */
  @JsonProperty("error_details")
  @Override
  public @Nullable ErrorDetails getErrorDetails() {
    return errorDetails;
  }

  /**
   * The id
   */
  @JsonProperty("guid")
  @Override
  public String getId() {
    return id;
  }

  /**
   * The status
   */
  @JsonProperty("status")
  @Override
  public String getStatus() {
    return status;
  }

  /**
   * This instance is equal to all instances of {@code JobEntity} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof JobEntity
        && equalTo(0, (JobEntity) another);
  }

  private boolean equalTo(int synthetic, JobEntity another) {
    return Objects.equals(error, another.error)
        && Objects.equals(errorDetails, another.errorDetails)
        && id.equals(another.id)
        && status.equals(another.status);
  }

  /**
   * Computes a hash code from attributes: {@code error}, {@code errorDetails}, {@code id}, {@code status}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(error);
    h += (h << 5) + Objects.hashCode(errorDetails);
    h += (h << 5) + id.hashCode();
    h += (h << 5) + status.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code JobEntity} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "JobEntity{"
        + "error=" + error
        + ", errorDetails=" + errorDetails
        + ", id=" + id
        + ", status=" + status
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_JobEntity", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v2.jobs._JobEntity {
    String error;
    ErrorDetails errorDetails;
    String id;
    String status;
    @JsonProperty("error")
    public void setError(@Nullable String error) {
      this.error = error;
    }
    @JsonProperty("error_details")
    public void setErrorDetails(@Nullable ErrorDetails errorDetails) {
      this.errorDetails = errorDetails;
    }
    @JsonProperty("guid")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("status")
    public void setStatus(String status) {
      this.status = status;
    }
    @Override
    public String getError() { throw new UnsupportedOperationException(); }
    @Override
    public ErrorDetails getErrorDetails() { throw new UnsupportedOperationException(); }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public String getStatus() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static JobEntity fromJson(Json json) {
    JobEntity.Builder builder = JobEntity.builder();
    if (json.error != null) {
      builder.error(json.error);
    }
    if (json.errorDetails != null) {
      builder.errorDetails(json.errorDetails);
    }
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.status != null) {
      builder.status(json.status);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link JobEntity JobEntity}.
   * <pre>
   * JobEntity.builder()
   *    .error(String | null) // nullable {@link JobEntity#getError() error}
   *    .errorDetails(org.cloudfoundry.client.v2.jobs.ErrorDetails | null) // nullable {@link JobEntity#getErrorDetails() errorDetails}
   *    .id(String) // required {@link JobEntity#getId() id}
   *    .status(String) // required {@link JobEntity#getStatus() status}
   *    .build();
   * </pre>
   * @return A new JobEntity builder
   */
  public static JobEntity.Builder builder() {
    return new JobEntity.Builder();
  }

  /**
   * Builds instances of type {@link JobEntity JobEntity}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_JobEntity", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_STATUS = 0x2L;
    private long initBits = 0x3L;

    private String error;
    private ErrorDetails errorDetails;
    private String id;
    private String status;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code JobEntity} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(JobEntity instance) {
      return from((_JobEntity) instance);
    }

    /**
     * Copy abstract value type {@code _JobEntity} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_JobEntity instance) {
      Objects.requireNonNull(instance, "instance");
      String errorValue = instance.getError();
      if (errorValue != null) {
        error(errorValue);
      }
      ErrorDetails errorDetailsValue = instance.getErrorDetails();
      if (errorDetailsValue != null) {
        errorDetails(errorDetailsValue);
      }
      this.id(instance.getId());
      this.status(instance.getStatus());
      return this;
    }

    /**
     * Initializes the value for the {@link JobEntity#getError() error} attribute.
     * @param error The value for error (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("error")
    public final Builder error(@Nullable String error) {
      this.error = error;
      return this;
    }

    /**
     * Initializes the value for the {@link JobEntity#getErrorDetails() errorDetails} attribute.
     * @param errorDetails The value for errorDetails (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("error_details")
    public final Builder errorDetails(@Nullable ErrorDetails errorDetails) {
      this.errorDetails = errorDetails;
      return this;
    }

    /**
     * Initializes the value for the {@link JobEntity#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("guid")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link JobEntity#getStatus() status} attribute.
     * @param status The value for status 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("status")
    public final Builder status(String status) {
      this.status = Objects.requireNonNull(status, "status");
      initBits &= ~INIT_BIT_STATUS;
      return this;
    }

    /**
     * Builds a new {@link JobEntity JobEntity}.
     * @return An immutable instance of JobEntity
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public JobEntity build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new JobEntity(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_STATUS) != 0) attributes.add("status");
      return "Cannot build JobEntity, some of required attributes are not set " + attributes;
    }
  }
}
