package org.cloudfoundry.client.v2.organizationquotadefinitions;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * The request payload for the Creating a Organization Quota Definition operation
 */
@Generated(from = "_CreateOrganizationQuotaDefinitionRequest", generator = "Immutables")
@SuppressWarnings({"all", "deprecation", "removal"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class CreateOrganizationQuotaDefinitionRequest
    extends org.cloudfoundry.client.v2.organizationquotadefinitions._CreateOrganizationQuotaDefinitionRequest {
  private final @Nullable Integer applicationInstanceLimit;
  private final @Nullable Integer applicationTaskLimit;
  private final Integer instanceMemoryLimit;
  private final Integer memoryLimit;
  private final String name;
  private final Boolean nonBasicServicesAllowed;
  private final @Nullable Integer totalPrivateDomains;
  private final @Nullable Integer totalReservedRoutePorts;
  private final Integer totalRoutes;
  private final @Nullable Integer totalServiceKeys;
  private final Integer totalServices;
  private final @Nullable Boolean trialDatabaseAllowed;
  private final @Nullable Integer logRateLimit;

  private CreateOrganizationQuotaDefinitionRequest(CreateOrganizationQuotaDefinitionRequest.Builder builder) {
    this.applicationInstanceLimit = builder.applicationInstanceLimit;
    this.applicationTaskLimit = builder.applicationTaskLimit;
    this.instanceMemoryLimit = builder.instanceMemoryLimit;
    this.memoryLimit = builder.memoryLimit;
    this.name = builder.name;
    this.nonBasicServicesAllowed = builder.nonBasicServicesAllowed;
    this.totalPrivateDomains = builder.totalPrivateDomains;
    this.totalReservedRoutePorts = builder.totalReservedRoutePorts;
    this.totalRoutes = builder.totalRoutes;
    this.totalServiceKeys = builder.totalServiceKeys;
    this.totalServices = builder.totalServices;
    this.trialDatabaseAllowed = builder.trialDatabaseAllowed;
    this.logRateLimit = builder.logRateLimit;
  }

  /**
   * The application instance limit
   */
  @JsonProperty("app_instance_limit")
  @Override
  public @Nullable Integer getApplicationInstanceLimit() {
    return applicationInstanceLimit;
  }

  /**
   * The application task limit
   */
  @JsonProperty("app_task_limit")
  @Override
  public @Nullable Integer getApplicationTaskLimit() {
    return applicationTaskLimit;
  }

  /**
   * The instance memory limit
   */
  @JsonProperty("instance_memory_limit")
  @Override
  public Integer getInstanceMemoryLimit() {
    return instanceMemoryLimit;
  }

  /**
   * The memory limit
   */
  @JsonProperty("memory_limit")
  @Override
  public Integer getMemoryLimit() {
    return memoryLimit;
  }

  /**
   * The name
   */
  @JsonProperty("name")
  @Override
  public String getName() {
    return name;
  }

  /**
   * The non basic services allowed
   */
  @JsonProperty("non_basic_services_allowed")
  @Override
  public Boolean getNonBasicServicesAllowed() {
    return nonBasicServicesAllowed;
  }

  /**
   * The total private domains
   */
  @JsonProperty("total_private_domains")
  @Override
  public @Nullable Integer getTotalPrivateDomains() {
    return totalPrivateDomains;
  }

  /**
   * The total reserved route ports
   */
  @JsonProperty("total_reserved_route_ports")
  @Override
  public @Nullable Integer getTotalReservedRoutePorts() {
    return totalReservedRoutePorts;
  }

  /**
   * The total routes
   */
  @JsonProperty("total_routes")
  @Override
  public Integer getTotalRoutes() {
    return totalRoutes;
  }

  /**
   * The total service keys
   */
  @JsonProperty("total_service_keys")
  @Override
  public @Nullable Integer getTotalServiceKeys() {
    return totalServiceKeys;
  }

  /**
   * The total services
   */
  @JsonProperty("total_services")
  @Override
  public Integer getTotalServices() {
    return totalServices;
  }

  /**
   * The trial db allowed
   */
  @JsonProperty("trial_db_allowed")
  @Deprecated
  @Override
  public @Nullable Boolean getTrialDatabaseAllowed() {
    return trialDatabaseAllowed;
  }

  /**
   * The log rate limit
   */
  @JsonProperty("log_rate_limit")
  @Override
  public @Nullable Integer getLogRateLimit() {
    return logRateLimit;
  }

  /**
   * This instance is equal to all instances of {@code CreateOrganizationQuotaDefinitionRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof CreateOrganizationQuotaDefinitionRequest
        && equalTo(0, (CreateOrganizationQuotaDefinitionRequest) another);
  }

  private boolean equalTo(int synthetic, CreateOrganizationQuotaDefinitionRequest another) {
    return Objects.equals(applicationInstanceLimit, another.applicationInstanceLimit)
        && Objects.equals(applicationTaskLimit, another.applicationTaskLimit)
        && instanceMemoryLimit.equals(another.instanceMemoryLimit)
        && memoryLimit.equals(another.memoryLimit)
        && name.equals(another.name)
        && nonBasicServicesAllowed.equals(another.nonBasicServicesAllowed)
        && Objects.equals(totalPrivateDomains, another.totalPrivateDomains)
        && Objects.equals(totalReservedRoutePorts, another.totalReservedRoutePorts)
        && totalRoutes.equals(another.totalRoutes)
        && Objects.equals(totalServiceKeys, another.totalServiceKeys)
        && totalServices.equals(another.totalServices)
        && Objects.equals(trialDatabaseAllowed, another.trialDatabaseAllowed)
        && Objects.equals(logRateLimit, another.logRateLimit);
  }

  /**
   * Computes a hash code from attributes: {@code applicationInstanceLimit}, {@code applicationTaskLimit}, {@code instanceMemoryLimit}, {@code memoryLimit}, {@code name}, {@code nonBasicServicesAllowed}, {@code totalPrivateDomains}, {@code totalReservedRoutePorts}, {@code totalRoutes}, {@code totalServiceKeys}, {@code totalServices}, {@code trialDatabaseAllowed}, {@code logRateLimit}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(applicationInstanceLimit);
    h += (h << 5) + Objects.hashCode(applicationTaskLimit);
    h += (h << 5) + instanceMemoryLimit.hashCode();
    h += (h << 5) + memoryLimit.hashCode();
    h += (h << 5) + name.hashCode();
    h += (h << 5) + nonBasicServicesAllowed.hashCode();
    h += (h << 5) + Objects.hashCode(totalPrivateDomains);
    h += (h << 5) + Objects.hashCode(totalReservedRoutePorts);
    h += (h << 5) + totalRoutes.hashCode();
    h += (h << 5) + Objects.hashCode(totalServiceKeys);
    h += (h << 5) + totalServices.hashCode();
    h += (h << 5) + Objects.hashCode(trialDatabaseAllowed);
    h += (h << 5) + Objects.hashCode(logRateLimit);
    return h;
  }

  /**
   * Prints the immutable value {@code CreateOrganizationQuotaDefinitionRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "CreateOrganizationQuotaDefinitionRequest{"
        + "applicationInstanceLimit=" + applicationInstanceLimit
        + ", applicationTaskLimit=" + applicationTaskLimit
        + ", instanceMemoryLimit=" + instanceMemoryLimit
        + ", memoryLimit=" + memoryLimit
        + ", name=" + name
        + ", nonBasicServicesAllowed=" + nonBasicServicesAllowed
        + ", totalPrivateDomains=" + totalPrivateDomains
        + ", totalReservedRoutePorts=" + totalReservedRoutePorts
        + ", totalRoutes=" + totalRoutes
        + ", totalServiceKeys=" + totalServiceKeys
        + ", totalServices=" + totalServices
        + ", trialDatabaseAllowed=" + trialDatabaseAllowed
        + ", logRateLimit=" + logRateLimit
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_CreateOrganizationQuotaDefinitionRequest", generator = "Immutables")
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json
      extends org.cloudfoundry.client.v2.organizationquotadefinitions._CreateOrganizationQuotaDefinitionRequest {
    Integer applicationInstanceLimit;
    Integer applicationTaskLimit;
    Integer instanceMemoryLimit;
    Integer memoryLimit;
    String name;
    Boolean nonBasicServicesAllowed;
    Integer totalPrivateDomains;
    Integer totalReservedRoutePorts;
    Integer totalRoutes;
    Integer totalServiceKeys;
    Integer totalServices;
    Boolean trialDatabaseAllowed;
    Integer logRateLimit;
    @JsonProperty("app_instance_limit")
    public void setApplicationInstanceLimit(@Nullable Integer applicationInstanceLimit) {
      this.applicationInstanceLimit = applicationInstanceLimit;
    }
    @JsonProperty("app_task_limit")
    public void setApplicationTaskLimit(@Nullable Integer applicationTaskLimit) {
      this.applicationTaskLimit = applicationTaskLimit;
    }
    @JsonProperty("instance_memory_limit")
    public void setInstanceMemoryLimit(Integer instanceMemoryLimit) {
      this.instanceMemoryLimit = instanceMemoryLimit;
    }
    @JsonProperty("memory_limit")
    public void setMemoryLimit(Integer memoryLimit) {
      this.memoryLimit = memoryLimit;
    }
    @JsonProperty("name")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty("non_basic_services_allowed")
    public void setNonBasicServicesAllowed(Boolean nonBasicServicesAllowed) {
      this.nonBasicServicesAllowed = nonBasicServicesAllowed;
    }
    @JsonProperty("total_private_domains")
    public void setTotalPrivateDomains(@Nullable Integer totalPrivateDomains) {
      this.totalPrivateDomains = totalPrivateDomains;
    }
    @JsonProperty("total_reserved_route_ports")
    public void setTotalReservedRoutePorts(@Nullable Integer totalReservedRoutePorts) {
      this.totalReservedRoutePorts = totalReservedRoutePorts;
    }
    @JsonProperty("total_routes")
    public void setTotalRoutes(Integer totalRoutes) {
      this.totalRoutes = totalRoutes;
    }
    @JsonProperty("total_service_keys")
    public void setTotalServiceKeys(@Nullable Integer totalServiceKeys) {
      this.totalServiceKeys = totalServiceKeys;
    }
    @JsonProperty("total_services")
    public void setTotalServices(Integer totalServices) {
      this.totalServices = totalServices;
    }
    @JsonProperty("trial_db_allowed")
    public void setTrialDatabaseAllowed(@Nullable Boolean trialDatabaseAllowed) {
      this.trialDatabaseAllowed = trialDatabaseAllowed;
    }
    @JsonProperty("log_rate_limit")
    public void setLogRateLimit(@Nullable Integer logRateLimit) {
      this.logRateLimit = logRateLimit;
    }
    @Override
    public Integer getApplicationInstanceLimit() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getApplicationTaskLimit() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getInstanceMemoryLimit() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getMemoryLimit() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getNonBasicServicesAllowed() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getTotalPrivateDomains() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getTotalReservedRoutePorts() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getTotalRoutes() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getTotalServiceKeys() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getTotalServices() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getTrialDatabaseAllowed() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getLogRateLimit() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static CreateOrganizationQuotaDefinitionRequest fromJson(Json json) {
    CreateOrganizationQuotaDefinitionRequest.Builder builder = CreateOrganizationQuotaDefinitionRequest.builder();
    if (json.applicationInstanceLimit != null) {
      builder.applicationInstanceLimit(json.applicationInstanceLimit);
    }
    if (json.applicationTaskLimit != null) {
      builder.applicationTaskLimit(json.applicationTaskLimit);
    }
    if (json.instanceMemoryLimit != null) {
      builder.instanceMemoryLimit(json.instanceMemoryLimit);
    }
    if (json.memoryLimit != null) {
      builder.memoryLimit(json.memoryLimit);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.nonBasicServicesAllowed != null) {
      builder.nonBasicServicesAllowed(json.nonBasicServicesAllowed);
    }
    if (json.totalPrivateDomains != null) {
      builder.totalPrivateDomains(json.totalPrivateDomains);
    }
    if (json.totalReservedRoutePorts != null) {
      builder.totalReservedRoutePorts(json.totalReservedRoutePorts);
    }
    if (json.totalRoutes != null) {
      builder.totalRoutes(json.totalRoutes);
    }
    if (json.totalServiceKeys != null) {
      builder.totalServiceKeys(json.totalServiceKeys);
    }
    if (json.totalServices != null) {
      builder.totalServices(json.totalServices);
    }
    if (json.trialDatabaseAllowed != null) {
      builder.trialDatabaseAllowed(json.trialDatabaseAllowed);
    }
    if (json.logRateLimit != null) {
      builder.logRateLimit(json.logRateLimit);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link CreateOrganizationQuotaDefinitionRequest CreateOrganizationQuotaDefinitionRequest}.
   * <pre>
   * CreateOrganizationQuotaDefinitionRequest.builder()
   *    .applicationInstanceLimit(Integer | null) // nullable {@link CreateOrganizationQuotaDefinitionRequest#getApplicationInstanceLimit() applicationInstanceLimit}
   *    .applicationTaskLimit(Integer | null) // nullable {@link CreateOrganizationQuotaDefinitionRequest#getApplicationTaskLimit() applicationTaskLimit}
   *    .instanceMemoryLimit(Integer) // required {@link CreateOrganizationQuotaDefinitionRequest#getInstanceMemoryLimit() instanceMemoryLimit}
   *    .memoryLimit(Integer) // required {@link CreateOrganizationQuotaDefinitionRequest#getMemoryLimit() memoryLimit}
   *    .name(String) // required {@link CreateOrganizationQuotaDefinitionRequest#getName() name}
   *    .nonBasicServicesAllowed(Boolean) // required {@link CreateOrganizationQuotaDefinitionRequest#getNonBasicServicesAllowed() nonBasicServicesAllowed}
   *    .totalPrivateDomains(Integer | null) // nullable {@link CreateOrganizationQuotaDefinitionRequest#getTotalPrivateDomains() totalPrivateDomains}
   *    .totalReservedRoutePorts(Integer | null) // nullable {@link CreateOrganizationQuotaDefinitionRequest#getTotalReservedRoutePorts() totalReservedRoutePorts}
   *    .totalRoutes(Integer) // required {@link CreateOrganizationQuotaDefinitionRequest#getTotalRoutes() totalRoutes}
   *    .totalServiceKeys(Integer | null) // nullable {@link CreateOrganizationQuotaDefinitionRequest#getTotalServiceKeys() totalServiceKeys}
   *    .totalServices(Integer) // required {@link CreateOrganizationQuotaDefinitionRequest#getTotalServices() totalServices}
   *    .trialDatabaseAllowed(Boolean | null) // nullable {@link CreateOrganizationQuotaDefinitionRequest#getTrialDatabaseAllowed() trialDatabaseAllowed}
   *    .logRateLimit(Integer | null) // nullable {@link CreateOrganizationQuotaDefinitionRequest#getLogRateLimit() logRateLimit}
   *    .build();
   * </pre>
   * @return A new CreateOrganizationQuotaDefinitionRequest builder
   */
  public static CreateOrganizationQuotaDefinitionRequest.Builder builder() {
    return new CreateOrganizationQuotaDefinitionRequest.Builder();
  }

  /**
   * Builds instances of type {@link CreateOrganizationQuotaDefinitionRequest CreateOrganizationQuotaDefinitionRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_CreateOrganizationQuotaDefinitionRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_INSTANCE_MEMORY_LIMIT = 0x1L;
    private static final long INIT_BIT_MEMORY_LIMIT = 0x2L;
    private static final long INIT_BIT_NAME = 0x4L;
    private static final long INIT_BIT_NON_BASIC_SERVICES_ALLOWED = 0x8L;
    private static final long INIT_BIT_TOTAL_ROUTES = 0x10L;
    private static final long INIT_BIT_TOTAL_SERVICES = 0x20L;
    private long initBits = 0x3fL;

    private Integer applicationInstanceLimit;
    private Integer applicationTaskLimit;
    private Integer instanceMemoryLimit;
    private Integer memoryLimit;
    private String name;
    private Boolean nonBasicServicesAllowed;
    private Integer totalPrivateDomains;
    private Integer totalReservedRoutePorts;
    private Integer totalRoutes;
    private Integer totalServiceKeys;
    private Integer totalServices;
    private Boolean trialDatabaseAllowed;
    private Integer logRateLimit;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CreateOrganizationQuotaDefinitionRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(CreateOrganizationQuotaDefinitionRequest instance) {
      return from((_CreateOrganizationQuotaDefinitionRequest) instance);
    }

    /**
     * Copy abstract value type {@code _CreateOrganizationQuotaDefinitionRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_CreateOrganizationQuotaDefinitionRequest instance) {
      Objects.requireNonNull(instance, "instance");
      Integer applicationInstanceLimitValue = instance.getApplicationInstanceLimit();
      if (applicationInstanceLimitValue != null) {
        applicationInstanceLimit(applicationInstanceLimitValue);
      }
      Integer applicationTaskLimitValue = instance.getApplicationTaskLimit();
      if (applicationTaskLimitValue != null) {
        applicationTaskLimit(applicationTaskLimitValue);
      }
      this.instanceMemoryLimit(instance.getInstanceMemoryLimit());
      this.memoryLimit(instance.getMemoryLimit());
      this.name(instance.getName());
      this.nonBasicServicesAllowed(instance.getNonBasicServicesAllowed());
      Integer totalPrivateDomainsValue = instance.getTotalPrivateDomains();
      if (totalPrivateDomainsValue != null) {
        totalPrivateDomains(totalPrivateDomainsValue);
      }
      Integer totalReservedRoutePortsValue = instance.getTotalReservedRoutePorts();
      if (totalReservedRoutePortsValue != null) {
        totalReservedRoutePorts(totalReservedRoutePortsValue);
      }
      this.totalRoutes(instance.getTotalRoutes());
      Integer totalServiceKeysValue = instance.getTotalServiceKeys();
      if (totalServiceKeysValue != null) {
        totalServiceKeys(totalServiceKeysValue);
      }
      this.totalServices(instance.getTotalServices());
      Boolean trialDatabaseAllowedValue = instance.getTrialDatabaseAllowed();
      if (trialDatabaseAllowedValue != null) {
        trialDatabaseAllowed(trialDatabaseAllowedValue);
      }
      Integer logRateLimitValue = instance.getLogRateLimit();
      if (logRateLimitValue != null) {
        logRateLimit(logRateLimitValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link CreateOrganizationQuotaDefinitionRequest#getApplicationInstanceLimit() applicationInstanceLimit} attribute.
     * @param applicationInstanceLimit The value for applicationInstanceLimit (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationInstanceLimit(@Nullable Integer applicationInstanceLimit) {
      this.applicationInstanceLimit = applicationInstanceLimit;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateOrganizationQuotaDefinitionRequest#getApplicationTaskLimit() applicationTaskLimit} attribute.
     * @param applicationTaskLimit The value for applicationTaskLimit (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationTaskLimit(@Nullable Integer applicationTaskLimit) {
      this.applicationTaskLimit = applicationTaskLimit;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateOrganizationQuotaDefinitionRequest#getInstanceMemoryLimit() instanceMemoryLimit} attribute.
     * @param instanceMemoryLimit The value for instanceMemoryLimit 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder instanceMemoryLimit(Integer instanceMemoryLimit) {
      this.instanceMemoryLimit = Objects.requireNonNull(instanceMemoryLimit, "instanceMemoryLimit");
      initBits &= ~INIT_BIT_INSTANCE_MEMORY_LIMIT;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateOrganizationQuotaDefinitionRequest#getMemoryLimit() memoryLimit} attribute.
     * @param memoryLimit The value for memoryLimit 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder memoryLimit(Integer memoryLimit) {
      this.memoryLimit = Objects.requireNonNull(memoryLimit, "memoryLimit");
      initBits &= ~INIT_BIT_MEMORY_LIMIT;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateOrganizationQuotaDefinitionRequest#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateOrganizationQuotaDefinitionRequest#getNonBasicServicesAllowed() nonBasicServicesAllowed} attribute.
     * @param nonBasicServicesAllowed The value for nonBasicServicesAllowed 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder nonBasicServicesAllowed(Boolean nonBasicServicesAllowed) {
      this.nonBasicServicesAllowed = Objects.requireNonNull(nonBasicServicesAllowed, "nonBasicServicesAllowed");
      initBits &= ~INIT_BIT_NON_BASIC_SERVICES_ALLOWED;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateOrganizationQuotaDefinitionRequest#getTotalPrivateDomains() totalPrivateDomains} attribute.
     * @param totalPrivateDomains The value for totalPrivateDomains (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder totalPrivateDomains(@Nullable Integer totalPrivateDomains) {
      this.totalPrivateDomains = totalPrivateDomains;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateOrganizationQuotaDefinitionRequest#getTotalReservedRoutePorts() totalReservedRoutePorts} attribute.
     * @param totalReservedRoutePorts The value for totalReservedRoutePorts (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder totalReservedRoutePorts(@Nullable Integer totalReservedRoutePorts) {
      this.totalReservedRoutePorts = totalReservedRoutePorts;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateOrganizationQuotaDefinitionRequest#getTotalRoutes() totalRoutes} attribute.
     * @param totalRoutes The value for totalRoutes 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder totalRoutes(Integer totalRoutes) {
      this.totalRoutes = Objects.requireNonNull(totalRoutes, "totalRoutes");
      initBits &= ~INIT_BIT_TOTAL_ROUTES;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateOrganizationQuotaDefinitionRequest#getTotalServiceKeys() totalServiceKeys} attribute.
     * @param totalServiceKeys The value for totalServiceKeys (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder totalServiceKeys(@Nullable Integer totalServiceKeys) {
      this.totalServiceKeys = totalServiceKeys;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateOrganizationQuotaDefinitionRequest#getTotalServices() totalServices} attribute.
     * @param totalServices The value for totalServices 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder totalServices(Integer totalServices) {
      this.totalServices = Objects.requireNonNull(totalServices, "totalServices");
      initBits &= ~INIT_BIT_TOTAL_SERVICES;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateOrganizationQuotaDefinitionRequest#getTrialDatabaseAllowed() trialDatabaseAllowed} attribute.
     * @param trialDatabaseAllowed The value for trialDatabaseAllowed (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @Deprecated
    public final Builder trialDatabaseAllowed(@Nullable Boolean trialDatabaseAllowed) {
      this.trialDatabaseAllowed = trialDatabaseAllowed;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateOrganizationQuotaDefinitionRequest#getLogRateLimit() logRateLimit} attribute.
     * @param logRateLimit The value for logRateLimit (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder logRateLimit(@Nullable Integer logRateLimit) {
      this.logRateLimit = logRateLimit;
      return this;
    }

    /**
     * Builds a new {@link CreateOrganizationQuotaDefinitionRequest CreateOrganizationQuotaDefinitionRequest}.
     * @return An immutable instance of CreateOrganizationQuotaDefinitionRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public CreateOrganizationQuotaDefinitionRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new CreateOrganizationQuotaDefinitionRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_INSTANCE_MEMORY_LIMIT) != 0) attributes.add("instanceMemoryLimit");
      if ((initBits & INIT_BIT_MEMORY_LIMIT) != 0) attributes.add("memoryLimit");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_NON_BASIC_SERVICES_ALLOWED) != 0) attributes.add("nonBasicServicesAllowed");
      if ((initBits & INIT_BIT_TOTAL_ROUTES) != 0) attributes.add("totalRoutes");
      if ((initBits & INIT_BIT_TOTAL_SERVICES) != 0) attributes.add("totalServices");
      return "Cannot build CreateOrganizationQuotaDefinitionRequest, some of required attributes are not set " + attributes;
    }
  }
}
