package org.cloudfoundry.client.v2.organizations;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.OrderDirection;
import org.cloudfoundry.client.v2.PaginatedRequest;
import org.immutables.value.Generated;

/**
 * The request payload for the List all Space Quota Definitions for the Organization operation
 */
@Generated(from = "_ListOrganizationSpaceQuotaDefinitionsRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ListOrganizationSpaceQuotaDefinitionsRequest
    extends org.cloudfoundry.client.v2.organizations._ListOrganizationSpaceQuotaDefinitionsRequest {
  private final @Nullable OrderDirection orderDirection;
  private final @Nullable Integer page;
  private final @Nullable Integer resultsPerPage;
  private final String organizationId;

  private ListOrganizationSpaceQuotaDefinitionsRequest(ListOrganizationSpaceQuotaDefinitionsRequest.Builder builder) {
    this.orderDirection = builder.orderDirection;
    this.page = builder.page;
    this.resultsPerPage = builder.resultsPerPage;
    this.organizationId = builder.organizationId;
  }

  /**
   * The order direction
   */
  @Override
  public @Nullable OrderDirection getOrderDirection() {
    return orderDirection;
  }

  /**
   * The page
   */
  @Override
  public @Nullable Integer getPage() {
    return page;
  }

  /**
   * The results per page
   */
  @Override
  public @Nullable Integer getResultsPerPage() {
    return resultsPerPage;
  }

  /**
   * The organization id
   */
  @Override
  public String getOrganizationId() {
    return organizationId;
  }

  /**
   * This instance is equal to all instances of {@code ListOrganizationSpaceQuotaDefinitionsRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ListOrganizationSpaceQuotaDefinitionsRequest
        && equalTo(0, (ListOrganizationSpaceQuotaDefinitionsRequest) another);
  }

  private boolean equalTo(int synthetic, ListOrganizationSpaceQuotaDefinitionsRequest another) {
    return Objects.equals(orderDirection, another.orderDirection)
        && Objects.equals(page, another.page)
        && Objects.equals(resultsPerPage, another.resultsPerPage)
        && organizationId.equals(another.organizationId);
  }

  /**
   * Computes a hash code from attributes: {@code orderDirection}, {@code page}, {@code resultsPerPage}, {@code organizationId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(orderDirection);
    h += (h << 5) + Objects.hashCode(page);
    h += (h << 5) + Objects.hashCode(resultsPerPage);
    h += (h << 5) + organizationId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ListOrganizationSpaceQuotaDefinitionsRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ListOrganizationSpaceQuotaDefinitionsRequest{"
        + "orderDirection=" + orderDirection
        + ", page=" + page
        + ", resultsPerPage=" + resultsPerPage
        + ", organizationId=" + organizationId
        + "}";
  }

  /**
   * Creates a builder for {@link ListOrganizationSpaceQuotaDefinitionsRequest ListOrganizationSpaceQuotaDefinitionsRequest}.
   * <pre>
   * ListOrganizationSpaceQuotaDefinitionsRequest.builder()
   *    .orderDirection(org.cloudfoundry.client.v2.OrderDirection | null) // nullable {@link ListOrganizationSpaceQuotaDefinitionsRequest#getOrderDirection() orderDirection}
   *    .page(Integer | null) // nullable {@link ListOrganizationSpaceQuotaDefinitionsRequest#getPage() page}
   *    .resultsPerPage(Integer | null) // nullable {@link ListOrganizationSpaceQuotaDefinitionsRequest#getResultsPerPage() resultsPerPage}
   *    .organizationId(String) // required {@link ListOrganizationSpaceQuotaDefinitionsRequest#getOrganizationId() organizationId}
   *    .build();
   * </pre>
   * @return A new ListOrganizationSpaceQuotaDefinitionsRequest builder
   */
  public static ListOrganizationSpaceQuotaDefinitionsRequest.Builder builder() {
    return new ListOrganizationSpaceQuotaDefinitionsRequest.Builder();
  }

  /**
   * Builds instances of type {@link ListOrganizationSpaceQuotaDefinitionsRequest ListOrganizationSpaceQuotaDefinitionsRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ListOrganizationSpaceQuotaDefinitionsRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_ORGANIZATION_ID = 0x1L;
    private long initBits = 0x1L;

    private OrderDirection orderDirection;
    private Integer page;
    private Integer resultsPerPage;
    private String organizationId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ListOrganizationSpaceQuotaDefinitionsRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ListOrganizationSpaceQuotaDefinitionsRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _ListOrganizationSpaceQuotaDefinitionsRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_ListOrganizationSpaceQuotaDefinitionsRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v2.PaginatedRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PaginatedRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    private void from(short _unused, Object object) {
      if (object instanceof org.cloudfoundry.client.v2.organizations._ListOrganizationSpaceQuotaDefinitionsRequest) {
        org.cloudfoundry.client.v2.organizations._ListOrganizationSpaceQuotaDefinitionsRequest instance = (org.cloudfoundry.client.v2.organizations._ListOrganizationSpaceQuotaDefinitionsRequest) object;
        this.organizationId(instance.getOrganizationId());
      }
      if (object instanceof PaginatedRequest) {
        PaginatedRequest instance = (PaginatedRequest) object;
        OrderDirection orderDirectionValue = instance.getOrderDirection();
        if (orderDirectionValue != null) {
          orderDirection(orderDirectionValue);
        }
        Integer resultsPerPageValue = instance.getResultsPerPage();
        if (resultsPerPageValue != null) {
          resultsPerPage(resultsPerPageValue);
        }
        Integer pageValue = instance.getPage();
        if (pageValue != null) {
          page(pageValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link ListOrganizationSpaceQuotaDefinitionsRequest#getOrderDirection() orderDirection} attribute.
     * @param orderDirection The value for orderDirection (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder orderDirection(@Nullable OrderDirection orderDirection) {
      this.orderDirection = orderDirection;
      return this;
    }

    /**
     * Initializes the value for the {@link ListOrganizationSpaceQuotaDefinitionsRequest#getPage() page} attribute.
     * @param page The value for page (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder page(@Nullable Integer page) {
      this.page = page;
      return this;
    }

    /**
     * Initializes the value for the {@link ListOrganizationSpaceQuotaDefinitionsRequest#getResultsPerPage() resultsPerPage} attribute.
     * @param resultsPerPage The value for resultsPerPage (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder resultsPerPage(@Nullable Integer resultsPerPage) {
      this.resultsPerPage = resultsPerPage;
      return this;
    }

    /**
     * Initializes the value for the {@link ListOrganizationSpaceQuotaDefinitionsRequest#getOrganizationId() organizationId} attribute.
     * @param organizationId The value for organizationId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationId(String organizationId) {
      this.organizationId = Objects.requireNonNull(organizationId, "organizationId");
      initBits &= ~INIT_BIT_ORGANIZATION_ID;
      return this;
    }

    /**
     * Builds a new {@link ListOrganizationSpaceQuotaDefinitionsRequest ListOrganizationSpaceQuotaDefinitionsRequest}.
     * @return An immutable instance of ListOrganizationSpaceQuotaDefinitionsRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ListOrganizationSpaceQuotaDefinitionsRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ListOrganizationSpaceQuotaDefinitionsRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ORGANIZATION_ID) != 0) attributes.add("organizationId");
      return "Cannot build ListOrganizationSpaceQuotaDefinitionsRequest, some of required attributes are not set " + attributes;
    }
  }
}
