package org.cloudfoundry.client.v2.organizations;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * The request payload for the Remove Auditor from the Organization operation
 */
@Generated(from = "_RemoveOrganizationAuditorRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class RemoveOrganizationAuditorRequest
    extends org.cloudfoundry.client.v2.organizations._RemoveOrganizationAuditorRequest {
  private final String auditorId;
  private final String organizationId;

  private RemoveOrganizationAuditorRequest(RemoveOrganizationAuditorRequest.Builder builder) {
    this.auditorId = builder.auditorId;
    this.organizationId = builder.organizationId;
  }

  /**
   * The auditor id
   */
  @Override
  public String getAuditorId() {
    return auditorId;
  }

  /**
   * The organization id
   */
  @Override
  public String getOrganizationId() {
    return organizationId;
  }

  /**
   * This instance is equal to all instances of {@code RemoveOrganizationAuditorRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof RemoveOrganizationAuditorRequest
        && equalTo(0, (RemoveOrganizationAuditorRequest) another);
  }

  private boolean equalTo(int synthetic, RemoveOrganizationAuditorRequest another) {
    return auditorId.equals(another.auditorId)
        && organizationId.equals(another.organizationId);
  }

  /**
   * Computes a hash code from attributes: {@code auditorId}, {@code organizationId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + auditorId.hashCode();
    h += (h << 5) + organizationId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code RemoveOrganizationAuditorRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "RemoveOrganizationAuditorRequest{"
        + "auditorId=" + auditorId
        + ", organizationId=" + organizationId
        + "}";
  }

  /**
   * Creates a builder for {@link RemoveOrganizationAuditorRequest RemoveOrganizationAuditorRequest}.
   * <pre>
   * RemoveOrganizationAuditorRequest.builder()
   *    .auditorId(String) // required {@link RemoveOrganizationAuditorRequest#getAuditorId() auditorId}
   *    .organizationId(String) // required {@link RemoveOrganizationAuditorRequest#getOrganizationId() organizationId}
   *    .build();
   * </pre>
   * @return A new RemoveOrganizationAuditorRequest builder
   */
  public static RemoveOrganizationAuditorRequest.Builder builder() {
    return new RemoveOrganizationAuditorRequest.Builder();
  }

  /**
   * Builds instances of type {@link RemoveOrganizationAuditorRequest RemoveOrganizationAuditorRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_RemoveOrganizationAuditorRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_AUDITOR_ID = 0x1L;
    private static final long INIT_BIT_ORGANIZATION_ID = 0x2L;
    private long initBits = 0x3L;

    private String auditorId;
    private String organizationId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code RemoveOrganizationAuditorRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(RemoveOrganizationAuditorRequest instance) {
      return from((_RemoveOrganizationAuditorRequest) instance);
    }

    /**
     * Copy abstract value type {@code _RemoveOrganizationAuditorRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_RemoveOrganizationAuditorRequest instance) {
      Objects.requireNonNull(instance, "instance");
      this.auditorId(instance.getAuditorId());
      this.organizationId(instance.getOrganizationId());
      return this;
    }

    /**
     * Initializes the value for the {@link RemoveOrganizationAuditorRequest#getAuditorId() auditorId} attribute.
     * @param auditorId The value for auditorId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder auditorId(String auditorId) {
      this.auditorId = Objects.requireNonNull(auditorId, "auditorId");
      initBits &= ~INIT_BIT_AUDITOR_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link RemoveOrganizationAuditorRequest#getOrganizationId() organizationId} attribute.
     * @param organizationId The value for organizationId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationId(String organizationId) {
      this.organizationId = Objects.requireNonNull(organizationId, "organizationId");
      initBits &= ~INIT_BIT_ORGANIZATION_ID;
      return this;
    }

    /**
     * Builds a new {@link RemoveOrganizationAuditorRequest RemoveOrganizationAuditorRequest}.
     * @return An immutable instance of RemoveOrganizationAuditorRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public RemoveOrganizationAuditorRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new RemoveOrganizationAuditorRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_AUDITOR_ID) != 0) attributes.add("auditorId");
      if ((initBits & INIT_BIT_ORGANIZATION_ID) != 0) attributes.add("organizationId");
      return "Cannot build RemoveOrganizationAuditorRequest, some of required attributes are not set " + attributes;
    }
  }
}
