package org.cloudfoundry.client.v2.routes;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * The request payload for the Check a Route exists operation
 */
@Generated(from = "_RouteExistsRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class RouteExistsRequest extends org.cloudfoundry.client.v2.routes._RouteExistsRequest {
  private final String domainId;
  private final @Nullable String host;
  private final @Nullable String path;

  private RouteExistsRequest(RouteExistsRequest.Builder builder) {
    this.domainId = builder.domainId;
    this.host = builder.host;
    this.path = builder.path;
  }

  /**
   * The domain id
   */
  @Override
  public String getDomainId() {
    return domainId;
  }

  /**
   * The host
   */
  @Override
  public @Nullable String getHost() {
    return host;
  }

  /**
   * The path
   */
  @Override
  public @Nullable String getPath() {
    return path;
  }

  /**
   * This instance is equal to all instances of {@code RouteExistsRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof RouteExistsRequest
        && equalTo(0, (RouteExistsRequest) another);
  }

  private boolean equalTo(int synthetic, RouteExistsRequest another) {
    return domainId.equals(another.domainId)
        && Objects.equals(host, another.host)
        && Objects.equals(path, another.path);
  }

  /**
   * Computes a hash code from attributes: {@code domainId}, {@code host}, {@code path}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + domainId.hashCode();
    h += (h << 5) + Objects.hashCode(host);
    h += (h << 5) + Objects.hashCode(path);
    return h;
  }

  /**
   * Prints the immutable value {@code RouteExistsRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "RouteExistsRequest{"
        + "domainId=" + domainId
        + ", host=" + host
        + ", path=" + path
        + "}";
  }

  /**
   * Creates a builder for {@link RouteExistsRequest RouteExistsRequest}.
   * <pre>
   * RouteExistsRequest.builder()
   *    .domainId(String) // required {@link RouteExistsRequest#getDomainId() domainId}
   *    .host(String | null) // nullable {@link RouteExistsRequest#getHost() host}
   *    .path(String | null) // nullable {@link RouteExistsRequest#getPath() path}
   *    .build();
   * </pre>
   * @return A new RouteExistsRequest builder
   */
  public static RouteExistsRequest.Builder builder() {
    return new RouteExistsRequest.Builder();
  }

  /**
   * Builds instances of type {@link RouteExistsRequest RouteExistsRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_RouteExistsRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_DOMAIN_ID = 0x1L;
    private long initBits = 0x1L;

    private String domainId;
    private String host;
    private String path;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code RouteExistsRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(RouteExistsRequest instance) {
      return from((_RouteExistsRequest) instance);
    }

    /**
     * Copy abstract value type {@code _RouteExistsRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_RouteExistsRequest instance) {
      Objects.requireNonNull(instance, "instance");
      this.domainId(instance.getDomainId());
      String hostValue = instance.getHost();
      if (hostValue != null) {
        host(hostValue);
      }
      String pathValue = instance.getPath();
      if (pathValue != null) {
        path(pathValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link RouteExistsRequest#getDomainId() domainId} attribute.
     * @param domainId The value for domainId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder domainId(String domainId) {
      this.domainId = Objects.requireNonNull(domainId, "domainId");
      initBits &= ~INIT_BIT_DOMAIN_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link RouteExistsRequest#getHost() host} attribute.
     * @param host The value for host (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder host(@Nullable String host) {
      this.host = host;
      return this;
    }

    /**
     * Initializes the value for the {@link RouteExistsRequest#getPath() path} attribute.
     * @param path The value for path (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder path(@Nullable String path) {
      this.path = path;
      return this;
    }

    /**
     * Builds a new {@link RouteExistsRequest RouteExistsRequest}.
     * @return An immutable instance of RouteExistsRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public RouteExistsRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new RouteExistsRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_DOMAIN_ID) != 0) attributes.add("domainId");
      return "Cannot build RouteExistsRequest, some of required attributes are not set " + attributes;
    }
  }
}
