package org.cloudfoundry.client.v2.securitygroups;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * The request payload for the Remove Security Group Staging Default operation
 */
@Generated(from = "_RemoveSecurityGroupStagingDefaultRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class RemoveSecurityGroupStagingDefaultRequest
    extends org.cloudfoundry.client.v2.securitygroups._RemoveSecurityGroupStagingDefaultRequest {
  private final String securityGroupId;

  private RemoveSecurityGroupStagingDefaultRequest(RemoveSecurityGroupStagingDefaultRequest.Builder builder) {
    this.securityGroupId = builder.securityGroupId;
  }

  /**
   * The security group id
   */
  @Override
  public String getSecurityGroupId() {
    return securityGroupId;
  }

  /**
   * This instance is equal to all instances of {@code RemoveSecurityGroupStagingDefaultRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof RemoveSecurityGroupStagingDefaultRequest
        && equalTo(0, (RemoveSecurityGroupStagingDefaultRequest) another);
  }

  private boolean equalTo(int synthetic, RemoveSecurityGroupStagingDefaultRequest another) {
    return securityGroupId.equals(another.securityGroupId);
  }

  /**
   * Computes a hash code from attributes: {@code securityGroupId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + securityGroupId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code RemoveSecurityGroupStagingDefaultRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "RemoveSecurityGroupStagingDefaultRequest{"
        + "securityGroupId=" + securityGroupId
        + "}";
  }

  /**
   * Creates a builder for {@link RemoveSecurityGroupStagingDefaultRequest RemoveSecurityGroupStagingDefaultRequest}.
   * <pre>
   * RemoveSecurityGroupStagingDefaultRequest.builder()
   *    .securityGroupId(String) // required {@link RemoveSecurityGroupStagingDefaultRequest#getSecurityGroupId() securityGroupId}
   *    .build();
   * </pre>
   * @return A new RemoveSecurityGroupStagingDefaultRequest builder
   */
  public static RemoveSecurityGroupStagingDefaultRequest.Builder builder() {
    return new RemoveSecurityGroupStagingDefaultRequest.Builder();
  }

  /**
   * Builds instances of type {@link RemoveSecurityGroupStagingDefaultRequest RemoveSecurityGroupStagingDefaultRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_RemoveSecurityGroupStagingDefaultRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_SECURITY_GROUP_ID = 0x1L;
    private long initBits = 0x1L;

    private String securityGroupId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code RemoveSecurityGroupStagingDefaultRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(RemoveSecurityGroupStagingDefaultRequest instance) {
      return from((_RemoveSecurityGroupStagingDefaultRequest) instance);
    }

    /**
     * Copy abstract value type {@code _RemoveSecurityGroupStagingDefaultRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_RemoveSecurityGroupStagingDefaultRequest instance) {
      Objects.requireNonNull(instance, "instance");
      this.securityGroupId(instance.getSecurityGroupId());
      return this;
    }

    /**
     * Initializes the value for the {@link RemoveSecurityGroupStagingDefaultRequest#getSecurityGroupId() securityGroupId} attribute.
     * @param securityGroupId The value for securityGroupId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder securityGroupId(String securityGroupId) {
      this.securityGroupId = Objects.requireNonNull(securityGroupId, "securityGroupId");
      initBits &= ~INIT_BIT_SECURITY_GROUP_ID;
      return this;
    }

    /**
     * Builds a new {@link RemoveSecurityGroupStagingDefaultRequest RemoveSecurityGroupStagingDefaultRequest}.
     * @return An immutable instance of RemoveSecurityGroupStagingDefaultRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public RemoveSecurityGroupStagingDefaultRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new RemoveSecurityGroupStagingDefaultRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_SECURITY_GROUP_ID) != 0) attributes.add("securityGroupId");
      return "Cannot build RemoveSecurityGroupStagingDefaultRequest, some of required attributes are not set " + attributes;
    }
  }
}
