package org.cloudfoundry.client.v2.servicebindings;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.OrderDirection;
import org.cloudfoundry.client.v2.PaginatedRequest;
import org.immutables.value.Generated;

/**
 * The request payload for the List all Service bindings operation
 */
@Generated(from = "_ListServiceBindingsRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ListServiceBindingsRequest
    extends org.cloudfoundry.client.v2.servicebindings._ListServiceBindingsRequest {
  private final @Nullable OrderDirection orderDirection;
  private final @Nullable Integer page;
  private final @Nullable Integer resultsPerPage;
  private final @Nullable List<String> applicationIds;
  private final @Nullable List<String> serviceInstanceIds;

  private ListServiceBindingsRequest(ListServiceBindingsRequest.Builder builder) {
    this.orderDirection = builder.orderDirection;
    this.page = builder.page;
    this.resultsPerPage = builder.resultsPerPage;
    this.applicationIds = builder.applicationIds == null ? null : createUnmodifiableList(true, builder.applicationIds);
    this.serviceInstanceIds = builder.serviceInstanceIds == null ? null : createUnmodifiableList(true, builder.serviceInstanceIds);
  }

  /**
   * The order direction
   */
  @Override
  public @Nullable OrderDirection getOrderDirection() {
    return orderDirection;
  }

  /**
   * The page
   */
  @Override
  public @Nullable Integer getPage() {
    return page;
  }

  /**
   * The results per page
   */
  @Override
  public @Nullable Integer getResultsPerPage() {
    return resultsPerPage;
  }

  /**
   * The application ids
   */
  @Override
  public @Nullable List<String> getApplicationIds() {
    return applicationIds;
  }

  /**
   * The service instance ids
   */
  @Override
  public @Nullable List<String> getServiceInstanceIds() {
    return serviceInstanceIds;
  }

  /**
   * This instance is equal to all instances of {@code ListServiceBindingsRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ListServiceBindingsRequest
        && equalTo(0, (ListServiceBindingsRequest) another);
  }

  private boolean equalTo(int synthetic, ListServiceBindingsRequest another) {
    return Objects.equals(orderDirection, another.orderDirection)
        && Objects.equals(page, another.page)
        && Objects.equals(resultsPerPage, another.resultsPerPage)
        && Objects.equals(applicationIds, another.applicationIds)
        && Objects.equals(serviceInstanceIds, another.serviceInstanceIds);
  }

  /**
   * Computes a hash code from attributes: {@code orderDirection}, {@code page}, {@code resultsPerPage}, {@code applicationIds}, {@code serviceInstanceIds}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(orderDirection);
    h += (h << 5) + Objects.hashCode(page);
    h += (h << 5) + Objects.hashCode(resultsPerPage);
    h += (h << 5) + Objects.hashCode(applicationIds);
    h += (h << 5) + Objects.hashCode(serviceInstanceIds);
    return h;
  }

  /**
   * Prints the immutable value {@code ListServiceBindingsRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ListServiceBindingsRequest{"
        + "orderDirection=" + orderDirection
        + ", page=" + page
        + ", resultsPerPage=" + resultsPerPage
        + ", applicationIds=" + applicationIds
        + ", serviceInstanceIds=" + serviceInstanceIds
        + "}";
  }

  /**
   * Creates a builder for {@link ListServiceBindingsRequest ListServiceBindingsRequest}.
   * <pre>
   * ListServiceBindingsRequest.builder()
   *    .orderDirection(org.cloudfoundry.client.v2.OrderDirection | null) // nullable {@link ListServiceBindingsRequest#getOrderDirection() orderDirection}
   *    .page(Integer | null) // nullable {@link ListServiceBindingsRequest#getPage() page}
   *    .resultsPerPage(Integer | null) // nullable {@link ListServiceBindingsRequest#getResultsPerPage() resultsPerPage}
   *    .applicationIds(List&amp;lt;String&amp;gt; | null) // nullable {@link ListServiceBindingsRequest#getApplicationIds() applicationIds}
   *    .serviceInstanceIds(List&amp;lt;String&amp;gt; | null) // nullable {@link ListServiceBindingsRequest#getServiceInstanceIds() serviceInstanceIds}
   *    .build();
   * </pre>
   * @return A new ListServiceBindingsRequest builder
   */
  public static ListServiceBindingsRequest.Builder builder() {
    return new ListServiceBindingsRequest.Builder();
  }

  /**
   * Builds instances of type {@link ListServiceBindingsRequest ListServiceBindingsRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ListServiceBindingsRequest", generator = "Immutables")
  public static final class Builder {
    private OrderDirection orderDirection;
    private Integer page;
    private Integer resultsPerPage;
    private List<String> applicationIds = null;
    private List<String> serviceInstanceIds = null;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ListServiceBindingsRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ListServiceBindingsRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _ListServiceBindingsRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_ListServiceBindingsRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v2.PaginatedRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PaginatedRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    private void from(short _unused, Object object) {
      if (object instanceof org.cloudfoundry.client.v2.servicebindings._ListServiceBindingsRequest) {
        org.cloudfoundry.client.v2.servicebindings._ListServiceBindingsRequest instance = (org.cloudfoundry.client.v2.servicebindings._ListServiceBindingsRequest) object;
        List<String> applicationIdsValue = instance.getApplicationIds();
        if (applicationIdsValue != null) {
          addAllApplicationIds(applicationIdsValue);
        }
        List<String> serviceInstanceIdsValue = instance.getServiceInstanceIds();
        if (serviceInstanceIdsValue != null) {
          addAllServiceInstanceIds(serviceInstanceIdsValue);
        }
      }
      if (object instanceof PaginatedRequest) {
        PaginatedRequest instance = (PaginatedRequest) object;
        OrderDirection orderDirectionValue = instance.getOrderDirection();
        if (orderDirectionValue != null) {
          orderDirection(orderDirectionValue);
        }
        Integer resultsPerPageValue = instance.getResultsPerPage();
        if (resultsPerPageValue != null) {
          resultsPerPage(resultsPerPageValue);
        }
        Integer pageValue = instance.getPage();
        if (pageValue != null) {
          page(pageValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link ListServiceBindingsRequest#getOrderDirection() orderDirection} attribute.
     * @param orderDirection The value for orderDirection (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder orderDirection(@Nullable OrderDirection orderDirection) {
      this.orderDirection = orderDirection;
      return this;
    }

    /**
     * Initializes the value for the {@link ListServiceBindingsRequest#getPage() page} attribute.
     * @param page The value for page (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder page(@Nullable Integer page) {
      this.page = page;
      return this;
    }

    /**
     * Initializes the value for the {@link ListServiceBindingsRequest#getResultsPerPage() resultsPerPage} attribute.
     * @param resultsPerPage The value for resultsPerPage (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder resultsPerPage(@Nullable Integer resultsPerPage) {
      this.resultsPerPage = resultsPerPage;
      return this;
    }

    /**
     * Adds one element to {@link ListServiceBindingsRequest#getApplicationIds() applicationIds} list.
     * @param element A applicationIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationId(String element) {
      if (this.applicationIds == null) {
        this.applicationIds = new ArrayList<String>();
      }
      this.applicationIds.add(Objects.requireNonNull(element, "applicationIds element"));
      return this;
    }

    /**
     * Adds elements to {@link ListServiceBindingsRequest#getApplicationIds() applicationIds} list.
     * @param elements An array of applicationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationIds(String... elements) {
      if (this.applicationIds == null) {
        this.applicationIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.applicationIds.add(Objects.requireNonNull(element, "applicationIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListServiceBindingsRequest#getApplicationIds() applicationIds} list.
     * @param elements An iterable of applicationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationIds(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.applicationIds = null;
        return this;
      }
      this.applicationIds = new ArrayList<String>();
      return addAllApplicationIds(elements);
    }

    /**
     * Adds elements to {@link ListServiceBindingsRequest#getApplicationIds() applicationIds} list.
     * @param elements An iterable of applicationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllApplicationIds(Iterable<String> elements) {
      Objects.requireNonNull(elements, "applicationIds element");
      if (this.applicationIds == null) {
        this.applicationIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.applicationIds.add(Objects.requireNonNull(element, "applicationIds element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListServiceBindingsRequest#getServiceInstanceIds() serviceInstanceIds} list.
     * @param element A serviceInstanceIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceInstanceId(String element) {
      if (this.serviceInstanceIds == null) {
        this.serviceInstanceIds = new ArrayList<String>();
      }
      this.serviceInstanceIds.add(Objects.requireNonNull(element, "serviceInstanceIds element"));
      return this;
    }

    /**
     * Adds elements to {@link ListServiceBindingsRequest#getServiceInstanceIds() serviceInstanceIds} list.
     * @param elements An array of serviceInstanceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceInstanceIds(String... elements) {
      if (this.serviceInstanceIds == null) {
        this.serviceInstanceIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.serviceInstanceIds.add(Objects.requireNonNull(element, "serviceInstanceIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListServiceBindingsRequest#getServiceInstanceIds() serviceInstanceIds} list.
     * @param elements An iterable of serviceInstanceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceInstanceIds(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.serviceInstanceIds = null;
        return this;
      }
      this.serviceInstanceIds = new ArrayList<String>();
      return addAllServiceInstanceIds(elements);
    }

    /**
     * Adds elements to {@link ListServiceBindingsRequest#getServiceInstanceIds() serviceInstanceIds} list.
     * @param elements An iterable of serviceInstanceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllServiceInstanceIds(Iterable<String> elements) {
      Objects.requireNonNull(elements, "serviceInstanceIds element");
      if (this.serviceInstanceIds == null) {
        this.serviceInstanceIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.serviceInstanceIds.add(Objects.requireNonNull(element, "serviceInstanceIds element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ListServiceBindingsRequest ListServiceBindingsRequest}.
     * @return An immutable instance of ListServiceBindingsRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ListServiceBindingsRequest build() {
      return new ListServiceBindingsRequest(this);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
