package org.cloudfoundry.client.v2.servicebrokers;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * The entity response payload for Service Broker
 */
@Generated(from = "_ServiceBrokerEntity", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ServiceBrokerEntity extends org.cloudfoundry.client.v2.servicebrokers._ServiceBrokerEntity {
  private final @Nullable String authenticationUsername;
  private final @Nullable String brokerUrl;
  private final @Nullable String name;
  private final @Nullable String spaceId;

  private ServiceBrokerEntity(ServiceBrokerEntity.Builder builder) {
    this.authenticationUsername = builder.authenticationUsername;
    this.brokerUrl = builder.brokerUrl;
    this.name = builder.name;
    this.spaceId = builder.spaceId;
  }

  /**
   * The authentication username
   */
  @JsonProperty("auth_username")
  @Override
  public @Nullable String getAuthenticationUsername() {
    return authenticationUsername;
  }

  /**
   * The url of the service broker.
   */
  @JsonProperty("broker_url")
  @Override
  public @Nullable String getBrokerUrl() {
    return brokerUrl;
  }

  /**
   * The name
   */
  @JsonProperty("name")
  @Override
  public @Nullable String getName() {
    return name;
  }

  /**
   * The space id
   */
  @JsonProperty("space_guid")
  @Override
  public @Nullable String getSpaceId() {
    return spaceId;
  }

  /**
   * This instance is equal to all instances of {@code ServiceBrokerEntity} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ServiceBrokerEntity
        && equalTo(0, (ServiceBrokerEntity) another);
  }

  private boolean equalTo(int synthetic, ServiceBrokerEntity another) {
    return Objects.equals(authenticationUsername, another.authenticationUsername)
        && Objects.equals(brokerUrl, another.brokerUrl)
        && Objects.equals(name, another.name)
        && Objects.equals(spaceId, another.spaceId);
  }

  /**
   * Computes a hash code from attributes: {@code authenticationUsername}, {@code brokerUrl}, {@code name}, {@code spaceId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(authenticationUsername);
    h += (h << 5) + Objects.hashCode(brokerUrl);
    h += (h << 5) + Objects.hashCode(name);
    h += (h << 5) + Objects.hashCode(spaceId);
    return h;
  }

  /**
   * Prints the immutable value {@code ServiceBrokerEntity} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ServiceBrokerEntity{"
        + "authenticationUsername=" + authenticationUsername
        + ", brokerUrl=" + brokerUrl
        + ", name=" + name
        + ", spaceId=" + spaceId
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_ServiceBrokerEntity", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v2.servicebrokers._ServiceBrokerEntity {
    String authenticationUsername;
    String brokerUrl;
    String name;
    String spaceId;
    @JsonProperty("auth_username")
    public void setAuthenticationUsername(@Nullable String authenticationUsername) {
      this.authenticationUsername = authenticationUsername;
    }
    @JsonProperty("broker_url")
    public void setBrokerUrl(@Nullable String brokerUrl) {
      this.brokerUrl = brokerUrl;
    }
    @JsonProperty("name")
    public void setName(@Nullable String name) {
      this.name = name;
    }
    @JsonProperty("space_guid")
    public void setSpaceId(@Nullable String spaceId) {
      this.spaceId = spaceId;
    }
    @Override
    public String getAuthenticationUsername() { throw new UnsupportedOperationException(); }
    @Override
    public String getBrokerUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public String getSpaceId() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ServiceBrokerEntity fromJson(Json json) {
    ServiceBrokerEntity.Builder builder = ServiceBrokerEntity.builder();
    if (json.authenticationUsername != null) {
      builder.authenticationUsername(json.authenticationUsername);
    }
    if (json.brokerUrl != null) {
      builder.brokerUrl(json.brokerUrl);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.spaceId != null) {
      builder.spaceId(json.spaceId);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link ServiceBrokerEntity ServiceBrokerEntity}.
   * <pre>
   * ServiceBrokerEntity.builder()
   *    .authenticationUsername(String | null) // nullable {@link ServiceBrokerEntity#getAuthenticationUsername() authenticationUsername}
   *    .brokerUrl(String | null) // nullable {@link ServiceBrokerEntity#getBrokerUrl() brokerUrl}
   *    .name(String | null) // nullable {@link ServiceBrokerEntity#getName() name}
   *    .spaceId(String | null) // nullable {@link ServiceBrokerEntity#getSpaceId() spaceId}
   *    .build();
   * </pre>
   * @return A new ServiceBrokerEntity builder
   */
  public static ServiceBrokerEntity.Builder builder() {
    return new ServiceBrokerEntity.Builder();
  }

  /**
   * Builds instances of type {@link ServiceBrokerEntity ServiceBrokerEntity}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ServiceBrokerEntity", generator = "Immutables")
  public static final class Builder {
    private String authenticationUsername;
    private String brokerUrl;
    private String name;
    private String spaceId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ServiceBrokerEntity} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ServiceBrokerEntity instance) {
      return from((_ServiceBrokerEntity) instance);
    }

    /**
     * Copy abstract value type {@code _ServiceBrokerEntity} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ServiceBrokerEntity instance) {
      Objects.requireNonNull(instance, "instance");
      String authenticationUsernameValue = instance.getAuthenticationUsername();
      if (authenticationUsernameValue != null) {
        authenticationUsername(authenticationUsernameValue);
      }
      String brokerUrlValue = instance.getBrokerUrl();
      if (brokerUrlValue != null) {
        brokerUrl(brokerUrlValue);
      }
      String nameValue = instance.getName();
      if (nameValue != null) {
        name(nameValue);
      }
      String spaceIdValue = instance.getSpaceId();
      if (spaceIdValue != null) {
        spaceId(spaceIdValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ServiceBrokerEntity#getAuthenticationUsername() authenticationUsername} attribute.
     * @param authenticationUsername The value for authenticationUsername (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("auth_username")
    public final Builder authenticationUsername(@Nullable String authenticationUsername) {
      this.authenticationUsername = authenticationUsername;
      return this;
    }

    /**
     * Initializes the value for the {@link ServiceBrokerEntity#getBrokerUrl() brokerUrl} attribute.
     * @param brokerUrl The value for brokerUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("broker_url")
    public final Builder brokerUrl(@Nullable String brokerUrl) {
      this.brokerUrl = brokerUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link ServiceBrokerEntity#getName() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    public final Builder name(@Nullable String name) {
      this.name = name;
      return this;
    }

    /**
     * Initializes the value for the {@link ServiceBrokerEntity#getSpaceId() spaceId} attribute.
     * @param spaceId The value for spaceId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("space_guid")
    public final Builder spaceId(@Nullable String spaceId) {
      this.spaceId = spaceId;
      return this;
    }

    /**
     * Builds a new {@link ServiceBrokerEntity ServiceBrokerEntity}.
     * @return An immutable instance of ServiceBrokerEntity
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ServiceBrokerEntity build() {
      return new ServiceBrokerEntity(this);
    }
  }
}
