package org.cloudfoundry.client.v2.serviceplans;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * The entity representing service plan schemas
 */
@Generated(from = "_Schemas", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class Schemas extends org.cloudfoundry.client.v2.serviceplans._Schemas {
  private final @Nullable ServiceBindingSchema serviceBinding;
  private final ServiceInstanceSchema serviceInstance;

  private Schemas(Schemas.Builder builder) {
    this.serviceBinding = builder.serviceBinding;
    this.serviceInstance = builder.serviceInstance;
  }

  /**
   * The service binding schema
   */
  @JsonProperty("service_binding")
  @Override
  public @Nullable ServiceBindingSchema getServiceBinding() {
    return serviceBinding;
  }

  /**
   * The service instance schema
   */
  @JsonProperty("service_instance")
  @Override
  public ServiceInstanceSchema getServiceInstance() {
    return serviceInstance;
  }

  /**
   * This instance is equal to all instances of {@code Schemas} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof Schemas
        && equalTo(0, (Schemas) another);
  }

  private boolean equalTo(int synthetic, Schemas another) {
    return Objects.equals(serviceBinding, another.serviceBinding)
        && serviceInstance.equals(another.serviceInstance);
  }

  /**
   * Computes a hash code from attributes: {@code serviceBinding}, {@code serviceInstance}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(serviceBinding);
    h += (h << 5) + serviceInstance.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Schemas} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Schemas{"
        + "serviceBinding=" + serviceBinding
        + ", serviceInstance=" + serviceInstance
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_Schemas", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v2.serviceplans._Schemas {
    ServiceBindingSchema serviceBinding;
    ServiceInstanceSchema serviceInstance;
    @JsonProperty("service_binding")
    public void setServiceBinding(@Nullable ServiceBindingSchema serviceBinding) {
      this.serviceBinding = serviceBinding;
    }
    @JsonProperty("service_instance")
    public void setServiceInstance(ServiceInstanceSchema serviceInstance) {
      this.serviceInstance = serviceInstance;
    }
    @Override
    public ServiceBindingSchema getServiceBinding() { throw new UnsupportedOperationException(); }
    @Override
    public ServiceInstanceSchema getServiceInstance() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static Schemas fromJson(Json json) {
    Schemas.Builder builder = Schemas.builder();
    if (json.serviceBinding != null) {
      builder.serviceBinding(json.serviceBinding);
    }
    if (json.serviceInstance != null) {
      builder.serviceInstance(json.serviceInstance);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link Schemas Schemas}.
   * <pre>
   * Schemas.builder()
   *    .serviceBinding(org.cloudfoundry.client.v2.serviceplans.ServiceBindingSchema | null) // nullable {@link Schemas#getServiceBinding() serviceBinding}
   *    .serviceInstance(org.cloudfoundry.client.v2.serviceplans.ServiceInstanceSchema) // required {@link Schemas#getServiceInstance() serviceInstance}
   *    .build();
   * </pre>
   * @return A new Schemas builder
   */
  public static Schemas.Builder builder() {
    return new Schemas.Builder();
  }

  /**
   * Builds instances of type {@link Schemas Schemas}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_Schemas", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_SERVICE_INSTANCE = 0x1L;
    private long initBits = 0x1L;

    private ServiceBindingSchema serviceBinding;
    private ServiceInstanceSchema serviceInstance;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Schemas} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Schemas instance) {
      return from((_Schemas) instance);
    }

    /**
     * Copy abstract value type {@code _Schemas} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_Schemas instance) {
      Objects.requireNonNull(instance, "instance");
      ServiceBindingSchema serviceBindingValue = instance.getServiceBinding();
      if (serviceBindingValue != null) {
        serviceBinding(serviceBindingValue);
      }
      this.serviceInstance(instance.getServiceInstance());
      return this;
    }

    /**
     * Initializes the value for the {@link Schemas#getServiceBinding() serviceBinding} attribute.
     * @param serviceBinding The value for serviceBinding (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("service_binding")
    public final Builder serviceBinding(@Nullable ServiceBindingSchema serviceBinding) {
      this.serviceBinding = serviceBinding;
      return this;
    }

    /**
     * Initializes the value for the {@link Schemas#getServiceInstance() serviceInstance} attribute.
     * @param serviceInstance The value for serviceInstance 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("service_instance")
    public final Builder serviceInstance(ServiceInstanceSchema serviceInstance) {
      this.serviceInstance = Objects.requireNonNull(serviceInstance, "serviceInstance");
      initBits &= ~INIT_BIT_SERVICE_INSTANCE;
      return this;
    }

    /**
     * Builds a new {@link Schemas Schemas}.
     * @return An immutable instance of Schemas
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public Schemas build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new Schemas(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_SERVICE_INSTANCE) != 0) attributes.add("serviceInstance");
      return "Cannot build Schemas, some of required attributes are not set " + attributes;
    }
  }
}
