package org.cloudfoundry.client.v2.serviceplans;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.MaintenanceInfo;
import org.immutables.value.Generated;

/**
 * The entity response payload for Service Plans
 */
@Generated(from = "_ServicePlanEntity", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ServicePlanEntity extends org.cloudfoundry.client.v2.serviceplans._ServicePlanEntity {
  private final @Nullable Boolean active;
  private final @Nullable Boolean bindable;
  private final @Nullable String description;
  private final @Nullable String extra;
  private final @Nullable Boolean free;
  private final @Nullable MaintenanceInfo maintenanceInfo;
  private final @Nullable Long maximumPollingDuration;
  private final @Nullable String name;
  private final @Nullable Boolean planUpdatable;
  private final @Nullable Boolean publiclyVisible;
  private final @Nullable Schemas schemas;
  private final @Nullable String serviceId;
  private final @Nullable String serviceInstancesUrl;
  private final @Nullable String serviceUrl;
  private final @Nullable String uniqueId;

  private ServicePlanEntity(ServicePlanEntity.Builder builder) {
    this.active = builder.active;
    this.bindable = builder.bindable;
    this.description = builder.description;
    this.extra = builder.extra;
    this.free = builder.free;
    this.maintenanceInfo = builder.maintenanceInfo;
    this.maximumPollingDuration = builder.maximumPollingDuration;
    this.name = builder.name;
    this.planUpdatable = builder.planUpdatable;
    this.publiclyVisible = builder.publiclyVisible;
    this.schemas = builder.schemas;
    this.serviceId = builder.serviceId;
    this.serviceInstancesUrl = builder.serviceInstancesUrl;
    this.serviceUrl = builder.serviceUrl;
    this.uniqueId = builder.uniqueId;
  }

  /**
   * The active flag
   */
  @JsonProperty("active")
  @Override
  public @Nullable Boolean getActive() {
    return active;
  }

  /**
   * The bindable flag
   */
  @JsonProperty("bindable")
  @Override
  public @Nullable Boolean getBindable() {
    return bindable;
  }

  /**
   * The description
   */
  @JsonProperty("description")
  @Override
  public @Nullable String getDescription() {
    return description;
  }

  /**
   * The extra (A JSON string with additional data about the plan)
   */
  @JsonProperty("extra")
  @Override
  public @Nullable String getExtra() {
    return extra;
  }

  /**
   * The free flag
   */
  @JsonProperty("free")
  @Override
  public @Nullable Boolean getFree() {
    return free;
  }

  /**
   * The plan maintenance info
   */
  @JsonProperty("maintenance_info")
  @Override
  public @Nullable MaintenanceInfo getMaintenanceInfo() {
    return maintenanceInfo;
  }

  /**
   * The maximum polling duration
   */
  @JsonProperty("maximum_polling_duration")
  @Override
  public @Nullable Long getMaximumPollingDuration() {
    return maximumPollingDuration;
  }

  /**
   * The name
   */
  @JsonProperty("name")
  @Override
  public @Nullable String getName() {
    return name;
  }

  /**
   * Whether the plan is updatable
   */
  @JsonProperty("plan_updateable")
  @Override
  public @Nullable Boolean getPlanUpdatable() {
    return planUpdatable;
  }

  /**
   * The public flag
   */
  @JsonProperty("public")
  @Override
  public @Nullable Boolean getPubliclyVisible() {
    return publiclyVisible;
  }

  /**
   * The schemas
   */
  @JsonProperty("schemas")
  @Override
  public @Nullable Schemas getSchemas() {
    return schemas;
  }

  /**
   * The service id
   */
  @JsonProperty("service_guid")
  @Override
  public @Nullable String getServiceId() {
    return serviceId;
  }

  /**
   * The service instances url
   */
  @JsonProperty("service_instances_url")
  @Override
  public @Nullable String getServiceInstancesUrl() {
    return serviceInstancesUrl;
  }

  /**
   * The service url
   */
  @JsonProperty("service_url")
  @Override
  public @Nullable String getServiceUrl() {
    return serviceUrl;
  }

  /**
   * The unique id in the service broker
   */
  @JsonProperty("unique_id")
  @Override
  public @Nullable String getUniqueId() {
    return uniqueId;
  }

  /**
   * This instance is equal to all instances of {@code ServicePlanEntity} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ServicePlanEntity
        && equalTo(0, (ServicePlanEntity) another);
  }

  private boolean equalTo(int synthetic, ServicePlanEntity another) {
    return Objects.equals(active, another.active)
        && Objects.equals(bindable, another.bindable)
        && Objects.equals(description, another.description)
        && Objects.equals(extra, another.extra)
        && Objects.equals(free, another.free)
        && Objects.equals(maintenanceInfo, another.maintenanceInfo)
        && Objects.equals(maximumPollingDuration, another.maximumPollingDuration)
        && Objects.equals(name, another.name)
        && Objects.equals(planUpdatable, another.planUpdatable)
        && Objects.equals(publiclyVisible, another.publiclyVisible)
        && Objects.equals(schemas, another.schemas)
        && Objects.equals(serviceId, another.serviceId)
        && Objects.equals(serviceInstancesUrl, another.serviceInstancesUrl)
        && Objects.equals(serviceUrl, another.serviceUrl)
        && Objects.equals(uniqueId, another.uniqueId);
  }

  /**
   * Computes a hash code from attributes: {@code active}, {@code bindable}, {@code description}, {@code extra}, {@code free}, {@code maintenanceInfo}, {@code maximumPollingDuration}, {@code name}, {@code planUpdatable}, {@code publiclyVisible}, {@code schemas}, {@code serviceId}, {@code serviceInstancesUrl}, {@code serviceUrl}, {@code uniqueId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(active);
    h += (h << 5) + Objects.hashCode(bindable);
    h += (h << 5) + Objects.hashCode(description);
    h += (h << 5) + Objects.hashCode(extra);
    h += (h << 5) + Objects.hashCode(free);
    h += (h << 5) + Objects.hashCode(maintenanceInfo);
    h += (h << 5) + Objects.hashCode(maximumPollingDuration);
    h += (h << 5) + Objects.hashCode(name);
    h += (h << 5) + Objects.hashCode(planUpdatable);
    h += (h << 5) + Objects.hashCode(publiclyVisible);
    h += (h << 5) + Objects.hashCode(schemas);
    h += (h << 5) + Objects.hashCode(serviceId);
    h += (h << 5) + Objects.hashCode(serviceInstancesUrl);
    h += (h << 5) + Objects.hashCode(serviceUrl);
    h += (h << 5) + Objects.hashCode(uniqueId);
    return h;
  }

  /**
   * Prints the immutable value {@code ServicePlanEntity} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ServicePlanEntity{"
        + "active=" + active
        + ", bindable=" + bindable
        + ", description=" + description
        + ", extra=" + extra
        + ", free=" + free
        + ", maintenanceInfo=" + maintenanceInfo
        + ", maximumPollingDuration=" + maximumPollingDuration
        + ", name=" + name
        + ", planUpdatable=" + planUpdatable
        + ", publiclyVisible=" + publiclyVisible
        + ", schemas=" + schemas
        + ", serviceId=" + serviceId
        + ", serviceInstancesUrl=" + serviceInstancesUrl
        + ", serviceUrl=" + serviceUrl
        + ", uniqueId=" + uniqueId
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_ServicePlanEntity", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v2.serviceplans._ServicePlanEntity {
    Boolean active;
    Boolean bindable;
    String description;
    String extra;
    Boolean free;
    MaintenanceInfo maintenanceInfo;
    Long maximumPollingDuration;
    String name;
    Boolean planUpdatable;
    Boolean publiclyVisible;
    Schemas schemas;
    String serviceId;
    String serviceInstancesUrl;
    String serviceUrl;
    String uniqueId;
    @JsonProperty("active")
    public void setActive(@Nullable Boolean active) {
      this.active = active;
    }
    @JsonProperty("bindable")
    public void setBindable(@Nullable Boolean bindable) {
      this.bindable = bindable;
    }
    @JsonProperty("description")
    public void setDescription(@Nullable String description) {
      this.description = description;
    }
    @JsonProperty("extra")
    public void setExtra(@Nullable String extra) {
      this.extra = extra;
    }
    @JsonProperty("free")
    public void setFree(@Nullable Boolean free) {
      this.free = free;
    }
    @JsonProperty("maintenance_info")
    public void setMaintenanceInfo(@Nullable MaintenanceInfo maintenanceInfo) {
      this.maintenanceInfo = maintenanceInfo;
    }
    @JsonProperty("maximum_polling_duration")
    public void setMaximumPollingDuration(@Nullable Long maximumPollingDuration) {
      this.maximumPollingDuration = maximumPollingDuration;
    }
    @JsonProperty("name")
    public void setName(@Nullable String name) {
      this.name = name;
    }
    @JsonProperty("plan_updateable")
    public void setPlanUpdatable(@Nullable Boolean planUpdatable) {
      this.planUpdatable = planUpdatable;
    }
    @JsonProperty("public")
    public void setPubliclyVisible(@Nullable Boolean publiclyVisible) {
      this.publiclyVisible = publiclyVisible;
    }
    @JsonProperty("schemas")
    public void setSchemas(@Nullable Schemas schemas) {
      this.schemas = schemas;
    }
    @JsonProperty("service_guid")
    public void setServiceId(@Nullable String serviceId) {
      this.serviceId = serviceId;
    }
    @JsonProperty("service_instances_url")
    public void setServiceInstancesUrl(@Nullable String serviceInstancesUrl) {
      this.serviceInstancesUrl = serviceInstancesUrl;
    }
    @JsonProperty("service_url")
    public void setServiceUrl(@Nullable String serviceUrl) {
      this.serviceUrl = serviceUrl;
    }
    @JsonProperty("unique_id")
    public void setUniqueId(@Nullable String uniqueId) {
      this.uniqueId = uniqueId;
    }
    @Override
    public Boolean getActive() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getBindable() { throw new UnsupportedOperationException(); }
    @Override
    public String getDescription() { throw new UnsupportedOperationException(); }
    @Override
    public String getExtra() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getFree() { throw new UnsupportedOperationException(); }
    @Override
    public MaintenanceInfo getMaintenanceInfo() { throw new UnsupportedOperationException(); }
    @Override
    public Long getMaximumPollingDuration() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getPlanUpdatable() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getPubliclyVisible() { throw new UnsupportedOperationException(); }
    @Override
    public Schemas getSchemas() { throw new UnsupportedOperationException(); }
    @Override
    public String getServiceId() { throw new UnsupportedOperationException(); }
    @Override
    public String getServiceInstancesUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String getServiceUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String getUniqueId() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ServicePlanEntity fromJson(Json json) {
    ServicePlanEntity.Builder builder = ServicePlanEntity.builder();
    if (json.active != null) {
      builder.active(json.active);
    }
    if (json.bindable != null) {
      builder.bindable(json.bindable);
    }
    if (json.description != null) {
      builder.description(json.description);
    }
    if (json.extra != null) {
      builder.extra(json.extra);
    }
    if (json.free != null) {
      builder.free(json.free);
    }
    if (json.maintenanceInfo != null) {
      builder.maintenanceInfo(json.maintenanceInfo);
    }
    if (json.maximumPollingDuration != null) {
      builder.maximumPollingDuration(json.maximumPollingDuration);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.planUpdatable != null) {
      builder.planUpdatable(json.planUpdatable);
    }
    if (json.publiclyVisible != null) {
      builder.publiclyVisible(json.publiclyVisible);
    }
    if (json.schemas != null) {
      builder.schemas(json.schemas);
    }
    if (json.serviceId != null) {
      builder.serviceId(json.serviceId);
    }
    if (json.serviceInstancesUrl != null) {
      builder.serviceInstancesUrl(json.serviceInstancesUrl);
    }
    if (json.serviceUrl != null) {
      builder.serviceUrl(json.serviceUrl);
    }
    if (json.uniqueId != null) {
      builder.uniqueId(json.uniqueId);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link ServicePlanEntity ServicePlanEntity}.
   * <pre>
   * ServicePlanEntity.builder()
   *    .active(Boolean | null) // nullable {@link ServicePlanEntity#getActive() active}
   *    .bindable(Boolean | null) // nullable {@link ServicePlanEntity#getBindable() bindable}
   *    .description(String | null) // nullable {@link ServicePlanEntity#getDescription() description}
   *    .extra(String | null) // nullable {@link ServicePlanEntity#getExtra() extra}
   *    .free(Boolean | null) // nullable {@link ServicePlanEntity#getFree() free}
   *    .maintenanceInfo(org.cloudfoundry.client.v2.MaintenanceInfo | null) // nullable {@link ServicePlanEntity#getMaintenanceInfo() maintenanceInfo}
   *    .maximumPollingDuration(Long | null) // nullable {@link ServicePlanEntity#getMaximumPollingDuration() maximumPollingDuration}
   *    .name(String | null) // nullable {@link ServicePlanEntity#getName() name}
   *    .planUpdatable(Boolean | null) // nullable {@link ServicePlanEntity#getPlanUpdatable() planUpdatable}
   *    .publiclyVisible(Boolean | null) // nullable {@link ServicePlanEntity#getPubliclyVisible() publiclyVisible}
   *    .schemas(org.cloudfoundry.client.v2.serviceplans.Schemas | null) // nullable {@link ServicePlanEntity#getSchemas() schemas}
   *    .serviceId(String | null) // nullable {@link ServicePlanEntity#getServiceId() serviceId}
   *    .serviceInstancesUrl(String | null) // nullable {@link ServicePlanEntity#getServiceInstancesUrl() serviceInstancesUrl}
   *    .serviceUrl(String | null) // nullable {@link ServicePlanEntity#getServiceUrl() serviceUrl}
   *    .uniqueId(String | null) // nullable {@link ServicePlanEntity#getUniqueId() uniqueId}
   *    .build();
   * </pre>
   * @return A new ServicePlanEntity builder
   */
  public static ServicePlanEntity.Builder builder() {
    return new ServicePlanEntity.Builder();
  }

  /**
   * Builds instances of type {@link ServicePlanEntity ServicePlanEntity}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ServicePlanEntity", generator = "Immutables")
  public static final class Builder {
    private Boolean active;
    private Boolean bindable;
    private String description;
    private String extra;
    private Boolean free;
    private MaintenanceInfo maintenanceInfo;
    private Long maximumPollingDuration;
    private String name;
    private Boolean planUpdatable;
    private Boolean publiclyVisible;
    private Schemas schemas;
    private String serviceId;
    private String serviceInstancesUrl;
    private String serviceUrl;
    private String uniqueId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ServicePlanEntity} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ServicePlanEntity instance) {
      return from((_ServicePlanEntity) instance);
    }

    /**
     * Copy abstract value type {@code _ServicePlanEntity} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ServicePlanEntity instance) {
      Objects.requireNonNull(instance, "instance");
      Boolean activeValue = instance.getActive();
      if (activeValue != null) {
        active(activeValue);
      }
      Boolean bindableValue = instance.getBindable();
      if (bindableValue != null) {
        bindable(bindableValue);
      }
      String descriptionValue = instance.getDescription();
      if (descriptionValue != null) {
        description(descriptionValue);
      }
      String extraValue = instance.getExtra();
      if (extraValue != null) {
        extra(extraValue);
      }
      Boolean freeValue = instance.getFree();
      if (freeValue != null) {
        free(freeValue);
      }
      MaintenanceInfo maintenanceInfoValue = instance.getMaintenanceInfo();
      if (maintenanceInfoValue != null) {
        maintenanceInfo(maintenanceInfoValue);
      }
      Long maximumPollingDurationValue = instance.getMaximumPollingDuration();
      if (maximumPollingDurationValue != null) {
        maximumPollingDuration(maximumPollingDurationValue);
      }
      String nameValue = instance.getName();
      if (nameValue != null) {
        name(nameValue);
      }
      Boolean planUpdatableValue = instance.getPlanUpdatable();
      if (planUpdatableValue != null) {
        planUpdatable(planUpdatableValue);
      }
      Boolean publiclyVisibleValue = instance.getPubliclyVisible();
      if (publiclyVisibleValue != null) {
        publiclyVisible(publiclyVisibleValue);
      }
      Schemas schemasValue = instance.getSchemas();
      if (schemasValue != null) {
        schemas(schemasValue);
      }
      String serviceIdValue = instance.getServiceId();
      if (serviceIdValue != null) {
        serviceId(serviceIdValue);
      }
      String serviceInstancesUrlValue = instance.getServiceInstancesUrl();
      if (serviceInstancesUrlValue != null) {
        serviceInstancesUrl(serviceInstancesUrlValue);
      }
      String serviceUrlValue = instance.getServiceUrl();
      if (serviceUrlValue != null) {
        serviceUrl(serviceUrlValue);
      }
      String uniqueIdValue = instance.getUniqueId();
      if (uniqueIdValue != null) {
        uniqueId(uniqueIdValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ServicePlanEntity#getActive() active} attribute.
     * @param active The value for active (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("active")
    public final Builder active(@Nullable Boolean active) {
      this.active = active;
      return this;
    }

    /**
     * Initializes the value for the {@link ServicePlanEntity#getBindable() bindable} attribute.
     * @param bindable The value for bindable (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("bindable")
    public final Builder bindable(@Nullable Boolean bindable) {
      this.bindable = bindable;
      return this;
    }

    /**
     * Initializes the value for the {@link ServicePlanEntity#getDescription() description} attribute.
     * @param description The value for description (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("description")
    public final Builder description(@Nullable String description) {
      this.description = description;
      return this;
    }

    /**
     * Initializes the value for the {@link ServicePlanEntity#getExtra() extra} attribute.
     * @param extra The value for extra (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("extra")
    public final Builder extra(@Nullable String extra) {
      this.extra = extra;
      return this;
    }

    /**
     * Initializes the value for the {@link ServicePlanEntity#getFree() free} attribute.
     * @param free The value for free (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("free")
    public final Builder free(@Nullable Boolean free) {
      this.free = free;
      return this;
    }

    /**
     * Initializes the value for the {@link ServicePlanEntity#getMaintenanceInfo() maintenanceInfo} attribute.
     * @param maintenanceInfo The value for maintenanceInfo (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("maintenance_info")
    public final Builder maintenanceInfo(@Nullable MaintenanceInfo maintenanceInfo) {
      this.maintenanceInfo = maintenanceInfo;
      return this;
    }

    /**
     * Initializes the value for the {@link ServicePlanEntity#getMaximumPollingDuration() maximumPollingDuration} attribute.
     * @param maximumPollingDuration The value for maximumPollingDuration (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("maximum_polling_duration")
    public final Builder maximumPollingDuration(@Nullable Long maximumPollingDuration) {
      this.maximumPollingDuration = maximumPollingDuration;
      return this;
    }

    /**
     * Initializes the value for the {@link ServicePlanEntity#getName() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    public final Builder name(@Nullable String name) {
      this.name = name;
      return this;
    }

    /**
     * Initializes the value for the {@link ServicePlanEntity#getPlanUpdatable() planUpdatable} attribute.
     * @param planUpdatable The value for planUpdatable (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("plan_updateable")
    public final Builder planUpdatable(@Nullable Boolean planUpdatable) {
      this.planUpdatable = planUpdatable;
      return this;
    }

    /**
     * Initializes the value for the {@link ServicePlanEntity#getPubliclyVisible() publiclyVisible} attribute.
     * @param publiclyVisible The value for publiclyVisible (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("public")
    public final Builder publiclyVisible(@Nullable Boolean publiclyVisible) {
      this.publiclyVisible = publiclyVisible;
      return this;
    }

    /**
     * Initializes the value for the {@link ServicePlanEntity#getSchemas() schemas} attribute.
     * @param schemas The value for schemas (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("schemas")
    public final Builder schemas(@Nullable Schemas schemas) {
      this.schemas = schemas;
      return this;
    }

    /**
     * Initializes the value for the {@link ServicePlanEntity#getServiceId() serviceId} attribute.
     * @param serviceId The value for serviceId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("service_guid")
    public final Builder serviceId(@Nullable String serviceId) {
      this.serviceId = serviceId;
      return this;
    }

    /**
     * Initializes the value for the {@link ServicePlanEntity#getServiceInstancesUrl() serviceInstancesUrl} attribute.
     * @param serviceInstancesUrl The value for serviceInstancesUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("service_instances_url")
    public final Builder serviceInstancesUrl(@Nullable String serviceInstancesUrl) {
      this.serviceInstancesUrl = serviceInstancesUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link ServicePlanEntity#getServiceUrl() serviceUrl} attribute.
     * @param serviceUrl The value for serviceUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("service_url")
    public final Builder serviceUrl(@Nullable String serviceUrl) {
      this.serviceUrl = serviceUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link ServicePlanEntity#getUniqueId() uniqueId} attribute.
     * @param uniqueId The value for uniqueId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("unique_id")
    public final Builder uniqueId(@Nullable String uniqueId) {
      this.uniqueId = uniqueId;
      return this;
    }

    /**
     * Builds a new {@link ServicePlanEntity ServicePlanEntity}.
     * @return An immutable instance of ServicePlanEntity
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ServicePlanEntity build() {
      return new ServicePlanEntity(this);
    }
  }
}
