package org.cloudfoundry.client.v2.serviceplanvisibilities;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * The request payload for the Create Service Plan Visibility
 */
@Generated(from = "_CreateServicePlanVisibilityRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class CreateServicePlanVisibilityRequest
    extends org.cloudfoundry.client.v2.serviceplanvisibilities._CreateServicePlanVisibilityRequest {
  private final String organizationId;
  private final String servicePlanId;

  private CreateServicePlanVisibilityRequest(CreateServicePlanVisibilityRequest.Builder builder) {
    this.organizationId = builder.organizationId;
    this.servicePlanId = builder.servicePlanId;
  }

  /**
   * The organization id
   */
  @JsonProperty("organization_guid")
  @Override
  public String getOrganizationId() {
    return organizationId;
  }

  /**
   * The service plan id
   */
  @JsonProperty("service_plan_guid")
  @Override
  public String getServicePlanId() {
    return servicePlanId;
  }

  /**
   * This instance is equal to all instances of {@code CreateServicePlanVisibilityRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof CreateServicePlanVisibilityRequest
        && equalTo(0, (CreateServicePlanVisibilityRequest) another);
  }

  private boolean equalTo(int synthetic, CreateServicePlanVisibilityRequest another) {
    return organizationId.equals(another.organizationId)
        && servicePlanId.equals(another.servicePlanId);
  }

  /**
   * Computes a hash code from attributes: {@code organizationId}, {@code servicePlanId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + organizationId.hashCode();
    h += (h << 5) + servicePlanId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code CreateServicePlanVisibilityRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "CreateServicePlanVisibilityRequest{"
        + "organizationId=" + organizationId
        + ", servicePlanId=" + servicePlanId
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_CreateServicePlanVisibilityRequest", generator = "Immutables")
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json
      extends org.cloudfoundry.client.v2.serviceplanvisibilities._CreateServicePlanVisibilityRequest {
    String organizationId;
    String servicePlanId;
    @JsonProperty("organization_guid")
    public void setOrganizationId(String organizationId) {
      this.organizationId = organizationId;
    }
    @JsonProperty("service_plan_guid")
    public void setServicePlanId(String servicePlanId) {
      this.servicePlanId = servicePlanId;
    }
    @Override
    public String getOrganizationId() { throw new UnsupportedOperationException(); }
    @Override
    public String getServicePlanId() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static CreateServicePlanVisibilityRequest fromJson(Json json) {
    CreateServicePlanVisibilityRequest.Builder builder = CreateServicePlanVisibilityRequest.builder();
    if (json.organizationId != null) {
      builder.organizationId(json.organizationId);
    }
    if (json.servicePlanId != null) {
      builder.servicePlanId(json.servicePlanId);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link CreateServicePlanVisibilityRequest CreateServicePlanVisibilityRequest}.
   * <pre>
   * CreateServicePlanVisibilityRequest.builder()
   *    .organizationId(String) // required {@link CreateServicePlanVisibilityRequest#getOrganizationId() organizationId}
   *    .servicePlanId(String) // required {@link CreateServicePlanVisibilityRequest#getServicePlanId() servicePlanId}
   *    .build();
   * </pre>
   * @return A new CreateServicePlanVisibilityRequest builder
   */
  public static CreateServicePlanVisibilityRequest.Builder builder() {
    return new CreateServicePlanVisibilityRequest.Builder();
  }

  /**
   * Builds instances of type {@link CreateServicePlanVisibilityRequest CreateServicePlanVisibilityRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_CreateServicePlanVisibilityRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_ORGANIZATION_ID = 0x1L;
    private static final long INIT_BIT_SERVICE_PLAN_ID = 0x2L;
    private long initBits = 0x3L;

    private String organizationId;
    private String servicePlanId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CreateServicePlanVisibilityRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(CreateServicePlanVisibilityRequest instance) {
      return from((_CreateServicePlanVisibilityRequest) instance);
    }

    /**
     * Copy abstract value type {@code _CreateServicePlanVisibilityRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_CreateServicePlanVisibilityRequest instance) {
      Objects.requireNonNull(instance, "instance");
      this.organizationId(instance.getOrganizationId());
      this.servicePlanId(instance.getServicePlanId());
      return this;
    }

    /**
     * Initializes the value for the {@link CreateServicePlanVisibilityRequest#getOrganizationId() organizationId} attribute.
     * @param organizationId The value for organizationId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationId(String organizationId) {
      this.organizationId = Objects.requireNonNull(organizationId, "organizationId");
      initBits &= ~INIT_BIT_ORGANIZATION_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateServicePlanVisibilityRequest#getServicePlanId() servicePlanId} attribute.
     * @param servicePlanId The value for servicePlanId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder servicePlanId(String servicePlanId) {
      this.servicePlanId = Objects.requireNonNull(servicePlanId, "servicePlanId");
      initBits &= ~INIT_BIT_SERVICE_PLAN_ID;
      return this;
    }

    /**
     * Builds a new {@link CreateServicePlanVisibilityRequest CreateServicePlanVisibilityRequest}.
     * @return An immutable instance of CreateServicePlanVisibilityRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public CreateServicePlanVisibilityRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new CreateServicePlanVisibilityRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ORGANIZATION_ID) != 0) attributes.add("organizationId");
      if ((initBits & INIT_BIT_SERVICE_PLAN_ID) != 0) attributes.add("servicePlanId");
      return "Cannot build CreateServicePlanVisibilityRequest, some of required attributes are not set " + attributes;
    }
  }
}
