package org.cloudfoundry.client.v2.services;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * The request payload for the Get Service operation
 */
@Generated(from = "_GetServiceRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class GetServiceRequest extends org.cloudfoundry.client.v2.services._GetServiceRequest {
  private final String serviceId;

  private GetServiceRequest(GetServiceRequest.Builder builder) {
    this.serviceId = builder.serviceId;
  }

  /**
   * The service id
   */
  @Override
  public String getServiceId() {
    return serviceId;
  }

  /**
   * This instance is equal to all instances of {@code GetServiceRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GetServiceRequest
        && equalTo(0, (GetServiceRequest) another);
  }

  private boolean equalTo(int synthetic, GetServiceRequest another) {
    return serviceId.equals(another.serviceId);
  }

  /**
   * Computes a hash code from attributes: {@code serviceId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + serviceId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code GetServiceRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GetServiceRequest{"
        + "serviceId=" + serviceId
        + "}";
  }

  /**
   * Creates a builder for {@link GetServiceRequest GetServiceRequest}.
   * <pre>
   * GetServiceRequest.builder()
   *    .serviceId(String) // required {@link GetServiceRequest#getServiceId() serviceId}
   *    .build();
   * </pre>
   * @return A new GetServiceRequest builder
   */
  public static GetServiceRequest.Builder builder() {
    return new GetServiceRequest.Builder();
  }

  /**
   * Builds instances of type {@link GetServiceRequest GetServiceRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_GetServiceRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_SERVICE_ID = 0x1L;
    private long initBits = 0x1L;

    private String serviceId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GetServiceRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GetServiceRequest instance) {
      return from((_GetServiceRequest) instance);
    }

    /**
     * Copy abstract value type {@code _GetServiceRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_GetServiceRequest instance) {
      Objects.requireNonNull(instance, "instance");
      this.serviceId(instance.getServiceId());
      return this;
    }

    /**
     * Initializes the value for the {@link GetServiceRequest#getServiceId() serviceId} attribute.
     * @param serviceId The value for serviceId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceId(String serviceId) {
      this.serviceId = Objects.requireNonNull(serviceId, "serviceId");
      initBits &= ~INIT_BIT_SERVICE_ID;
      return this;
    }

    /**
     * Builds a new {@link GetServiceRequest GetServiceRequest}.
     * @return An immutable instance of GetServiceRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GetServiceRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new GetServiceRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_SERVICE_ID) != 0) attributes.add("serviceId");
      return "Cannot build GetServiceRequest, some of required attributes are not set " + attributes;
    }
  }
}
