/*
 * Copyright 2013-2021 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.cloudfoundry.client.v2.services;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.FilterParameter;
import org.cloudfoundry.client.v2.PaginatedRequest;
import org.immutables.value.Value;

import java.util.List;

/**
 * The request payload for the List all Service Plans for the Service operation
 */
@Value.Immutable
abstract class _ListServiceServicePlansRequest extends PaginatedRequest {

    /**
     * The active flag
     */
    @FilterParameter("active")
    @Nullable
    abstract Boolean getActive();

    /**
     * The service id
     */
    @JsonIgnore
    abstract String getServiceId();

    /**
     * The service instance ids
     */
    @FilterParameter("service_instance_guid")
    @Nullable
    abstract List<String> getServiceInstanceIds();

}
