package org.cloudfoundry.client.v2.shareddomains;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * The request payload for the Delete a Shared Domain operation
 */
@Generated(from = "_DeleteSharedDomainRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class DeleteSharedDomainRequest
    extends org.cloudfoundry.client.v2.shareddomains._DeleteSharedDomainRequest {
  private final @Nullable Boolean async;
  private final String sharedDomainId;

  private DeleteSharedDomainRequest(DeleteSharedDomainRequest.Builder builder) {
    this.async = builder.async;
    this.sharedDomainId = builder.sharedDomainId;
  }

  /**
   * The async flag
   */
  @Override
  public @Nullable Boolean getAsync() {
    return async;
  }

  /**
   * The shared domain id
   */
  @Override
  public String getSharedDomainId() {
    return sharedDomainId;
  }

  /**
   * This instance is equal to all instances of {@code DeleteSharedDomainRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof DeleteSharedDomainRequest
        && equalTo(0, (DeleteSharedDomainRequest) another);
  }

  private boolean equalTo(int synthetic, DeleteSharedDomainRequest another) {
    return Objects.equals(async, another.async)
        && sharedDomainId.equals(another.sharedDomainId);
  }

  /**
   * Computes a hash code from attributes: {@code async}, {@code sharedDomainId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(async);
    h += (h << 5) + sharedDomainId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code DeleteSharedDomainRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DeleteSharedDomainRequest{"
        + "async=" + async
        + ", sharedDomainId=" + sharedDomainId
        + "}";
  }

  /**
   * Creates a builder for {@link DeleteSharedDomainRequest DeleteSharedDomainRequest}.
   * <pre>
   * DeleteSharedDomainRequest.builder()
   *    .async(Boolean | null) // nullable {@link DeleteSharedDomainRequest#getAsync() async}
   *    .sharedDomainId(String) // required {@link DeleteSharedDomainRequest#getSharedDomainId() sharedDomainId}
   *    .build();
   * </pre>
   * @return A new DeleteSharedDomainRequest builder
   */
  public static DeleteSharedDomainRequest.Builder builder() {
    return new DeleteSharedDomainRequest.Builder();
  }

  /**
   * Builds instances of type {@link DeleteSharedDomainRequest DeleteSharedDomainRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_DeleteSharedDomainRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_SHARED_DOMAIN_ID = 0x1L;
    private long initBits = 0x1L;

    private Boolean async;
    private String sharedDomainId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DeleteSharedDomainRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DeleteSharedDomainRequest instance) {
      return from((_DeleteSharedDomainRequest) instance);
    }

    /**
     * Copy abstract value type {@code _DeleteSharedDomainRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_DeleteSharedDomainRequest instance) {
      Objects.requireNonNull(instance, "instance");
      Boolean asyncValue = instance.getAsync();
      if (asyncValue != null) {
        async(asyncValue);
      }
      this.sharedDomainId(instance.getSharedDomainId());
      return this;
    }

    /**
     * Initializes the value for the {@link DeleteSharedDomainRequest#getAsync() async} attribute.
     * @param async The value for async (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder async(@Nullable Boolean async) {
      this.async = async;
      return this;
    }

    /**
     * Initializes the value for the {@link DeleteSharedDomainRequest#getSharedDomainId() sharedDomainId} attribute.
     * @param sharedDomainId The value for sharedDomainId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder sharedDomainId(String sharedDomainId) {
      this.sharedDomainId = Objects.requireNonNull(sharedDomainId, "sharedDomainId");
      initBits &= ~INIT_BIT_SHARED_DOMAIN_ID;
      return this;
    }

    /**
     * Builds a new {@link DeleteSharedDomainRequest DeleteSharedDomainRequest}.
     * @return An immutable instance of DeleteSharedDomainRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public DeleteSharedDomainRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new DeleteSharedDomainRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_SHARED_DOMAIN_ID) != 0) attributes.add("sharedDomainId");
      return "Cannot build DeleteSharedDomainRequest, some of required attributes are not set " + attributes;
    }
  }
}
