package org.cloudfoundry.client.v2.spaces;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.OrderDirection;
import org.cloudfoundry.client.v2.PaginatedRequest;
import org.immutables.value.Generated;

/**
 * The request payload for the List all Routes for the Space operation
 */
@Generated(from = "_ListSpaceRoutesRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ListSpaceRoutesRequest extends org.cloudfoundry.client.v2.spaces._ListSpaceRoutesRequest {
  private final @Nullable OrderDirection orderDirection;
  private final @Nullable Integer page;
  private final @Nullable Integer resultsPerPage;
  private final @Nullable List<String> domainIds;
  private final @Nullable List<String> hosts;
  private final @Nullable List<String> paths;
  private final String spaceId;

  private ListSpaceRoutesRequest(ListSpaceRoutesRequest.Builder builder) {
    this.orderDirection = builder.orderDirection;
    this.page = builder.page;
    this.resultsPerPage = builder.resultsPerPage;
    this.domainIds = builder.domainIds == null ? null : createUnmodifiableList(true, builder.domainIds);
    this.hosts = builder.hosts == null ? null : createUnmodifiableList(true, builder.hosts);
    this.paths = builder.paths == null ? null : createUnmodifiableList(true, builder.paths);
    this.spaceId = builder.spaceId;
  }

  /**
   * The order direction
   */
  @Override
  public @Nullable OrderDirection getOrderDirection() {
    return orderDirection;
  }

  /**
   * The page
   */
  @Override
  public @Nullable Integer getPage() {
    return page;
  }

  /**
   * The results per page
   */
  @Override
  public @Nullable Integer getResultsPerPage() {
    return resultsPerPage;
  }

  /**
   * The domain ids
   */
  @Override
  public @Nullable List<String> getDomainIds() {
    return domainIds;
  }

  /**
   * The hosts
   */
  @Override
  public @Nullable List<String> getHosts() {
    return hosts;
  }

  /**
   * The paths
   */
  @Override
  public @Nullable List<String> getPaths() {
    return paths;
  }

  /**
   * The space id
   */
  @Override
  public String getSpaceId() {
    return spaceId;
  }

  /**
   * This instance is equal to all instances of {@code ListSpaceRoutesRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ListSpaceRoutesRequest
        && equalTo(0, (ListSpaceRoutesRequest) another);
  }

  private boolean equalTo(int synthetic, ListSpaceRoutesRequest another) {
    return Objects.equals(orderDirection, another.orderDirection)
        && Objects.equals(page, another.page)
        && Objects.equals(resultsPerPage, another.resultsPerPage)
        && Objects.equals(domainIds, another.domainIds)
        && Objects.equals(hosts, another.hosts)
        && Objects.equals(paths, another.paths)
        && spaceId.equals(another.spaceId);
  }

  /**
   * Computes a hash code from attributes: {@code orderDirection}, {@code page}, {@code resultsPerPage}, {@code domainIds}, {@code hosts}, {@code paths}, {@code spaceId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(orderDirection);
    h += (h << 5) + Objects.hashCode(page);
    h += (h << 5) + Objects.hashCode(resultsPerPage);
    h += (h << 5) + Objects.hashCode(domainIds);
    h += (h << 5) + Objects.hashCode(hosts);
    h += (h << 5) + Objects.hashCode(paths);
    h += (h << 5) + spaceId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ListSpaceRoutesRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ListSpaceRoutesRequest{"
        + "orderDirection=" + orderDirection
        + ", page=" + page
        + ", resultsPerPage=" + resultsPerPage
        + ", domainIds=" + domainIds
        + ", hosts=" + hosts
        + ", paths=" + paths
        + ", spaceId=" + spaceId
        + "}";
  }

  /**
   * Creates a builder for {@link ListSpaceRoutesRequest ListSpaceRoutesRequest}.
   * <pre>
   * ListSpaceRoutesRequest.builder()
   *    .orderDirection(org.cloudfoundry.client.v2.OrderDirection | null) // nullable {@link ListSpaceRoutesRequest#getOrderDirection() orderDirection}
   *    .page(Integer | null) // nullable {@link ListSpaceRoutesRequest#getPage() page}
   *    .resultsPerPage(Integer | null) // nullable {@link ListSpaceRoutesRequest#getResultsPerPage() resultsPerPage}
   *    .domainIds(List&amp;lt;String&amp;gt; | null) // nullable {@link ListSpaceRoutesRequest#getDomainIds() domainIds}
   *    .hosts(List&amp;lt;String&amp;gt; | null) // nullable {@link ListSpaceRoutesRequest#getHosts() hosts}
   *    .paths(List&amp;lt;String&amp;gt; | null) // nullable {@link ListSpaceRoutesRequest#getPaths() paths}
   *    .spaceId(String) // required {@link ListSpaceRoutesRequest#getSpaceId() spaceId}
   *    .build();
   * </pre>
   * @return A new ListSpaceRoutesRequest builder
   */
  public static ListSpaceRoutesRequest.Builder builder() {
    return new ListSpaceRoutesRequest.Builder();
  }

  /**
   * Builds instances of type {@link ListSpaceRoutesRequest ListSpaceRoutesRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ListSpaceRoutesRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_SPACE_ID = 0x1L;
    private long initBits = 0x1L;

    private OrderDirection orderDirection;
    private Integer page;
    private Integer resultsPerPage;
    private List<String> domainIds = null;
    private List<String> hosts = null;
    private List<String> paths = null;
    private String spaceId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ListSpaceRoutesRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ListSpaceRoutesRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _ListSpaceRoutesRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_ListSpaceRoutesRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v2.PaginatedRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PaginatedRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    private void from(short _unused, Object object) {
      if (object instanceof org.cloudfoundry.client.v2.spaces._ListSpaceRoutesRequest) {
        org.cloudfoundry.client.v2.spaces._ListSpaceRoutesRequest instance = (org.cloudfoundry.client.v2.spaces._ListSpaceRoutesRequest) object;
        List<String> domainIdsValue = instance.getDomainIds();
        if (domainIdsValue != null) {
          addAllDomainIds(domainIdsValue);
        }
        this.spaceId(instance.getSpaceId());
        List<String> hostsValue = instance.getHosts();
        if (hostsValue != null) {
          addAllHosts(hostsValue);
        }
        List<String> pathsValue = instance.getPaths();
        if (pathsValue != null) {
          addAllPaths(pathsValue);
        }
      }
      if (object instanceof PaginatedRequest) {
        PaginatedRequest instance = (PaginatedRequest) object;
        OrderDirection orderDirectionValue = instance.getOrderDirection();
        if (orderDirectionValue != null) {
          orderDirection(orderDirectionValue);
        }
        Integer resultsPerPageValue = instance.getResultsPerPage();
        if (resultsPerPageValue != null) {
          resultsPerPage(resultsPerPageValue);
        }
        Integer pageValue = instance.getPage();
        if (pageValue != null) {
          page(pageValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link ListSpaceRoutesRequest#getOrderDirection() orderDirection} attribute.
     * @param orderDirection The value for orderDirection (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder orderDirection(@Nullable OrderDirection orderDirection) {
      this.orderDirection = orderDirection;
      return this;
    }

    /**
     * Initializes the value for the {@link ListSpaceRoutesRequest#getPage() page} attribute.
     * @param page The value for page (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder page(@Nullable Integer page) {
      this.page = page;
      return this;
    }

    /**
     * Initializes the value for the {@link ListSpaceRoutesRequest#getResultsPerPage() resultsPerPage} attribute.
     * @param resultsPerPage The value for resultsPerPage (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder resultsPerPage(@Nullable Integer resultsPerPage) {
      this.resultsPerPage = resultsPerPage;
      return this;
    }

    /**
     * Adds one element to {@link ListSpaceRoutesRequest#getDomainIds() domainIds} list.
     * @param element A domainIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder domainId(String element) {
      if (this.domainIds == null) {
        this.domainIds = new ArrayList<String>();
      }
      this.domainIds.add(Objects.requireNonNull(element, "domainIds element"));
      return this;
    }

    /**
     * Adds elements to {@link ListSpaceRoutesRequest#getDomainIds() domainIds} list.
     * @param elements An array of domainIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder domainIds(String... elements) {
      if (this.domainIds == null) {
        this.domainIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.domainIds.add(Objects.requireNonNull(element, "domainIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListSpaceRoutesRequest#getDomainIds() domainIds} list.
     * @param elements An iterable of domainIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder domainIds(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.domainIds = null;
        return this;
      }
      this.domainIds = new ArrayList<String>();
      return addAllDomainIds(elements);
    }

    /**
     * Adds elements to {@link ListSpaceRoutesRequest#getDomainIds() domainIds} list.
     * @param elements An iterable of domainIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllDomainIds(Iterable<String> elements) {
      Objects.requireNonNull(elements, "domainIds element");
      if (this.domainIds == null) {
        this.domainIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.domainIds.add(Objects.requireNonNull(element, "domainIds element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListSpaceRoutesRequest#getHosts() hosts} list.
     * @param element A hosts element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder host(String element) {
      if (this.hosts == null) {
        this.hosts = new ArrayList<String>();
      }
      this.hosts.add(Objects.requireNonNull(element, "hosts element"));
      return this;
    }

    /**
     * Adds elements to {@link ListSpaceRoutesRequest#getHosts() hosts} list.
     * @param elements An array of hosts elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder hosts(String... elements) {
      if (this.hosts == null) {
        this.hosts = new ArrayList<String>();
      }
      for (String element : elements) {
        this.hosts.add(Objects.requireNonNull(element, "hosts element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListSpaceRoutesRequest#getHosts() hosts} list.
     * @param elements An iterable of hosts elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder hosts(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.hosts = null;
        return this;
      }
      this.hosts = new ArrayList<String>();
      return addAllHosts(elements);
    }

    /**
     * Adds elements to {@link ListSpaceRoutesRequest#getHosts() hosts} list.
     * @param elements An iterable of hosts elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllHosts(Iterable<String> elements) {
      Objects.requireNonNull(elements, "hosts element");
      if (this.hosts == null) {
        this.hosts = new ArrayList<String>();
      }
      for (String element : elements) {
        this.hosts.add(Objects.requireNonNull(element, "hosts element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListSpaceRoutesRequest#getPaths() paths} list.
     * @param element A paths element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder path(String element) {
      if (this.paths == null) {
        this.paths = new ArrayList<String>();
      }
      this.paths.add(Objects.requireNonNull(element, "paths element"));
      return this;
    }

    /**
     * Adds elements to {@link ListSpaceRoutesRequest#getPaths() paths} list.
     * @param elements An array of paths elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder paths(String... elements) {
      if (this.paths == null) {
        this.paths = new ArrayList<String>();
      }
      for (String element : elements) {
        this.paths.add(Objects.requireNonNull(element, "paths element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListSpaceRoutesRequest#getPaths() paths} list.
     * @param elements An iterable of paths elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder paths(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.paths = null;
        return this;
      }
      this.paths = new ArrayList<String>();
      return addAllPaths(elements);
    }

    /**
     * Adds elements to {@link ListSpaceRoutesRequest#getPaths() paths} list.
     * @param elements An iterable of paths elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllPaths(Iterable<String> elements) {
      Objects.requireNonNull(elements, "paths element");
      if (this.paths == null) {
        this.paths = new ArrayList<String>();
      }
      for (String element : elements) {
        this.paths.add(Objects.requireNonNull(element, "paths element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ListSpaceRoutesRequest#getSpaceId() spaceId} attribute.
     * @param spaceId The value for spaceId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceId(String spaceId) {
      this.spaceId = Objects.requireNonNull(spaceId, "spaceId");
      initBits &= ~INIT_BIT_SPACE_ID;
      return this;
    }

    /**
     * Builds a new {@link ListSpaceRoutesRequest ListSpaceRoutesRequest}.
     * @return An immutable instance of ListSpaceRoutesRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ListSpaceRoutesRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ListSpaceRoutesRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_SPACE_ID) != 0) attributes.add("spaceId");
      return "Cannot build ListSpaceRoutesRequest, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
