package org.cloudfoundry.client.v2.spaces;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.OrderDirection;
import org.cloudfoundry.client.v2.PaginatedRequest;
import org.immutables.value.Generated;

/**
 * The request payload for the List all Services for the Space operation
 */
@Generated(from = "_ListSpaceServicesRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ListSpaceServicesRequest
    extends org.cloudfoundry.client.v2.spaces._ListSpaceServicesRequest {
  private final @Nullable OrderDirection orderDirection;
  private final @Nullable Integer page;
  private final @Nullable Integer resultsPerPage;
  private final @Nullable List<String> actives;
  private final @Nullable List<String> labels;
  private final @Nullable List<String> providers;
  private final @Nullable List<String> serviceBrokerIds;
  private final String spaceId;

  private ListSpaceServicesRequest(ListSpaceServicesRequest.Builder builder) {
    this.orderDirection = builder.orderDirection;
    this.page = builder.page;
    this.resultsPerPage = builder.resultsPerPage;
    this.actives = builder.actives == null ? null : createUnmodifiableList(true, builder.actives);
    this.labels = builder.labels == null ? null : createUnmodifiableList(true, builder.labels);
    this.providers = builder.providers == null ? null : createUnmodifiableList(true, builder.providers);
    this.serviceBrokerIds = builder.serviceBrokerIds == null ? null : createUnmodifiableList(true, builder.serviceBrokerIds);
    this.spaceId = builder.spaceId;
  }

  /**
   * The order direction
   */
  @Override
  public @Nullable OrderDirection getOrderDirection() {
    return orderDirection;
  }

  /**
   * The page
   */
  @Override
  public @Nullable Integer getPage() {
    return page;
  }

  /**
   * The results per page
   */
  @Override
  public @Nullable Integer getResultsPerPage() {
    return resultsPerPage;
  }

  /**
   * The actives
   */
  @Override
  public @Nullable List<String> getActives() {
    return actives;
  }

  /**
   * The labels
   */
  @Override
  public @Nullable List<String> getLabels() {
    return labels;
  }

  /**
   * The providers
   */
  @Override
  public @Nullable List<String> getProviders() {
    return providers;
  }

  /**
   * The service broker ids
   */
  @Override
  public @Nullable List<String> getServiceBrokerIds() {
    return serviceBrokerIds;
  }

  /**
   * The space id
   */
  @Override
  public String getSpaceId() {
    return spaceId;
  }

  /**
   * This instance is equal to all instances of {@code ListSpaceServicesRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ListSpaceServicesRequest
        && equalTo(0, (ListSpaceServicesRequest) another);
  }

  private boolean equalTo(int synthetic, ListSpaceServicesRequest another) {
    return Objects.equals(orderDirection, another.orderDirection)
        && Objects.equals(page, another.page)
        && Objects.equals(resultsPerPage, another.resultsPerPage)
        && Objects.equals(actives, another.actives)
        && Objects.equals(labels, another.labels)
        && Objects.equals(providers, another.providers)
        && Objects.equals(serviceBrokerIds, another.serviceBrokerIds)
        && spaceId.equals(another.spaceId);
  }

  /**
   * Computes a hash code from attributes: {@code orderDirection}, {@code page}, {@code resultsPerPage}, {@code actives}, {@code labels}, {@code providers}, {@code serviceBrokerIds}, {@code spaceId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(orderDirection);
    h += (h << 5) + Objects.hashCode(page);
    h += (h << 5) + Objects.hashCode(resultsPerPage);
    h += (h << 5) + Objects.hashCode(actives);
    h += (h << 5) + Objects.hashCode(labels);
    h += (h << 5) + Objects.hashCode(providers);
    h += (h << 5) + Objects.hashCode(serviceBrokerIds);
    h += (h << 5) + spaceId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ListSpaceServicesRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ListSpaceServicesRequest{"
        + "orderDirection=" + orderDirection
        + ", page=" + page
        + ", resultsPerPage=" + resultsPerPage
        + ", actives=" + actives
        + ", labels=" + labels
        + ", providers=" + providers
        + ", serviceBrokerIds=" + serviceBrokerIds
        + ", spaceId=" + spaceId
        + "}";
  }

  /**
   * Creates a builder for {@link ListSpaceServicesRequest ListSpaceServicesRequest}.
   * <pre>
   * ListSpaceServicesRequest.builder()
   *    .orderDirection(org.cloudfoundry.client.v2.OrderDirection | null) // nullable {@link ListSpaceServicesRequest#getOrderDirection() orderDirection}
   *    .page(Integer | null) // nullable {@link ListSpaceServicesRequest#getPage() page}
   *    .resultsPerPage(Integer | null) // nullable {@link ListSpaceServicesRequest#getResultsPerPage() resultsPerPage}
   *    .actives(List&amp;lt;String&amp;gt; | null) // nullable {@link ListSpaceServicesRequest#getActives() actives}
   *    .labels(List&amp;lt;String&amp;gt; | null) // nullable {@link ListSpaceServicesRequest#getLabels() labels}
   *    .providers(List&amp;lt;String&amp;gt; | null) // nullable {@link ListSpaceServicesRequest#getProviders() providers}
   *    .serviceBrokerIds(List&amp;lt;String&amp;gt; | null) // nullable {@link ListSpaceServicesRequest#getServiceBrokerIds() serviceBrokerIds}
   *    .spaceId(String) // required {@link ListSpaceServicesRequest#getSpaceId() spaceId}
   *    .build();
   * </pre>
   * @return A new ListSpaceServicesRequest builder
   */
  public static ListSpaceServicesRequest.Builder builder() {
    return new ListSpaceServicesRequest.Builder();
  }

  /**
   * Builds instances of type {@link ListSpaceServicesRequest ListSpaceServicesRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ListSpaceServicesRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_SPACE_ID = 0x1L;
    private long initBits = 0x1L;

    private OrderDirection orderDirection;
    private Integer page;
    private Integer resultsPerPage;
    private List<String> actives = null;
    private List<String> labels = null;
    private List<String> providers = null;
    private List<String> serviceBrokerIds = null;
    private String spaceId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ListSpaceServicesRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ListSpaceServicesRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _ListSpaceServicesRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_ListSpaceServicesRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v2.PaginatedRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PaginatedRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    private void from(short _unused, Object object) {
      if (object instanceof org.cloudfoundry.client.v2.spaces._ListSpaceServicesRequest) {
        org.cloudfoundry.client.v2.spaces._ListSpaceServicesRequest instance = (org.cloudfoundry.client.v2.spaces._ListSpaceServicesRequest) object;
        this.spaceId(instance.getSpaceId());
        List<String> serviceBrokerIdsValue = instance.getServiceBrokerIds();
        if (serviceBrokerIdsValue != null) {
          addAllServiceBrokerIds(serviceBrokerIdsValue);
        }
        List<String> activesValue = instance.getActives();
        if (activesValue != null) {
          addAllActives(activesValue);
        }
        List<String> providersValue = instance.getProviders();
        if (providersValue != null) {
          addAllProviders(providersValue);
        }
        List<String> labelsValue = instance.getLabels();
        if (labelsValue != null) {
          addAllLabels(labelsValue);
        }
      }
      if (object instanceof PaginatedRequest) {
        PaginatedRequest instance = (PaginatedRequest) object;
        OrderDirection orderDirectionValue = instance.getOrderDirection();
        if (orderDirectionValue != null) {
          orderDirection(orderDirectionValue);
        }
        Integer resultsPerPageValue = instance.getResultsPerPage();
        if (resultsPerPageValue != null) {
          resultsPerPage(resultsPerPageValue);
        }
        Integer pageValue = instance.getPage();
        if (pageValue != null) {
          page(pageValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link ListSpaceServicesRequest#getOrderDirection() orderDirection} attribute.
     * @param orderDirection The value for orderDirection (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder orderDirection(@Nullable OrderDirection orderDirection) {
      this.orderDirection = orderDirection;
      return this;
    }

    /**
     * Initializes the value for the {@link ListSpaceServicesRequest#getPage() page} attribute.
     * @param page The value for page (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder page(@Nullable Integer page) {
      this.page = page;
      return this;
    }

    /**
     * Initializes the value for the {@link ListSpaceServicesRequest#getResultsPerPage() resultsPerPage} attribute.
     * @param resultsPerPage The value for resultsPerPage (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder resultsPerPage(@Nullable Integer resultsPerPage) {
      this.resultsPerPage = resultsPerPage;
      return this;
    }

    /**
     * Adds one element to {@link ListSpaceServicesRequest#getActives() actives} list.
     * @param element A actives element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder active(String element) {
      if (this.actives == null) {
        this.actives = new ArrayList<String>();
      }
      this.actives.add(Objects.requireNonNull(element, "actives element"));
      return this;
    }

    /**
     * Adds elements to {@link ListSpaceServicesRequest#getActives() actives} list.
     * @param elements An array of actives elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder actives(String... elements) {
      if (this.actives == null) {
        this.actives = new ArrayList<String>();
      }
      for (String element : elements) {
        this.actives.add(Objects.requireNonNull(element, "actives element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListSpaceServicesRequest#getActives() actives} list.
     * @param elements An iterable of actives elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder actives(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.actives = null;
        return this;
      }
      this.actives = new ArrayList<String>();
      return addAllActives(elements);
    }

    /**
     * Adds elements to {@link ListSpaceServicesRequest#getActives() actives} list.
     * @param elements An iterable of actives elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllActives(Iterable<String> elements) {
      Objects.requireNonNull(elements, "actives element");
      if (this.actives == null) {
        this.actives = new ArrayList<String>();
      }
      for (String element : elements) {
        this.actives.add(Objects.requireNonNull(element, "actives element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListSpaceServicesRequest#getLabels() labels} list.
     * @param element A labels element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder label(String element) {
      if (this.labels == null) {
        this.labels = new ArrayList<String>();
      }
      this.labels.add(Objects.requireNonNull(element, "labels element"));
      return this;
    }

    /**
     * Adds elements to {@link ListSpaceServicesRequest#getLabels() labels} list.
     * @param elements An array of labels elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder labels(String... elements) {
      if (this.labels == null) {
        this.labels = new ArrayList<String>();
      }
      for (String element : elements) {
        this.labels.add(Objects.requireNonNull(element, "labels element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListSpaceServicesRequest#getLabels() labels} list.
     * @param elements An iterable of labels elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder labels(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.labels = null;
        return this;
      }
      this.labels = new ArrayList<String>();
      return addAllLabels(elements);
    }

    /**
     * Adds elements to {@link ListSpaceServicesRequest#getLabels() labels} list.
     * @param elements An iterable of labels elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllLabels(Iterable<String> elements) {
      Objects.requireNonNull(elements, "labels element");
      if (this.labels == null) {
        this.labels = new ArrayList<String>();
      }
      for (String element : elements) {
        this.labels.add(Objects.requireNonNull(element, "labels element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListSpaceServicesRequest#getProviders() providers} list.
     * @param element A providers element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder provider(String element) {
      if (this.providers == null) {
        this.providers = new ArrayList<String>();
      }
      this.providers.add(Objects.requireNonNull(element, "providers element"));
      return this;
    }

    /**
     * Adds elements to {@link ListSpaceServicesRequest#getProviders() providers} list.
     * @param elements An array of providers elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder providers(String... elements) {
      if (this.providers == null) {
        this.providers = new ArrayList<String>();
      }
      for (String element : elements) {
        this.providers.add(Objects.requireNonNull(element, "providers element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListSpaceServicesRequest#getProviders() providers} list.
     * @param elements An iterable of providers elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder providers(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.providers = null;
        return this;
      }
      this.providers = new ArrayList<String>();
      return addAllProviders(elements);
    }

    /**
     * Adds elements to {@link ListSpaceServicesRequest#getProviders() providers} list.
     * @param elements An iterable of providers elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllProviders(Iterable<String> elements) {
      Objects.requireNonNull(elements, "providers element");
      if (this.providers == null) {
        this.providers = new ArrayList<String>();
      }
      for (String element : elements) {
        this.providers.add(Objects.requireNonNull(element, "providers element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListSpaceServicesRequest#getServiceBrokerIds() serviceBrokerIds} list.
     * @param element A serviceBrokerIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceBrokerId(String element) {
      if (this.serviceBrokerIds == null) {
        this.serviceBrokerIds = new ArrayList<String>();
      }
      this.serviceBrokerIds.add(Objects.requireNonNull(element, "serviceBrokerIds element"));
      return this;
    }

    /**
     * Adds elements to {@link ListSpaceServicesRequest#getServiceBrokerIds() serviceBrokerIds} list.
     * @param elements An array of serviceBrokerIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceBrokerIds(String... elements) {
      if (this.serviceBrokerIds == null) {
        this.serviceBrokerIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.serviceBrokerIds.add(Objects.requireNonNull(element, "serviceBrokerIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListSpaceServicesRequest#getServiceBrokerIds() serviceBrokerIds} list.
     * @param elements An iterable of serviceBrokerIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceBrokerIds(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.serviceBrokerIds = null;
        return this;
      }
      this.serviceBrokerIds = new ArrayList<String>();
      return addAllServiceBrokerIds(elements);
    }

    /**
     * Adds elements to {@link ListSpaceServicesRequest#getServiceBrokerIds() serviceBrokerIds} list.
     * @param elements An iterable of serviceBrokerIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllServiceBrokerIds(Iterable<String> elements) {
      Objects.requireNonNull(elements, "serviceBrokerIds element");
      if (this.serviceBrokerIds == null) {
        this.serviceBrokerIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.serviceBrokerIds.add(Objects.requireNonNull(element, "serviceBrokerIds element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ListSpaceServicesRequest#getSpaceId() spaceId} attribute.
     * @param spaceId The value for spaceId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceId(String spaceId) {
      this.spaceId = Objects.requireNonNull(spaceId, "spaceId");
      initBits &= ~INIT_BIT_SPACE_ID;
      return this;
    }

    /**
     * Builds a new {@link ListSpaceServicesRequest ListSpaceServicesRequest}.
     * @return An immutable instance of ListSpaceServicesRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ListSpaceServicesRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ListSpaceServicesRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_SPACE_ID) != 0) attributes.add("spaceId");
      return "Cannot build ListSpaceServicesRequest, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
