package org.cloudfoundry.client.v2.spaces;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * The request payload for the Disassociate Manager with the Space by Username operation
 */
@Generated(from = "_RemoveSpaceManagerByUsernameRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class RemoveSpaceManagerByUsernameRequest
    extends org.cloudfoundry.client.v2.spaces._RemoveSpaceManagerByUsernameRequest {
  private final @Nullable String origin;
  private final String spaceId;
  private final String username;

  private RemoveSpaceManagerByUsernameRequest(RemoveSpaceManagerByUsernameRequest.Builder builder) {
    this.origin = builder.origin;
    this.spaceId = builder.spaceId;
    this.username = builder.username;
  }

  /**
   * The origin
   */
  @JsonProperty("origin")
  @Override
  public @Nullable String getOrigin() {
    return origin;
  }

  /**
   * The space id
   */
  @JsonProperty("spaceId")
  @JsonIgnore
  @Override
  public String getSpaceId() {
    return spaceId;
  }

  /**
   * The username
   */
  @JsonProperty("username")
  @Override
  public String getUsername() {
    return username;
  }

  /**
   * This instance is equal to all instances of {@code RemoveSpaceManagerByUsernameRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof RemoveSpaceManagerByUsernameRequest
        && equalTo(0, (RemoveSpaceManagerByUsernameRequest) another);
  }

  private boolean equalTo(int synthetic, RemoveSpaceManagerByUsernameRequest another) {
    return Objects.equals(origin, another.origin)
        && spaceId.equals(another.spaceId)
        && username.equals(another.username);
  }

  /**
   * Computes a hash code from attributes: {@code origin}, {@code spaceId}, {@code username}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(origin);
    h += (h << 5) + spaceId.hashCode();
    h += (h << 5) + username.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code RemoveSpaceManagerByUsernameRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "RemoveSpaceManagerByUsernameRequest{"
        + "origin=" + origin
        + ", spaceId=" + spaceId
        + ", username=" + username
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_RemoveSpaceManagerByUsernameRequest", generator = "Immutables")
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v2.spaces._RemoveSpaceManagerByUsernameRequest {
    String origin;
    String spaceId;
    String username;
    @JsonProperty("origin")
    public void setOrigin(@Nullable String origin) {
      this.origin = origin;
    }
    @JsonProperty("spaceId")
    @JsonIgnore
    public void setSpaceId(String spaceId) {
      this.spaceId = spaceId;
    }
    @JsonProperty("username")
    public void setUsername(String username) {
      this.username = username;
    }
    @Override
    public String getOrigin() { throw new UnsupportedOperationException(); }
    @Override
    public String getSpaceId() { throw new UnsupportedOperationException(); }
    @Override
    public String getUsername() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static RemoveSpaceManagerByUsernameRequest fromJson(Json json) {
    RemoveSpaceManagerByUsernameRequest.Builder builder = RemoveSpaceManagerByUsernameRequest.builder();
    if (json.origin != null) {
      builder.origin(json.origin);
    }
    if (json.spaceId != null) {
      builder.spaceId(json.spaceId);
    }
    if (json.username != null) {
      builder.username(json.username);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link RemoveSpaceManagerByUsernameRequest RemoveSpaceManagerByUsernameRequest}.
   * <pre>
   * RemoveSpaceManagerByUsernameRequest.builder()
   *    .origin(String | null) // nullable {@link RemoveSpaceManagerByUsernameRequest#getOrigin() origin}
   *    .spaceId(String) // required {@link RemoveSpaceManagerByUsernameRequest#getSpaceId() spaceId}
   *    .username(String) // required {@link RemoveSpaceManagerByUsernameRequest#getUsername() username}
   *    .build();
   * </pre>
   * @return A new RemoveSpaceManagerByUsernameRequest builder
   */
  public static RemoveSpaceManagerByUsernameRequest.Builder builder() {
    return new RemoveSpaceManagerByUsernameRequest.Builder();
  }

  /**
   * Builds instances of type {@link RemoveSpaceManagerByUsernameRequest RemoveSpaceManagerByUsernameRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_RemoveSpaceManagerByUsernameRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_SPACE_ID = 0x1L;
    private static final long INIT_BIT_USERNAME = 0x2L;
    private long initBits = 0x3L;

    private String origin;
    private String spaceId;
    private String username;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code RemoveSpaceManagerByUsernameRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(RemoveSpaceManagerByUsernameRequest instance) {
      return from((_RemoveSpaceManagerByUsernameRequest) instance);
    }

    /**
     * Copy abstract value type {@code _RemoveSpaceManagerByUsernameRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_RemoveSpaceManagerByUsernameRequest instance) {
      Objects.requireNonNull(instance, "instance");
      String originValue = instance.getOrigin();
      if (originValue != null) {
        origin(originValue);
      }
      this.spaceId(instance.getSpaceId());
      this.username(instance.getUsername());
      return this;
    }

    /**
     * Initializes the value for the {@link RemoveSpaceManagerByUsernameRequest#getOrigin() origin} attribute.
     * @param origin The value for origin (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder origin(@Nullable String origin) {
      this.origin = origin;
      return this;
    }

    /**
     * Initializes the value for the {@link RemoveSpaceManagerByUsernameRequest#getSpaceId() spaceId} attribute.
     * @param spaceId The value for spaceId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceId(String spaceId) {
      this.spaceId = Objects.requireNonNull(spaceId, "spaceId");
      initBits &= ~INIT_BIT_SPACE_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link RemoveSpaceManagerByUsernameRequest#getUsername() username} attribute.
     * @param username The value for username 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder username(String username) {
      this.username = Objects.requireNonNull(username, "username");
      initBits &= ~INIT_BIT_USERNAME;
      return this;
    }

    /**
     * Builds a new {@link RemoveSpaceManagerByUsernameRequest RemoveSpaceManagerByUsernameRequest}.
     * @return An immutable instance of RemoveSpaceManagerByUsernameRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public RemoveSpaceManagerByUsernameRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new RemoveSpaceManagerByUsernameRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_SPACE_ID) != 0) attributes.add("spaceId");
      if ((initBits & INIT_BIT_USERNAME) != 0) attributes.add("username");
      return "Cannot build RemoveSpaceManagerByUsernameRequest, some of required attributes are not set " + attributes;
    }
  }
}
