package org.cloudfoundry.client.v2.spaces;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * The request payload for the Update a Space operation
 */
@Generated(from = "_UpdateSpaceRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class UpdateSpaceRequest extends org.cloudfoundry.client.v2.spaces._UpdateSpaceRequest {
  private final @Nullable Boolean allowSsh;
  private final @Nullable List<String> auditorIds;
  private final @Nullable List<String> developerIds;
  private final @Nullable List<String> domainIds;
  private final @Nullable List<String> managerIds;
  private final @Nullable String name;
  private final @Nullable String organizationId;
  private final @Nullable List<String> securityGroupIds;
  private final String spaceId;

  private UpdateSpaceRequest(UpdateSpaceRequest.Builder builder) {
    this.allowSsh = builder.allowSsh;
    this.auditorIds = builder.auditorIds == null ? null : createUnmodifiableList(true, builder.auditorIds);
    this.developerIds = builder.developerIds == null ? null : createUnmodifiableList(true, builder.developerIds);
    this.domainIds = builder.domainIds == null ? null : createUnmodifiableList(true, builder.domainIds);
    this.managerIds = builder.managerIds == null ? null : createUnmodifiableList(true, builder.managerIds);
    this.name = builder.name;
    this.organizationId = builder.organizationId;
    this.securityGroupIds = builder.securityGroupIds == null ? null : createUnmodifiableList(true, builder.securityGroupIds);
    this.spaceId = builder.spaceId;
  }

  /**
   * Allow SSH
   */
  @JsonProperty("allow_ssh")
  @Override
  public @Nullable Boolean getAllowSsh() {
    return allowSsh;
  }

  /**
   * The auditor ids
   */
  @JsonProperty("auditor_guids")
  @Override
  public @Nullable List<String> getAuditorIds() {
    return auditorIds;
  }

  /**
   * The developer ids
   */
  @JsonProperty("developer_guids")
  @Override
  public @Nullable List<String> getDeveloperIds() {
    return developerIds;
  }

  /**
   * The domain ids
   */
  @JsonProperty("domain_guids")
  @Override
  public @Nullable List<String> getDomainIds() {
    return domainIds;
  }

  /**
   * The manager ids
   */
  @JsonProperty("manager_guids")
  @Override
  public @Nullable List<String> getManagerIds() {
    return managerIds;
  }

  /**
   * The name
   */
  @JsonProperty("name")
  @Override
  public @Nullable String getName() {
    return name;
  }

  /**
   * The organization id
   */
  @JsonProperty("organization_guid")
  @Override
  public @Nullable String getOrganizationId() {
    return organizationId;
  }

  /**
   * The security group ids
   */
  @JsonProperty("security_group_guids")
  @Override
  public @Nullable List<String> getSecurityGroupIds() {
    return securityGroupIds;
  }

  /**
   * The space id
   */
  @JsonProperty("spaceId")
  @JsonIgnore
  @Override
  public String getSpaceId() {
    return spaceId;
  }

  /**
   * This instance is equal to all instances of {@code UpdateSpaceRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof UpdateSpaceRequest
        && equalTo(0, (UpdateSpaceRequest) another);
  }

  private boolean equalTo(int synthetic, UpdateSpaceRequest another) {
    return Objects.equals(allowSsh, another.allowSsh)
        && Objects.equals(auditorIds, another.auditorIds)
        && Objects.equals(developerIds, another.developerIds)
        && Objects.equals(domainIds, another.domainIds)
        && Objects.equals(managerIds, another.managerIds)
        && Objects.equals(name, another.name)
        && Objects.equals(organizationId, another.organizationId)
        && Objects.equals(securityGroupIds, another.securityGroupIds)
        && spaceId.equals(another.spaceId);
  }

  /**
   * Computes a hash code from attributes: {@code allowSsh}, {@code auditorIds}, {@code developerIds}, {@code domainIds}, {@code managerIds}, {@code name}, {@code organizationId}, {@code securityGroupIds}, {@code spaceId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(allowSsh);
    h += (h << 5) + Objects.hashCode(auditorIds);
    h += (h << 5) + Objects.hashCode(developerIds);
    h += (h << 5) + Objects.hashCode(domainIds);
    h += (h << 5) + Objects.hashCode(managerIds);
    h += (h << 5) + Objects.hashCode(name);
    h += (h << 5) + Objects.hashCode(organizationId);
    h += (h << 5) + Objects.hashCode(securityGroupIds);
    h += (h << 5) + spaceId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code UpdateSpaceRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UpdateSpaceRequest{"
        + "allowSsh=" + allowSsh
        + ", auditorIds=" + auditorIds
        + ", developerIds=" + developerIds
        + ", domainIds=" + domainIds
        + ", managerIds=" + managerIds
        + ", name=" + name
        + ", organizationId=" + organizationId
        + ", securityGroupIds=" + securityGroupIds
        + ", spaceId=" + spaceId
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_UpdateSpaceRequest", generator = "Immutables")
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v2.spaces._UpdateSpaceRequest {
    Boolean allowSsh;
    List<String> auditorIds = null;
    List<String> developerIds = null;
    List<String> domainIds = null;
    List<String> managerIds = null;
    String name;
    String organizationId;
    List<String> securityGroupIds = null;
    String spaceId;
    @JsonProperty("allow_ssh")
    public void setAllowSsh(@Nullable Boolean allowSsh) {
      this.allowSsh = allowSsh;
    }
    @JsonProperty("auditor_guids")
    public void setAuditorIds(@Nullable List<String> auditorIds) {
      this.auditorIds = auditorIds;
    }
    @JsonProperty("developer_guids")
    public void setDeveloperIds(@Nullable List<String> developerIds) {
      this.developerIds = developerIds;
    }
    @JsonProperty("domain_guids")
    public void setDomainIds(@Nullable List<String> domainIds) {
      this.domainIds = domainIds;
    }
    @JsonProperty("manager_guids")
    public void setManagerIds(@Nullable List<String> managerIds) {
      this.managerIds = managerIds;
    }
    @JsonProperty("name")
    public void setName(@Nullable String name) {
      this.name = name;
    }
    @JsonProperty("organization_guid")
    public void setOrganizationId(@Nullable String organizationId) {
      this.organizationId = organizationId;
    }
    @JsonProperty("security_group_guids")
    public void setSecurityGroupIds(@Nullable List<String> securityGroupIds) {
      this.securityGroupIds = securityGroupIds;
    }
    @JsonProperty("spaceId")
    @JsonIgnore
    public void setSpaceId(String spaceId) {
      this.spaceId = spaceId;
    }
    @Override
    public Boolean getAllowSsh() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getAuditorIds() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getDeveloperIds() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getDomainIds() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getManagerIds() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public String getOrganizationId() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getSecurityGroupIds() { throw new UnsupportedOperationException(); }
    @Override
    public String getSpaceId() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static UpdateSpaceRequest fromJson(Json json) {
    UpdateSpaceRequest.Builder builder = UpdateSpaceRequest.builder();
    if (json.allowSsh != null) {
      builder.allowSsh(json.allowSsh);
    }
    if (json.auditorIds != null) {
      builder.addAllAuditorIds(json.auditorIds);
    }
    if (json.developerIds != null) {
      builder.addAllDeveloperIds(json.developerIds);
    }
    if (json.domainIds != null) {
      builder.addAllDomainIds(json.domainIds);
    }
    if (json.managerIds != null) {
      builder.addAllManagerIds(json.managerIds);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.organizationId != null) {
      builder.organizationId(json.organizationId);
    }
    if (json.securityGroupIds != null) {
      builder.addAllSecurityGroupIds(json.securityGroupIds);
    }
    if (json.spaceId != null) {
      builder.spaceId(json.spaceId);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link UpdateSpaceRequest UpdateSpaceRequest}.
   * <pre>
   * UpdateSpaceRequest.builder()
   *    .allowSsh(Boolean | null) // nullable {@link UpdateSpaceRequest#getAllowSsh() allowSsh}
   *    .auditorIds(List&amp;lt;String&amp;gt; | null) // nullable {@link UpdateSpaceRequest#getAuditorIds() auditorIds}
   *    .developerIds(List&amp;lt;String&amp;gt; | null) // nullable {@link UpdateSpaceRequest#getDeveloperIds() developerIds}
   *    .domainIds(List&amp;lt;String&amp;gt; | null) // nullable {@link UpdateSpaceRequest#getDomainIds() domainIds}
   *    .managerIds(List&amp;lt;String&amp;gt; | null) // nullable {@link UpdateSpaceRequest#getManagerIds() managerIds}
   *    .name(String | null) // nullable {@link UpdateSpaceRequest#getName() name}
   *    .organizationId(String | null) // nullable {@link UpdateSpaceRequest#getOrganizationId() organizationId}
   *    .securityGroupIds(List&amp;lt;String&amp;gt; | null) // nullable {@link UpdateSpaceRequest#getSecurityGroupIds() securityGroupIds}
   *    .spaceId(String) // required {@link UpdateSpaceRequest#getSpaceId() spaceId}
   *    .build();
   * </pre>
   * @return A new UpdateSpaceRequest builder
   */
  public static UpdateSpaceRequest.Builder builder() {
    return new UpdateSpaceRequest.Builder();
  }

  /**
   * Builds instances of type {@link UpdateSpaceRequest UpdateSpaceRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_UpdateSpaceRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_SPACE_ID = 0x1L;
    private long initBits = 0x1L;

    private Boolean allowSsh;
    private List<String> auditorIds = null;
    private List<String> developerIds = null;
    private List<String> domainIds = null;
    private List<String> managerIds = null;
    private String name;
    private String organizationId;
    private List<String> securityGroupIds = null;
    private String spaceId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code UpdateSpaceRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UpdateSpaceRequest instance) {
      return from((_UpdateSpaceRequest) instance);
    }

    /**
     * Copy abstract value type {@code _UpdateSpaceRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_UpdateSpaceRequest instance) {
      Objects.requireNonNull(instance, "instance");
      Boolean allowSshValue = instance.getAllowSsh();
      if (allowSshValue != null) {
        allowSsh(allowSshValue);
      }
      List<String> auditorIdsValue = instance.getAuditorIds();
      if (auditorIdsValue != null) {
        addAllAuditorIds(auditorIdsValue);
      }
      List<String> developerIdsValue = instance.getDeveloperIds();
      if (developerIdsValue != null) {
        addAllDeveloperIds(developerIdsValue);
      }
      List<String> domainIdsValue = instance.getDomainIds();
      if (domainIdsValue != null) {
        addAllDomainIds(domainIdsValue);
      }
      List<String> managerIdsValue = instance.getManagerIds();
      if (managerIdsValue != null) {
        addAllManagerIds(managerIdsValue);
      }
      String nameValue = instance.getName();
      if (nameValue != null) {
        name(nameValue);
      }
      String organizationIdValue = instance.getOrganizationId();
      if (organizationIdValue != null) {
        organizationId(organizationIdValue);
      }
      List<String> securityGroupIdsValue = instance.getSecurityGroupIds();
      if (securityGroupIdsValue != null) {
        addAllSecurityGroupIds(securityGroupIdsValue);
      }
      this.spaceId(instance.getSpaceId());
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateSpaceRequest#getAllowSsh() allowSsh} attribute.
     * @param allowSsh The value for allowSsh (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder allowSsh(@Nullable Boolean allowSsh) {
      this.allowSsh = allowSsh;
      return this;
    }

    /**
     * Adds one element to {@link UpdateSpaceRequest#getAuditorIds() auditorIds} list.
     * @param element A auditorIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder auditorId(String element) {
      if (this.auditorIds == null) {
        this.auditorIds = new ArrayList<String>();
      }
      this.auditorIds.add(Objects.requireNonNull(element, "auditorIds element"));
      return this;
    }

    /**
     * Adds elements to {@link UpdateSpaceRequest#getAuditorIds() auditorIds} list.
     * @param elements An array of auditorIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder auditorIds(String... elements) {
      if (this.auditorIds == null) {
        this.auditorIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.auditorIds.add(Objects.requireNonNull(element, "auditorIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link UpdateSpaceRequest#getAuditorIds() auditorIds} list.
     * @param elements An iterable of auditorIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder auditorIds(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.auditorIds = null;
        return this;
      }
      this.auditorIds = new ArrayList<String>();
      return addAllAuditorIds(elements);
    }

    /**
     * Adds elements to {@link UpdateSpaceRequest#getAuditorIds() auditorIds} list.
     * @param elements An iterable of auditorIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllAuditorIds(Iterable<String> elements) {
      Objects.requireNonNull(elements, "auditorIds element");
      if (this.auditorIds == null) {
        this.auditorIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.auditorIds.add(Objects.requireNonNull(element, "auditorIds element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link UpdateSpaceRequest#getDeveloperIds() developerIds} list.
     * @param element A developerIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder developerId(String element) {
      if (this.developerIds == null) {
        this.developerIds = new ArrayList<String>();
      }
      this.developerIds.add(Objects.requireNonNull(element, "developerIds element"));
      return this;
    }

    /**
     * Adds elements to {@link UpdateSpaceRequest#getDeveloperIds() developerIds} list.
     * @param elements An array of developerIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder developerIds(String... elements) {
      if (this.developerIds == null) {
        this.developerIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.developerIds.add(Objects.requireNonNull(element, "developerIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link UpdateSpaceRequest#getDeveloperIds() developerIds} list.
     * @param elements An iterable of developerIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder developerIds(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.developerIds = null;
        return this;
      }
      this.developerIds = new ArrayList<String>();
      return addAllDeveloperIds(elements);
    }

    /**
     * Adds elements to {@link UpdateSpaceRequest#getDeveloperIds() developerIds} list.
     * @param elements An iterable of developerIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllDeveloperIds(Iterable<String> elements) {
      Objects.requireNonNull(elements, "developerIds element");
      if (this.developerIds == null) {
        this.developerIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.developerIds.add(Objects.requireNonNull(element, "developerIds element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link UpdateSpaceRequest#getDomainIds() domainIds} list.
     * @param element A domainIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder domainId(String element) {
      if (this.domainIds == null) {
        this.domainIds = new ArrayList<String>();
      }
      this.domainIds.add(Objects.requireNonNull(element, "domainIds element"));
      return this;
    }

    /**
     * Adds elements to {@link UpdateSpaceRequest#getDomainIds() domainIds} list.
     * @param elements An array of domainIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder domainIds(String... elements) {
      if (this.domainIds == null) {
        this.domainIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.domainIds.add(Objects.requireNonNull(element, "domainIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link UpdateSpaceRequest#getDomainIds() domainIds} list.
     * @param elements An iterable of domainIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder domainIds(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.domainIds = null;
        return this;
      }
      this.domainIds = new ArrayList<String>();
      return addAllDomainIds(elements);
    }

    /**
     * Adds elements to {@link UpdateSpaceRequest#getDomainIds() domainIds} list.
     * @param elements An iterable of domainIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllDomainIds(Iterable<String> elements) {
      Objects.requireNonNull(elements, "domainIds element");
      if (this.domainIds == null) {
        this.domainIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.domainIds.add(Objects.requireNonNull(element, "domainIds element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link UpdateSpaceRequest#getManagerIds() managerIds} list.
     * @param element A managerIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder managerId(String element) {
      if (this.managerIds == null) {
        this.managerIds = new ArrayList<String>();
      }
      this.managerIds.add(Objects.requireNonNull(element, "managerIds element"));
      return this;
    }

    /**
     * Adds elements to {@link UpdateSpaceRequest#getManagerIds() managerIds} list.
     * @param elements An array of managerIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder managerIds(String... elements) {
      if (this.managerIds == null) {
        this.managerIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.managerIds.add(Objects.requireNonNull(element, "managerIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link UpdateSpaceRequest#getManagerIds() managerIds} list.
     * @param elements An iterable of managerIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder managerIds(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.managerIds = null;
        return this;
      }
      this.managerIds = new ArrayList<String>();
      return addAllManagerIds(elements);
    }

    /**
     * Adds elements to {@link UpdateSpaceRequest#getManagerIds() managerIds} list.
     * @param elements An iterable of managerIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllManagerIds(Iterable<String> elements) {
      Objects.requireNonNull(elements, "managerIds element");
      if (this.managerIds == null) {
        this.managerIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.managerIds.add(Objects.requireNonNull(element, "managerIds element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateSpaceRequest#getName() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(@Nullable String name) {
      this.name = name;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateSpaceRequest#getOrganizationId() organizationId} attribute.
     * @param organizationId The value for organizationId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationId(@Nullable String organizationId) {
      this.organizationId = organizationId;
      return this;
    }

    /**
     * Adds one element to {@link UpdateSpaceRequest#getSecurityGroupIds() securityGroupIds} list.
     * @param element A securityGroupIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder securityGroupId(String element) {
      if (this.securityGroupIds == null) {
        this.securityGroupIds = new ArrayList<String>();
      }
      this.securityGroupIds.add(Objects.requireNonNull(element, "securityGroupIds element"));
      return this;
    }

    /**
     * Adds elements to {@link UpdateSpaceRequest#getSecurityGroupIds() securityGroupIds} list.
     * @param elements An array of securityGroupIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder securityGroupIds(String... elements) {
      if (this.securityGroupIds == null) {
        this.securityGroupIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.securityGroupIds.add(Objects.requireNonNull(element, "securityGroupIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link UpdateSpaceRequest#getSecurityGroupIds() securityGroupIds} list.
     * @param elements An iterable of securityGroupIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder securityGroupIds(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.securityGroupIds = null;
        return this;
      }
      this.securityGroupIds = new ArrayList<String>();
      return addAllSecurityGroupIds(elements);
    }

    /**
     * Adds elements to {@link UpdateSpaceRequest#getSecurityGroupIds() securityGroupIds} list.
     * @param elements An iterable of securityGroupIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllSecurityGroupIds(Iterable<String> elements) {
      Objects.requireNonNull(elements, "securityGroupIds element");
      if (this.securityGroupIds == null) {
        this.securityGroupIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.securityGroupIds.add(Objects.requireNonNull(element, "securityGroupIds element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateSpaceRequest#getSpaceId() spaceId} attribute.
     * @param spaceId The value for spaceId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceId(String spaceId) {
      this.spaceId = Objects.requireNonNull(spaceId, "spaceId");
      initBits &= ~INIT_BIT_SPACE_ID;
      return this;
    }

    /**
     * Builds a new {@link UpdateSpaceRequest UpdateSpaceRequest}.
     * @return An immutable instance of UpdateSpaceRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public UpdateSpaceRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new UpdateSpaceRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_SPACE_ID) != 0) attributes.add("spaceId");
      return "Cannot build UpdateSpaceRequest, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
