package org.cloudfoundry.client.v2.stacks;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * The entity response payload for the Stack resource
 */
@Generated(from = "_StackEntity", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class StackEntity extends org.cloudfoundry.client.v2.stacks._StackEntity {
  private final @Nullable String description;
  private final @Nullable String name;
  private final @Nullable String buildRootfsImage;
  private final @Nullable String runRootfsImage;

  private StackEntity(StackEntity.Builder builder) {
    this.description = builder.description;
    this.name = builder.name;
    this.buildRootfsImage = builder.buildRootfsImage;
    this.runRootfsImage = builder.runRootfsImage;
  }

  /**
   * The description
   */
  @JsonProperty("description")
  @Override
  public @Nullable String getDescription() {
    return description;
  }

  /**
   * The name
   */
  @JsonProperty("name")
  @Override
  public @Nullable String getName() {
    return name;
  }

  /**
   * Build RootFS Image
   */
  @JsonProperty("build_rootfs_image")
  @Override
  public @Nullable String getBuildRootfsImage() {
    return buildRootfsImage;
  }

  /**
   * Run RootFS Image
   */
  @JsonProperty("run_rootfs_image")
  @Override
  public @Nullable String getRunRootfsImage() {
    return runRootfsImage;
  }

  /**
   * This instance is equal to all instances of {@code StackEntity} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof StackEntity
        && equalTo(0, (StackEntity) another);
  }

  private boolean equalTo(int synthetic, StackEntity another) {
    return Objects.equals(description, another.description)
        && Objects.equals(name, another.name)
        && Objects.equals(buildRootfsImage, another.buildRootfsImage)
        && Objects.equals(runRootfsImage, another.runRootfsImage);
  }

  /**
   * Computes a hash code from attributes: {@code description}, {@code name}, {@code buildRootfsImage}, {@code runRootfsImage}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(description);
    h += (h << 5) + Objects.hashCode(name);
    h += (h << 5) + Objects.hashCode(buildRootfsImage);
    h += (h << 5) + Objects.hashCode(runRootfsImage);
    return h;
  }

  /**
   * Prints the immutable value {@code StackEntity} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "StackEntity{"
        + "description=" + description
        + ", name=" + name
        + ", buildRootfsImage=" + buildRootfsImage
        + ", runRootfsImage=" + runRootfsImage
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_StackEntity", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v2.stacks._StackEntity {
    String description;
    String name;
    String buildRootfsImage;
    String runRootfsImage;
    @JsonProperty("description")
    public void setDescription(@Nullable String description) {
      this.description = description;
    }
    @JsonProperty("name")
    public void setName(@Nullable String name) {
      this.name = name;
    }
    @JsonProperty("build_rootfs_image")
    public void setBuildRootfsImage(@Nullable String buildRootfsImage) {
      this.buildRootfsImage = buildRootfsImage;
    }
    @JsonProperty("run_rootfs_image")
    public void setRunRootfsImage(@Nullable String runRootfsImage) {
      this.runRootfsImage = runRootfsImage;
    }
    @Override
    public String getDescription() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public String getBuildRootfsImage() { throw new UnsupportedOperationException(); }
    @Override
    public String getRunRootfsImage() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static StackEntity fromJson(Json json) {
    StackEntity.Builder builder = StackEntity.builder();
    if (json.description != null) {
      builder.description(json.description);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.buildRootfsImage != null) {
      builder.buildRootfsImage(json.buildRootfsImage);
    }
    if (json.runRootfsImage != null) {
      builder.runRootfsImage(json.runRootfsImage);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link StackEntity StackEntity}.
   * <pre>
   * StackEntity.builder()
   *    .description(String | null) // nullable {@link StackEntity#getDescription() description}
   *    .name(String | null) // nullable {@link StackEntity#getName() name}
   *    .buildRootfsImage(String | null) // nullable {@link StackEntity#getBuildRootfsImage() buildRootfsImage}
   *    .runRootfsImage(String | null) // nullable {@link StackEntity#getRunRootfsImage() runRootfsImage}
   *    .build();
   * </pre>
   * @return A new StackEntity builder
   */
  public static StackEntity.Builder builder() {
    return new StackEntity.Builder();
  }

  /**
   * Builds instances of type {@link StackEntity StackEntity}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_StackEntity", generator = "Immutables")
  public static final class Builder {
    private String description;
    private String name;
    private String buildRootfsImage;
    private String runRootfsImage;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code StackEntity} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(StackEntity instance) {
      return from((_StackEntity) instance);
    }

    /**
     * Copy abstract value type {@code _StackEntity} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_StackEntity instance) {
      Objects.requireNonNull(instance, "instance");
      String descriptionValue = instance.getDescription();
      if (descriptionValue != null) {
        description(descriptionValue);
      }
      String nameValue = instance.getName();
      if (nameValue != null) {
        name(nameValue);
      }
      String buildRootfsImageValue = instance.getBuildRootfsImage();
      if (buildRootfsImageValue != null) {
        buildRootfsImage(buildRootfsImageValue);
      }
      String runRootfsImageValue = instance.getRunRootfsImage();
      if (runRootfsImageValue != null) {
        runRootfsImage(runRootfsImageValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link StackEntity#getDescription() description} attribute.
     * @param description The value for description (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("description")
    public final Builder description(@Nullable String description) {
      this.description = description;
      return this;
    }

    /**
     * Initializes the value for the {@link StackEntity#getName() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    public final Builder name(@Nullable String name) {
      this.name = name;
      return this;
    }

    /**
     * Initializes the value for the {@link StackEntity#getBuildRootfsImage() buildRootfsImage} attribute.
     * @param buildRootfsImage The value for buildRootfsImage (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("build_rootfs_image")
    public final Builder buildRootfsImage(@Nullable String buildRootfsImage) {
      this.buildRootfsImage = buildRootfsImage;
      return this;
    }

    /**
     * Initializes the value for the {@link StackEntity#getRunRootfsImage() runRootfsImage} attribute.
     * @param runRootfsImage The value for runRootfsImage (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("run_rootfs_image")
    public final Builder runRootfsImage(@Nullable String runRootfsImage) {
      this.runRootfsImage = runRootfsImage;
      return this;
    }

    /**
     * Builds a new {@link StackEntity StackEntity}.
     * @return An immutable instance of StackEntity
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public StackEntity build() {
      return new StackEntity(this);
    }
  }
}
