package org.cloudfoundry.client.v2.users;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * The request payload for the Associate Managed Organization with the User operation
 */
@Generated(from = "_AssociateUserManagedOrganizationRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class AssociateUserManagedOrganizationRequest
    extends org.cloudfoundry.client.v2.users._AssociateUserManagedOrganizationRequest {
  private final String managedOrganizationId;
  private final String userId;

  private AssociateUserManagedOrganizationRequest(AssociateUserManagedOrganizationRequest.Builder builder) {
    this.managedOrganizationId = builder.managedOrganizationId;
    this.userId = builder.userId;
  }

  /**
   * The id of the managed organization
   */
  @Override
  public String getManagedOrganizationId() {
    return managedOrganizationId;
  }

  /**
   * The id of the user
   */
  @Override
  public String getUserId() {
    return userId;
  }

  /**
   * This instance is equal to all instances of {@code AssociateUserManagedOrganizationRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof AssociateUserManagedOrganizationRequest
        && equalTo(0, (AssociateUserManagedOrganizationRequest) another);
  }

  private boolean equalTo(int synthetic, AssociateUserManagedOrganizationRequest another) {
    return managedOrganizationId.equals(another.managedOrganizationId)
        && userId.equals(another.userId);
  }

  /**
   * Computes a hash code from attributes: {@code managedOrganizationId}, {@code userId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + managedOrganizationId.hashCode();
    h += (h << 5) + userId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code AssociateUserManagedOrganizationRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "AssociateUserManagedOrganizationRequest{"
        + "managedOrganizationId=" + managedOrganizationId
        + ", userId=" + userId
        + "}";
  }

  /**
   * Creates a builder for {@link AssociateUserManagedOrganizationRequest AssociateUserManagedOrganizationRequest}.
   * <pre>
   * AssociateUserManagedOrganizationRequest.builder()
   *    .managedOrganizationId(String) // required {@link AssociateUserManagedOrganizationRequest#getManagedOrganizationId() managedOrganizationId}
   *    .userId(String) // required {@link AssociateUserManagedOrganizationRequest#getUserId() userId}
   *    .build();
   * </pre>
   * @return A new AssociateUserManagedOrganizationRequest builder
   */
  public static AssociateUserManagedOrganizationRequest.Builder builder() {
    return new AssociateUserManagedOrganizationRequest.Builder();
  }

  /**
   * Builds instances of type {@link AssociateUserManagedOrganizationRequest AssociateUserManagedOrganizationRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_AssociateUserManagedOrganizationRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_MANAGED_ORGANIZATION_ID = 0x1L;
    private static final long INIT_BIT_USER_ID = 0x2L;
    private long initBits = 0x3L;

    private String managedOrganizationId;
    private String userId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code AssociateUserManagedOrganizationRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AssociateUserManagedOrganizationRequest instance) {
      return from((_AssociateUserManagedOrganizationRequest) instance);
    }

    /**
     * Copy abstract value type {@code _AssociateUserManagedOrganizationRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_AssociateUserManagedOrganizationRequest instance) {
      Objects.requireNonNull(instance, "instance");
      this.managedOrganizationId(instance.getManagedOrganizationId());
      this.userId(instance.getUserId());
      return this;
    }

    /**
     * Initializes the value for the {@link AssociateUserManagedOrganizationRequest#getManagedOrganizationId() managedOrganizationId} attribute.
     * @param managedOrganizationId The value for managedOrganizationId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder managedOrganizationId(String managedOrganizationId) {
      this.managedOrganizationId = Objects.requireNonNull(managedOrganizationId, "managedOrganizationId");
      initBits &= ~INIT_BIT_MANAGED_ORGANIZATION_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link AssociateUserManagedOrganizationRequest#getUserId() userId} attribute.
     * @param userId The value for userId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder userId(String userId) {
      this.userId = Objects.requireNonNull(userId, "userId");
      initBits &= ~INIT_BIT_USER_ID;
      return this;
    }

    /**
     * Builds a new {@link AssociateUserManagedOrganizationRequest AssociateUserManagedOrganizationRequest}.
     * @return An immutable instance of AssociateUserManagedOrganizationRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public AssociateUserManagedOrganizationRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new AssociateUserManagedOrganizationRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_MANAGED_ORGANIZATION_ID) != 0) attributes.add("managedOrganizationId");
      if ((initBits & INIT_BIT_USER_ID) != 0) attributes.add("userId");
      return "Cannot build AssociateUserManagedOrganizationRequest, some of required attributes are not set " + attributes;
    }
  }
}
