package org.cloudfoundry.client.v2.users;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * The request payload for the Remove Audited Space from the User operation
 */
@Generated(from = "_RemoveUserAuditedSpaceRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class RemoveUserAuditedSpaceRequest
    extends org.cloudfoundry.client.v2.users._RemoveUserAuditedSpaceRequest {
  private final String auditedSpaceId;
  private final String userId;

  private RemoveUserAuditedSpaceRequest(RemoveUserAuditedSpaceRequest.Builder builder) {
    this.auditedSpaceId = builder.auditedSpaceId;
    this.userId = builder.userId;
  }

  /**
   * The id of the audited space
   */
  @Override
  public String getAuditedSpaceId() {
    return auditedSpaceId;
  }

  /**
   * The id of the user
   */
  @Override
  public String getUserId() {
    return userId;
  }

  /**
   * This instance is equal to all instances of {@code RemoveUserAuditedSpaceRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof RemoveUserAuditedSpaceRequest
        && equalTo(0, (RemoveUserAuditedSpaceRequest) another);
  }

  private boolean equalTo(int synthetic, RemoveUserAuditedSpaceRequest another) {
    return auditedSpaceId.equals(another.auditedSpaceId)
        && userId.equals(another.userId);
  }

  /**
   * Computes a hash code from attributes: {@code auditedSpaceId}, {@code userId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + auditedSpaceId.hashCode();
    h += (h << 5) + userId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code RemoveUserAuditedSpaceRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "RemoveUserAuditedSpaceRequest{"
        + "auditedSpaceId=" + auditedSpaceId
        + ", userId=" + userId
        + "}";
  }

  /**
   * Creates a builder for {@link RemoveUserAuditedSpaceRequest RemoveUserAuditedSpaceRequest}.
   * <pre>
   * RemoveUserAuditedSpaceRequest.builder()
   *    .auditedSpaceId(String) // required {@link RemoveUserAuditedSpaceRequest#getAuditedSpaceId() auditedSpaceId}
   *    .userId(String) // required {@link RemoveUserAuditedSpaceRequest#getUserId() userId}
   *    .build();
   * </pre>
   * @return A new RemoveUserAuditedSpaceRequest builder
   */
  public static RemoveUserAuditedSpaceRequest.Builder builder() {
    return new RemoveUserAuditedSpaceRequest.Builder();
  }

  /**
   * Builds instances of type {@link RemoveUserAuditedSpaceRequest RemoveUserAuditedSpaceRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_RemoveUserAuditedSpaceRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_AUDITED_SPACE_ID = 0x1L;
    private static final long INIT_BIT_USER_ID = 0x2L;
    private long initBits = 0x3L;

    private String auditedSpaceId;
    private String userId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code RemoveUserAuditedSpaceRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(RemoveUserAuditedSpaceRequest instance) {
      return from((_RemoveUserAuditedSpaceRequest) instance);
    }

    /**
     * Copy abstract value type {@code _RemoveUserAuditedSpaceRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_RemoveUserAuditedSpaceRequest instance) {
      Objects.requireNonNull(instance, "instance");
      this.auditedSpaceId(instance.getAuditedSpaceId());
      this.userId(instance.getUserId());
      return this;
    }

    /**
     * Initializes the value for the {@link RemoveUserAuditedSpaceRequest#getAuditedSpaceId() auditedSpaceId} attribute.
     * @param auditedSpaceId The value for auditedSpaceId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder auditedSpaceId(String auditedSpaceId) {
      this.auditedSpaceId = Objects.requireNonNull(auditedSpaceId, "auditedSpaceId");
      initBits &= ~INIT_BIT_AUDITED_SPACE_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link RemoveUserAuditedSpaceRequest#getUserId() userId} attribute.
     * @param userId The value for userId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder userId(String userId) {
      this.userId = Objects.requireNonNull(userId, "userId");
      initBits &= ~INIT_BIT_USER_ID;
      return this;
    }

    /**
     * Builds a new {@link RemoveUserAuditedSpaceRequest RemoveUserAuditedSpaceRequest}.
     * @return An immutable instance of RemoveUserAuditedSpaceRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public RemoveUserAuditedSpaceRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new RemoveUserAuditedSpaceRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_AUDITED_SPACE_ID) != 0) attributes.add("auditedSpaceId");
      if ((initBits & INIT_BIT_USER_ID) != 0) attributes.add("userId");
      return "Cannot build RemoveUserAuditedSpaceRequest, some of required attributes are not set " + attributes;
    }
  }
}
