package org.cloudfoundry.client.v2.users;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * The request payload for the Remove Organization from the User operation
 */
@Generated(from = "_RemoveUserOrganizationRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class RemoveUserOrganizationRequest
    extends org.cloudfoundry.client.v2.users._RemoveUserOrganizationRequest {
  private final String organizationId;
  private final String userId;

  private RemoveUserOrganizationRequest(RemoveUserOrganizationRequest.Builder builder) {
    this.organizationId = builder.organizationId;
    this.userId = builder.userId;
  }

  /**
   * The id of the organization
   */
  @Override
  public String getOrganizationId() {
    return organizationId;
  }

  /**
   * The id of the user
   */
  @Override
  public String getUserId() {
    return userId;
  }

  /**
   * This instance is equal to all instances of {@code RemoveUserOrganizationRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof RemoveUserOrganizationRequest
        && equalTo(0, (RemoveUserOrganizationRequest) another);
  }

  private boolean equalTo(int synthetic, RemoveUserOrganizationRequest another) {
    return organizationId.equals(another.organizationId)
        && userId.equals(another.userId);
  }

  /**
   * Computes a hash code from attributes: {@code organizationId}, {@code userId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + organizationId.hashCode();
    h += (h << 5) + userId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code RemoveUserOrganizationRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "RemoveUserOrganizationRequest{"
        + "organizationId=" + organizationId
        + ", userId=" + userId
        + "}";
  }

  /**
   * Creates a builder for {@link RemoveUserOrganizationRequest RemoveUserOrganizationRequest}.
   * <pre>
   * RemoveUserOrganizationRequest.builder()
   *    .organizationId(String) // required {@link RemoveUserOrganizationRequest#getOrganizationId() organizationId}
   *    .userId(String) // required {@link RemoveUserOrganizationRequest#getUserId() userId}
   *    .build();
   * </pre>
   * @return A new RemoveUserOrganizationRequest builder
   */
  public static RemoveUserOrganizationRequest.Builder builder() {
    return new RemoveUserOrganizationRequest.Builder();
  }

  /**
   * Builds instances of type {@link RemoveUserOrganizationRequest RemoveUserOrganizationRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_RemoveUserOrganizationRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_ORGANIZATION_ID = 0x1L;
    private static final long INIT_BIT_USER_ID = 0x2L;
    private long initBits = 0x3L;

    private String organizationId;
    private String userId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code RemoveUserOrganizationRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(RemoveUserOrganizationRequest instance) {
      return from((_RemoveUserOrganizationRequest) instance);
    }

    /**
     * Copy abstract value type {@code _RemoveUserOrganizationRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_RemoveUserOrganizationRequest instance) {
      Objects.requireNonNull(instance, "instance");
      this.organizationId(instance.getOrganizationId());
      this.userId(instance.getUserId());
      return this;
    }

    /**
     * Initializes the value for the {@link RemoveUserOrganizationRequest#getOrganizationId() organizationId} attribute.
     * @param organizationId The value for organizationId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationId(String organizationId) {
      this.organizationId = Objects.requireNonNull(organizationId, "organizationId");
      initBits &= ~INIT_BIT_ORGANIZATION_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link RemoveUserOrganizationRequest#getUserId() userId} attribute.
     * @param userId The value for userId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder userId(String userId) {
      this.userId = Objects.requireNonNull(userId, "userId");
      initBits &= ~INIT_BIT_USER_ID;
      return this;
    }

    /**
     * Builds a new {@link RemoveUserOrganizationRequest RemoveUserOrganizationRequest}.
     * @return An immutable instance of RemoveUserOrganizationRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public RemoveUserOrganizationRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new RemoveUserOrganizationRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ORGANIZATION_ID) != 0) attributes.add("organizationId");
      if ((initBits & INIT_BIT_USER_ID) != 0) attributes.add("userId");
      return "Cannot build RemoveUserOrganizationRequest, some of required attributes are not set " + attributes;
    }
  }
}
