package org.cloudfoundry.client.v3;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * The error object
 */
@Generated(from = "_Error", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class Error extends org.cloudfoundry.client.v3._Error {
  private final Integer code;
  private final String detail;
  private final String title;

  private Error(Error.Builder builder) {
    this.code = builder.code;
    this.detail = builder.detail;
    this.title = builder.title;
  }

  /**
   * A numeric code for the error
   */
  @JsonProperty("code")
  @Override
  public Integer getCode() {
    return code;
  }

  /**
   * Detailed description of the error
   */
  @JsonProperty("detail")
  @Override
  public String getDetail() {
    return detail;
  }

  /**
   * Short description of the error
   */
  @JsonProperty("title")
  @Override
  public String getTitle() {
    return title;
  }

  /**
   * This instance is equal to all instances of {@code Error} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof Error
        && equalTo(0, (Error) another);
  }

  private boolean equalTo(int synthetic, Error another) {
    return code.equals(another.code)
        && detail.equals(another.detail)
        && title.equals(another.title);
  }

  /**
   * Computes a hash code from attributes: {@code code}, {@code detail}, {@code title}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + code.hashCode();
    h += (h << 5) + detail.hashCode();
    h += (h << 5) + title.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Error} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Error{"
        + "code=" + code
        + ", detail=" + detail
        + ", title=" + title
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_Error", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3._Error {
    Integer code;
    String detail;
    String title;
    @JsonProperty("code")
    public void setCode(Integer code) {
      this.code = code;
    }
    @JsonProperty("detail")
    public void setDetail(String detail) {
      this.detail = detail;
    }
    @JsonProperty("title")
    public void setTitle(String title) {
      this.title = title;
    }
    @Override
    public Integer getCode() { throw new UnsupportedOperationException(); }
    @Override
    public String getDetail() { throw new UnsupportedOperationException(); }
    @Override
    public String getTitle() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static Error fromJson(Json json) {
    Error.Builder builder = Error.builder();
    if (json.code != null) {
      builder.code(json.code);
    }
    if (json.detail != null) {
      builder.detail(json.detail);
    }
    if (json.title != null) {
      builder.title(json.title);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link Error Error}.
   * <pre>
   * Error.builder()
   *    .code(Integer) // required {@link Error#getCode() code}
   *    .detail(String) // required {@link Error#getDetail() detail}
   *    .title(String) // required {@link Error#getTitle() title}
   *    .build();
   * </pre>
   * @return A new Error builder
   */
  public static Error.Builder builder() {
    return new Error.Builder();
  }

  /**
   * Builds instances of type {@link Error Error}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_Error", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_CODE = 0x1L;
    private static final long INIT_BIT_DETAIL = 0x2L;
    private static final long INIT_BIT_TITLE = 0x4L;
    private long initBits = 0x7L;

    private Integer code;
    private String detail;
    private String title;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Error} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Error instance) {
      return from((_Error) instance);
    }

    /**
     * Copy abstract value type {@code _Error} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_Error instance) {
      Objects.requireNonNull(instance, "instance");
      this.code(instance.getCode());
      this.detail(instance.getDetail());
      this.title(instance.getTitle());
      return this;
    }

    /**
     * Initializes the value for the {@link Error#getCode() code} attribute.
     * @param code The value for code 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("code")
    public final Builder code(Integer code) {
      this.code = Objects.requireNonNull(code, "code");
      initBits &= ~INIT_BIT_CODE;
      return this;
    }

    /**
     * Initializes the value for the {@link Error#getDetail() detail} attribute.
     * @param detail The value for detail 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("detail")
    public final Builder detail(String detail) {
      this.detail = Objects.requireNonNull(detail, "detail");
      initBits &= ~INIT_BIT_DETAIL;
      return this;
    }

    /**
     * Initializes the value for the {@link Error#getTitle() title} attribute.
     * @param title The value for title 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("title")
    public final Builder title(String title) {
      this.title = Objects.requireNonNull(title, "title");
      initBits &= ~INIT_BIT_TITLE;
      return this;
    }

    /**
     * Builds a new {@link Error Error}.
     * @return An immutable instance of Error
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public Error build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new Error(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_CODE) != 0) attributes.add("code");
      if ((initBits & INIT_BIT_DETAIL) != 0) attributes.add("detail");
      if ((initBits & INIT_BIT_TITLE) != 0) attributes.add("title");
      return "Cannot build Error, some of required attributes are not set " + attributes;
    }
  }
}
