package org.cloudfoundry.client.v3;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Represents a to-one relationship to another entity
 */
@Generated(from = "_ToManyRelationship", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ToManyRelationship extends org.cloudfoundry.client.v3._ToManyRelationship {
  private final List<Relationship> data;

  private ToManyRelationship(ToManyRelationship.Builder builder) {
    this.data = createUnmodifiableList(true, builder.data);
  }

  /**
   * The relationship data
   */
  @JsonProperty("data")
  @Override
  public List<Relationship> getData() {
    return data;
  }

  /**
   * This instance is equal to all instances of {@code ToManyRelationship} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ToManyRelationship
        && equalTo(0, (ToManyRelationship) another);
  }

  private boolean equalTo(int synthetic, ToManyRelationship another) {
    return data.equals(another.data);
  }

  /**
   * Computes a hash code from attributes: {@code data}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + data.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ToManyRelationship} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ToManyRelationship{"
        + "data=" + data
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_ToManyRelationship", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3._ToManyRelationship {
    List<Relationship> data = Collections.emptyList();
    @JsonProperty("data")
    public void setData(List<Relationship> data) {
      this.data = data;
    }
    @Override
    public List<Relationship> getData() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ToManyRelationship fromJson(Json json) {
    ToManyRelationship.Builder builder = ToManyRelationship.builder();
    if (json.data != null) {
      builder.addAllData(json.data);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link ToManyRelationship ToManyRelationship}.
   * <pre>
   * ToManyRelationship.builder()
   *    .data|addAllData(Relationship) // {@link ToManyRelationship#getData() data} elements
   *    .build();
   * </pre>
   * @return A new ToManyRelationship builder
   */
  public static ToManyRelationship.Builder builder() {
    return new ToManyRelationship.Builder();
  }

  /**
   * Builds instances of type {@link ToManyRelationship ToManyRelationship}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ToManyRelationship", generator = "Immutables")
  public static final class Builder {
    private List<Relationship> data = new ArrayList<Relationship>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ToManyRelationship} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ToManyRelationship instance) {
      return from((_ToManyRelationship) instance);
    }

    /**
     * Copy abstract value type {@code _ToManyRelationship} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ToManyRelationship instance) {
      Objects.requireNonNull(instance, "instance");
      addAllData(instance.getData());
      return this;
    }

    /**
     * Adds one element to {@link ToManyRelationship#getData() data} list.
     * @param element A data element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder data(Relationship element) {
      this.data.add(Objects.requireNonNull(element, "data element"));
      return this;
    }

    /**
     * Adds elements to {@link ToManyRelationship#getData() data} list.
     * @param elements An array of data elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder data(Relationship... elements) {
      for (Relationship element : elements) {
        this.data.add(Objects.requireNonNull(element, "data element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ToManyRelationship#getData() data} list.
     * @param elements An iterable of data elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("data")
    public final Builder data(Iterable<? extends Relationship> elements) {
      this.data.clear();
      return addAllData(elements);
    }

    /**
     * Adds elements to {@link ToManyRelationship#getData() data} list.
     * @param elements An iterable of data elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllData(Iterable<? extends Relationship> elements) {
      for (Relationship element : elements) {
        this.data.add(Objects.requireNonNull(element, "data element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ToManyRelationship ToManyRelationship}.
     * @return An immutable instance of ToManyRelationship
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ToManyRelationship build() {
      return new ToManyRelationship(this);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
