package org.cloudfoundry.client.v3;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * Represents a summary of resource usage
 */
@Generated(from = "_UsageSummary", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class UsageSummary extends org.cloudfoundry.client.v3._UsageSummary {
  private final Integer memoryInMb;
  private final Integer startedInstances;
  private final @Nullable Integer routes;
  private final @Nullable Integer serviceInstances;
  private final @Nullable Integer reservedPorts;
  private final @Nullable Integer domains;
  private final @Nullable Integer perAppTasks;
  private final @Nullable Integer serviceKeys;

  private UsageSummary(UsageSummary.Builder builder) {
    this.memoryInMb = builder.memoryInMb;
    this.startedInstances = builder.startedInstances;
    this.routes = builder.routes;
    this.serviceInstances = builder.serviceInstances;
    this.reservedPorts = builder.reservedPorts;
    this.domains = builder.domains;
    this.perAppTasks = builder.perAppTasks;
    this.serviceKeys = builder.serviceKeys;
  }

  /**
   * The total memory usage
   */
  @JsonProperty("memory_in_mb")
  @Override
  public Integer getMemoryInMb() {
    return memoryInMb;
  }

  /**
   * The number of started instances
   */
  @JsonProperty("started_instances")
  @Override
  public Integer getStartedInstances() {
    return startedInstances;
  }

  /**
   * The number of routes
   */
  @JsonProperty("routes")
  @Override
  public @Nullable Integer getRoutes() {
    return routes;
  }

  /**
   * The number of service instances
   */
  @JsonProperty("service_instances")
  @Override
  public @Nullable Integer getServiceInstances() {
    return serviceInstances;
  }

  /**
   * The number of reserved ports
   */
  @JsonProperty("reserved_ports")
  @Override
  public @Nullable Integer getReservedPorts() {
    return reservedPorts;
  }

  /**
   * The number of domains
   */
  @JsonProperty("domains")
  @Override
  public @Nullable Integer getDomains() {
    return domains;
  }

  /**
   * The number of tasks per app
   */
  @JsonProperty("per_app_tasks")
  @Override
  public @Nullable Integer getPerAppTasks() {
    return perAppTasks;
  }

  /**
   * The number of service keys
   */
  @JsonProperty("service_keys")
  @Override
  public @Nullable Integer getServiceKeys() {
    return serviceKeys;
  }

  /**
   * This instance is equal to all instances of {@code UsageSummary} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof UsageSummary
        && equalTo(0, (UsageSummary) another);
  }

  private boolean equalTo(int synthetic, UsageSummary another) {
    return memoryInMb.equals(another.memoryInMb)
        && startedInstances.equals(another.startedInstances)
        && Objects.equals(routes, another.routes)
        && Objects.equals(serviceInstances, another.serviceInstances)
        && Objects.equals(reservedPorts, another.reservedPorts)
        && Objects.equals(domains, another.domains)
        && Objects.equals(perAppTasks, another.perAppTasks)
        && Objects.equals(serviceKeys, another.serviceKeys);
  }

  /**
   * Computes a hash code from attributes: {@code memoryInMb}, {@code startedInstances}, {@code routes}, {@code serviceInstances}, {@code reservedPorts}, {@code domains}, {@code perAppTasks}, {@code serviceKeys}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + memoryInMb.hashCode();
    h += (h << 5) + startedInstances.hashCode();
    h += (h << 5) + Objects.hashCode(routes);
    h += (h << 5) + Objects.hashCode(serviceInstances);
    h += (h << 5) + Objects.hashCode(reservedPorts);
    h += (h << 5) + Objects.hashCode(domains);
    h += (h << 5) + Objects.hashCode(perAppTasks);
    h += (h << 5) + Objects.hashCode(serviceKeys);
    return h;
  }

  /**
   * Prints the immutable value {@code UsageSummary} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UsageSummary{"
        + "memoryInMb=" + memoryInMb
        + ", startedInstances=" + startedInstances
        + ", routes=" + routes
        + ", serviceInstances=" + serviceInstances
        + ", reservedPorts=" + reservedPorts
        + ", domains=" + domains
        + ", perAppTasks=" + perAppTasks
        + ", serviceKeys=" + serviceKeys
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_UsageSummary", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3._UsageSummary {
    Integer memoryInMb;
    Integer startedInstances;
    Integer routes;
    Integer serviceInstances;
    Integer reservedPorts;
    Integer domains;
    Integer perAppTasks;
    Integer serviceKeys;
    @JsonProperty("memory_in_mb")
    public void setMemoryInMb(Integer memoryInMb) {
      this.memoryInMb = memoryInMb;
    }
    @JsonProperty("started_instances")
    public void setStartedInstances(Integer startedInstances) {
      this.startedInstances = startedInstances;
    }
    @JsonProperty("routes")
    public void setRoutes(@Nullable Integer routes) {
      this.routes = routes;
    }
    @JsonProperty("service_instances")
    public void setServiceInstances(@Nullable Integer serviceInstances) {
      this.serviceInstances = serviceInstances;
    }
    @JsonProperty("reserved_ports")
    public void setReservedPorts(@Nullable Integer reservedPorts) {
      this.reservedPorts = reservedPorts;
    }
    @JsonProperty("domains")
    public void setDomains(@Nullable Integer domains) {
      this.domains = domains;
    }
    @JsonProperty("per_app_tasks")
    public void setPerAppTasks(@Nullable Integer perAppTasks) {
      this.perAppTasks = perAppTasks;
    }
    @JsonProperty("service_keys")
    public void setServiceKeys(@Nullable Integer serviceKeys) {
      this.serviceKeys = serviceKeys;
    }
    @Override
    public Integer getMemoryInMb() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getStartedInstances() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getRoutes() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getServiceInstances() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getReservedPorts() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getDomains() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getPerAppTasks() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getServiceKeys() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static UsageSummary fromJson(Json json) {
    UsageSummary.Builder builder = UsageSummary.builder();
    if (json.memoryInMb != null) {
      builder.memoryInMb(json.memoryInMb);
    }
    if (json.startedInstances != null) {
      builder.startedInstances(json.startedInstances);
    }
    if (json.routes != null) {
      builder.routes(json.routes);
    }
    if (json.serviceInstances != null) {
      builder.serviceInstances(json.serviceInstances);
    }
    if (json.reservedPorts != null) {
      builder.reservedPorts(json.reservedPorts);
    }
    if (json.domains != null) {
      builder.domains(json.domains);
    }
    if (json.perAppTasks != null) {
      builder.perAppTasks(json.perAppTasks);
    }
    if (json.serviceKeys != null) {
      builder.serviceKeys(json.serviceKeys);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link UsageSummary UsageSummary}.
   * <pre>
   * UsageSummary.builder()
   *    .memoryInMb(Integer) // required {@link UsageSummary#getMemoryInMb() memoryInMb}
   *    .startedInstances(Integer) // required {@link UsageSummary#getStartedInstances() startedInstances}
   *    .routes(Integer | null) // nullable {@link UsageSummary#getRoutes() routes}
   *    .serviceInstances(Integer | null) // nullable {@link UsageSummary#getServiceInstances() serviceInstances}
   *    .reservedPorts(Integer | null) // nullable {@link UsageSummary#getReservedPorts() reservedPorts}
   *    .domains(Integer | null) // nullable {@link UsageSummary#getDomains() domains}
   *    .perAppTasks(Integer | null) // nullable {@link UsageSummary#getPerAppTasks() perAppTasks}
   *    .serviceKeys(Integer | null) // nullable {@link UsageSummary#getServiceKeys() serviceKeys}
   *    .build();
   * </pre>
   * @return A new UsageSummary builder
   */
  public static UsageSummary.Builder builder() {
    return new UsageSummary.Builder();
  }

  /**
   * Builds instances of type {@link UsageSummary UsageSummary}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_UsageSummary", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_MEMORY_IN_MB = 0x1L;
    private static final long INIT_BIT_STARTED_INSTANCES = 0x2L;
    private long initBits = 0x3L;

    private Integer memoryInMb;
    private Integer startedInstances;
    private Integer routes;
    private Integer serviceInstances;
    private Integer reservedPorts;
    private Integer domains;
    private Integer perAppTasks;
    private Integer serviceKeys;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code UsageSummary} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UsageSummary instance) {
      return from((_UsageSummary) instance);
    }

    /**
     * Copy abstract value type {@code _UsageSummary} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_UsageSummary instance) {
      Objects.requireNonNull(instance, "instance");
      this.memoryInMb(instance.getMemoryInMb());
      this.startedInstances(instance.getStartedInstances());
      Integer routesValue = instance.getRoutes();
      if (routesValue != null) {
        routes(routesValue);
      }
      Integer serviceInstancesValue = instance.getServiceInstances();
      if (serviceInstancesValue != null) {
        serviceInstances(serviceInstancesValue);
      }
      Integer reservedPortsValue = instance.getReservedPorts();
      if (reservedPortsValue != null) {
        reservedPorts(reservedPortsValue);
      }
      Integer domainsValue = instance.getDomains();
      if (domainsValue != null) {
        domains(domainsValue);
      }
      Integer perAppTasksValue = instance.getPerAppTasks();
      if (perAppTasksValue != null) {
        perAppTasks(perAppTasksValue);
      }
      Integer serviceKeysValue = instance.getServiceKeys();
      if (serviceKeysValue != null) {
        serviceKeys(serviceKeysValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link UsageSummary#getMemoryInMb() memoryInMb} attribute.
     * @param memoryInMb The value for memoryInMb 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("memory_in_mb")
    public final Builder memoryInMb(Integer memoryInMb) {
      this.memoryInMb = Objects.requireNonNull(memoryInMb, "memoryInMb");
      initBits &= ~INIT_BIT_MEMORY_IN_MB;
      return this;
    }

    /**
     * Initializes the value for the {@link UsageSummary#getStartedInstances() startedInstances} attribute.
     * @param startedInstances The value for startedInstances 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("started_instances")
    public final Builder startedInstances(Integer startedInstances) {
      this.startedInstances = Objects.requireNonNull(startedInstances, "startedInstances");
      initBits &= ~INIT_BIT_STARTED_INSTANCES;
      return this;
    }

    /**
     * Initializes the value for the {@link UsageSummary#getRoutes() routes} attribute.
     * @param routes The value for routes (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("routes")
    public final Builder routes(@Nullable Integer routes) {
      this.routes = routes;
      return this;
    }

    /**
     * Initializes the value for the {@link UsageSummary#getServiceInstances() serviceInstances} attribute.
     * @param serviceInstances The value for serviceInstances (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("service_instances")
    public final Builder serviceInstances(@Nullable Integer serviceInstances) {
      this.serviceInstances = serviceInstances;
      return this;
    }

    /**
     * Initializes the value for the {@link UsageSummary#getReservedPorts() reservedPorts} attribute.
     * @param reservedPorts The value for reservedPorts (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("reserved_ports")
    public final Builder reservedPorts(@Nullable Integer reservedPorts) {
      this.reservedPorts = reservedPorts;
      return this;
    }

    /**
     * Initializes the value for the {@link UsageSummary#getDomains() domains} attribute.
     * @param domains The value for domains (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("domains")
    public final Builder domains(@Nullable Integer domains) {
      this.domains = domains;
      return this;
    }

    /**
     * Initializes the value for the {@link UsageSummary#getPerAppTasks() perAppTasks} attribute.
     * @param perAppTasks The value for perAppTasks (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("per_app_tasks")
    public final Builder perAppTasks(@Nullable Integer perAppTasks) {
      this.perAppTasks = perAppTasks;
      return this;
    }

    /**
     * Initializes the value for the {@link UsageSummary#getServiceKeys() serviceKeys} attribute.
     * @param serviceKeys The value for serviceKeys (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("service_keys")
    public final Builder serviceKeys(@Nullable Integer serviceKeys) {
      this.serviceKeys = serviceKeys;
      return this;
    }

    /**
     * Builds a new {@link UsageSummary UsageSummary}.
     * @return An immutable instance of UsageSummary
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public UsageSummary build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new UsageSummary(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_MEMORY_IN_MB) != 0) attributes.add("memoryInMb");
      if ((initBits & INIT_BIT_STARTED_INSTANCES) != 0) attributes.add("startedInstances");
      return "Cannot build UsageSummary, some of required attributes are not set " + attributes;
    }
  }
}
