package org.cloudfoundry.client.v3.applications;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * The request payload for the Get Application operation
 */
@Generated(from = "_GetApplicationRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class GetApplicationRequest
    extends org.cloudfoundry.client.v3.applications._GetApplicationRequest {
  private final String applicationId;

  private GetApplicationRequest(GetApplicationRequest.Builder builder) {
    this.applicationId = builder.applicationId;
  }

  /**
   * The application id
   */
  @Override
  public String getApplicationId() {
    return applicationId;
  }

  /**
   * This instance is equal to all instances of {@code GetApplicationRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GetApplicationRequest
        && equalTo(0, (GetApplicationRequest) another);
  }

  private boolean equalTo(int synthetic, GetApplicationRequest another) {
    return applicationId.equals(another.applicationId);
  }

  /**
   * Computes a hash code from attributes: {@code applicationId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + applicationId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code GetApplicationRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GetApplicationRequest{"
        + "applicationId=" + applicationId
        + "}";
  }

  /**
   * Creates a builder for {@link GetApplicationRequest GetApplicationRequest}.
   * <pre>
   * GetApplicationRequest.builder()
   *    .applicationId(String) // required {@link GetApplicationRequest#getApplicationId() applicationId}
   *    .build();
   * </pre>
   * @return A new GetApplicationRequest builder
   */
  public static GetApplicationRequest.Builder builder() {
    return new GetApplicationRequest.Builder();
  }

  /**
   * Builds instances of type {@link GetApplicationRequest GetApplicationRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_GetApplicationRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_APPLICATION_ID = 0x1L;
    private long initBits = 0x1L;

    private String applicationId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GetApplicationRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GetApplicationRequest instance) {
      return from((_GetApplicationRequest) instance);
    }

    /**
     * Copy abstract value type {@code _GetApplicationRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_GetApplicationRequest instance) {
      Objects.requireNonNull(instance, "instance");
      this.applicationId(instance.getApplicationId());
      return this;
    }

    /**
     * Initializes the value for the {@link GetApplicationRequest#getApplicationId() applicationId} attribute.
     * @param applicationId The value for applicationId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationId(String applicationId) {
      this.applicationId = Objects.requireNonNull(applicationId, "applicationId");
      initBits &= ~INIT_BIT_APPLICATION_ID;
      return this;
    }

    /**
     * Builds a new {@link GetApplicationRequest GetApplicationRequest}.
     * @return An immutable instance of GetApplicationRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GetApplicationRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new GetApplicationRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_APPLICATION_ID) != 0) attributes.add("applicationId");
      return "Cannot build GetApplicationRequest, some of required attributes are not set " + attributes;
    }
  }
}
