package org.cloudfoundry.client.v3.applications;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.PaginatedRequest;
import org.cloudfoundry.client.v3.droplets.DropletState;
import org.immutables.value.Generated;

/**
 * The request payload for the List Application Droplets operation
 */
@Generated(from = "_ListApplicationDropletsRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ListApplicationDropletsRequest
    extends org.cloudfoundry.client.v3.applications._ListApplicationDropletsRequest {
  private final @Nullable String orderBy;
  private final @Nullable Integer page;
  private final @Nullable Integer perPage;
  private final String applicationId;
  private final @Nullable Boolean current;
  private final List<String> dropletIds;
  private final List<DropletState> states;

  private ListApplicationDropletsRequest(ListApplicationDropletsRequest.Builder builder) {
    this.orderBy = builder.orderBy;
    this.page = builder.page;
    this.perPage = builder.perPage;
    this.applicationId = builder.applicationId;
    this.current = builder.current;
    this.dropletIds = createUnmodifiableList(true, builder.dropletIds);
    this.states = createUnmodifiableList(true, builder.states);
  }

  /**
   * The order by
   */
  @Override
  public @Nullable String getOrderBy() {
    return orderBy;
  }

  /**
   * The page
   */
  @Override
  public @Nullable Integer getPage() {
    return page;
  }

  /**
   * The results per page
   */
  @Override
  public @Nullable Integer getPerPage() {
    return perPage;
  }

  /**
   * The application id
   */
  @Override
  public String getApplicationId() {
    return applicationId;
  }

  /**
   * Whether to only include the droplet current assigned to the app
   */
  @Override
  public @Nullable Boolean getCurrent() {
    return current;
  }

  /**
   * The droplet ids
   */
  @Override
  public List<String> getDropletIds() {
    return dropletIds;
  }

  /**
   * The states
   */
  @Override
  public List<DropletState> getStates() {
    return states;
  }

  /**
   * This instance is equal to all instances of {@code ListApplicationDropletsRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ListApplicationDropletsRequest
        && equalTo(0, (ListApplicationDropletsRequest) another);
  }

  private boolean equalTo(int synthetic, ListApplicationDropletsRequest another) {
    return Objects.equals(orderBy, another.orderBy)
        && Objects.equals(page, another.page)
        && Objects.equals(perPage, another.perPage)
        && applicationId.equals(another.applicationId)
        && Objects.equals(current, another.current)
        && dropletIds.equals(another.dropletIds)
        && states.equals(another.states);
  }

  /**
   * Computes a hash code from attributes: {@code orderBy}, {@code page}, {@code perPage}, {@code applicationId}, {@code current}, {@code dropletIds}, {@code states}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(orderBy);
    h += (h << 5) + Objects.hashCode(page);
    h += (h << 5) + Objects.hashCode(perPage);
    h += (h << 5) + applicationId.hashCode();
    h += (h << 5) + Objects.hashCode(current);
    h += (h << 5) + dropletIds.hashCode();
    h += (h << 5) + states.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ListApplicationDropletsRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ListApplicationDropletsRequest{"
        + "orderBy=" + orderBy
        + ", page=" + page
        + ", perPage=" + perPage
        + ", applicationId=" + applicationId
        + ", current=" + current
        + ", dropletIds=" + dropletIds
        + ", states=" + states
        + "}";
  }

  private static ListApplicationDropletsRequest validate(ListApplicationDropletsRequest instance) {
    instance.check();
    return instance;
  }

  /**
   * Creates a builder for {@link ListApplicationDropletsRequest ListApplicationDropletsRequest}.
   * <pre>
   * ListApplicationDropletsRequest.builder()
   *    .orderBy(String | null) // nullable {@link ListApplicationDropletsRequest#getOrderBy() orderBy}
   *    .page(Integer | null) // nullable {@link ListApplicationDropletsRequest#getPage() page}
   *    .perPage(Integer | null) // nullable {@link ListApplicationDropletsRequest#getPerPage() perPage}
   *    .applicationId(String) // required {@link ListApplicationDropletsRequest#getApplicationId() applicationId}
   *    .current(Boolean | null) // nullable {@link ListApplicationDropletsRequest#getCurrent() current}
   *    .dropletId|addAllDropletIds(String) // {@link ListApplicationDropletsRequest#getDropletIds() dropletIds} elements
   *    .state|addAllStates(org.cloudfoundry.client.v3.droplets.DropletState) // {@link ListApplicationDropletsRequest#getStates() states} elements
   *    .build();
   * </pre>
   * @return A new ListApplicationDropletsRequest builder
   */
  public static ListApplicationDropletsRequest.Builder builder() {
    return new ListApplicationDropletsRequest.Builder();
  }

  /**
   * Builds instances of type {@link ListApplicationDropletsRequest ListApplicationDropletsRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ListApplicationDropletsRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_APPLICATION_ID = 0x1L;
    private long initBits = 0x1L;

    private String orderBy;
    private Integer page;
    private Integer perPage;
    private String applicationId;
    private Boolean current;
    private List<String> dropletIds = new ArrayList<String>();
    private List<DropletState> states = new ArrayList<DropletState>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v3.PaginatedRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PaginatedRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code ListApplicationDropletsRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ListApplicationDropletsRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _ListApplicationDropletsRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_ListApplicationDropletsRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    private void from(short _unused, Object object) {
      if (object instanceof PaginatedRequest) {
        PaginatedRequest instance = (PaginatedRequest) object;
        String orderByValue = instance.getOrderBy();
        if (orderByValue != null) {
          orderBy(orderByValue);
        }
        Integer perPageValue = instance.getPerPage();
        if (perPageValue != null) {
          perPage(perPageValue);
        }
        Integer pageValue = instance.getPage();
        if (pageValue != null) {
          page(pageValue);
        }
      }
      if (object instanceof org.cloudfoundry.client.v3.applications._ListApplicationDropletsRequest) {
        org.cloudfoundry.client.v3.applications._ListApplicationDropletsRequest instance = (org.cloudfoundry.client.v3.applications._ListApplicationDropletsRequest) object;
        Boolean currentValue = instance.getCurrent();
        if (currentValue != null) {
          current(currentValue);
        }
        addAllDropletIds(instance.getDropletIds());
        this.applicationId(instance.getApplicationId());
        addAllStates(instance.getStates());
      }
    }

    /**
     * Initializes the value for the {@link ListApplicationDropletsRequest#getOrderBy() orderBy} attribute.
     * @param orderBy The value for orderBy (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder orderBy(@Nullable String orderBy) {
      this.orderBy = orderBy;
      return this;
    }

    /**
     * Initializes the value for the {@link ListApplicationDropletsRequest#getPage() page} attribute.
     * @param page The value for page (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder page(@Nullable Integer page) {
      this.page = page;
      return this;
    }

    /**
     * Initializes the value for the {@link ListApplicationDropletsRequest#getPerPage() perPage} attribute.
     * @param perPage The value for perPage (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder perPage(@Nullable Integer perPage) {
      this.perPage = perPage;
      return this;
    }

    /**
     * Initializes the value for the {@link ListApplicationDropletsRequest#getApplicationId() applicationId} attribute.
     * @param applicationId The value for applicationId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationId(String applicationId) {
      this.applicationId = Objects.requireNonNull(applicationId, "applicationId");
      initBits &= ~INIT_BIT_APPLICATION_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link ListApplicationDropletsRequest#getCurrent() current} attribute.
     * @param current The value for current (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder current(@Nullable Boolean current) {
      this.current = current;
      return this;
    }

    /**
     * Adds one element to {@link ListApplicationDropletsRequest#getDropletIds() dropletIds} list.
     * @param element A dropletIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder dropletId(String element) {
      this.dropletIds.add(Objects.requireNonNull(element, "dropletIds element"));
      return this;
    }

    /**
     * Adds elements to {@link ListApplicationDropletsRequest#getDropletIds() dropletIds} list.
     * @param elements An array of dropletIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder dropletIds(String... elements) {
      for (String element : elements) {
        this.dropletIds.add(Objects.requireNonNull(element, "dropletIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListApplicationDropletsRequest#getDropletIds() dropletIds} list.
     * @param elements An iterable of dropletIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder dropletIds(Iterable<String> elements) {
      this.dropletIds.clear();
      return addAllDropletIds(elements);
    }

    /**
     * Adds elements to {@link ListApplicationDropletsRequest#getDropletIds() dropletIds} list.
     * @param elements An iterable of dropletIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllDropletIds(Iterable<String> elements) {
      for (String element : elements) {
        this.dropletIds.add(Objects.requireNonNull(element, "dropletIds element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListApplicationDropletsRequest#getStates() states} list.
     * @param element A states element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder state(DropletState element) {
      this.states.add(Objects.requireNonNull(element, "states element"));
      return this;
    }

    /**
     * Adds elements to {@link ListApplicationDropletsRequest#getStates() states} list.
     * @param elements An array of states elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder states(DropletState... elements) {
      for (DropletState element : elements) {
        this.states.add(Objects.requireNonNull(element, "states element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListApplicationDropletsRequest#getStates() states} list.
     * @param elements An iterable of states elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder states(Iterable<? extends DropletState> elements) {
      this.states.clear();
      return addAllStates(elements);
    }

    /**
     * Adds elements to {@link ListApplicationDropletsRequest#getStates() states} list.
     * @param elements An iterable of states elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllStates(Iterable<? extends DropletState> elements) {
      for (DropletState element : elements) {
        this.states.add(Objects.requireNonNull(element, "states element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ListApplicationDropletsRequest ListApplicationDropletsRequest}.
     * @return An immutable instance of ListApplicationDropletsRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ListApplicationDropletsRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return ListApplicationDropletsRequest.validate(new ListApplicationDropletsRequest(this));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_APPLICATION_ID) != 0) attributes.add("applicationId");
      return "Cannot build ListApplicationDropletsRequest, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
