package org.cloudfoundry.client.v3.applications;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.PaginatedRequest;
import org.immutables.value.Generated;

/**
 * The request payload for the List Application Processes operation
 */
@Generated(from = "_ListApplicationProcessesRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ListApplicationProcessesRequest
    extends org.cloudfoundry.client.v3.applications._ListApplicationProcessesRequest {
  private final @Nullable String orderBy;
  private final @Nullable Integer page;
  private final @Nullable Integer perPage;
  private final String applicationId;
  private final List<String> processId;
  private final List<String> types;

  private ListApplicationProcessesRequest(ListApplicationProcessesRequest.Builder builder) {
    this.orderBy = builder.orderBy;
    this.page = builder.page;
    this.perPage = builder.perPage;
    this.applicationId = builder.applicationId;
    this.processId = createUnmodifiableList(true, builder.processId);
    this.types = createUnmodifiableList(true, builder.types);
  }

  /**
   * The order by
   */
  @Override
  public @Nullable String getOrderBy() {
    return orderBy;
  }

  /**
   * The page
   */
  @Override
  public @Nullable Integer getPage() {
    return page;
  }

  /**
   * The results per page
   */
  @Override
  public @Nullable Integer getPerPage() {
    return perPage;
  }

  /**
   * The application id
   */
  @Override
  public String getApplicationId() {
    return applicationId;
  }

  /**
   * List of process ids to filter by
   */
  @Override
  public List<String> getProcessId() {
    return processId;
  }

  /**
   * List of process types to filter by
   */
  @Override
  public List<String> getTypes() {
    return types;
  }

  /**
   * This instance is equal to all instances of {@code ListApplicationProcessesRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ListApplicationProcessesRequest
        && equalTo(0, (ListApplicationProcessesRequest) another);
  }

  private boolean equalTo(int synthetic, ListApplicationProcessesRequest another) {
    return Objects.equals(orderBy, another.orderBy)
        && Objects.equals(page, another.page)
        && Objects.equals(perPage, another.perPage)
        && applicationId.equals(another.applicationId)
        && processId.equals(another.processId)
        && types.equals(another.types);
  }

  /**
   * Computes a hash code from attributes: {@code orderBy}, {@code page}, {@code perPage}, {@code applicationId}, {@code processId}, {@code types}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(orderBy);
    h += (h << 5) + Objects.hashCode(page);
    h += (h << 5) + Objects.hashCode(perPage);
    h += (h << 5) + applicationId.hashCode();
    h += (h << 5) + processId.hashCode();
    h += (h << 5) + types.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ListApplicationProcessesRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ListApplicationProcessesRequest{"
        + "orderBy=" + orderBy
        + ", page=" + page
        + ", perPage=" + perPage
        + ", applicationId=" + applicationId
        + ", processId=" + processId
        + ", types=" + types
        + "}";
  }

  private static ListApplicationProcessesRequest validate(ListApplicationProcessesRequest instance) {
    instance.check();
    return instance;
  }

  /**
   * Creates a builder for {@link ListApplicationProcessesRequest ListApplicationProcessesRequest}.
   * <pre>
   * ListApplicationProcessesRequest.builder()
   *    .orderBy(String | null) // nullable {@link ListApplicationProcessesRequest#getOrderBy() orderBy}
   *    .page(Integer | null) // nullable {@link ListApplicationProcessesRequest#getPage() page}
   *    .perPage(Integer | null) // nullable {@link ListApplicationProcessesRequest#getPerPage() perPage}
   *    .applicationId(String) // required {@link ListApplicationProcessesRequest#getApplicationId() applicationId}
   *    .processId|addAllProcessId(String) // {@link ListApplicationProcessesRequest#getProcessId() processId} elements
   *    .type|addAllTypes(String) // {@link ListApplicationProcessesRequest#getTypes() types} elements
   *    .build();
   * </pre>
   * @return A new ListApplicationProcessesRequest builder
   */
  public static ListApplicationProcessesRequest.Builder builder() {
    return new ListApplicationProcessesRequest.Builder();
  }

  /**
   * Builds instances of type {@link ListApplicationProcessesRequest ListApplicationProcessesRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ListApplicationProcessesRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_APPLICATION_ID = 0x1L;
    private long initBits = 0x1L;

    private String orderBy;
    private Integer page;
    private Integer perPage;
    private String applicationId;
    private List<String> processId = new ArrayList<String>();
    private List<String> types = new ArrayList<String>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v3.PaginatedRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PaginatedRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code ListApplicationProcessesRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ListApplicationProcessesRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _ListApplicationProcessesRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_ListApplicationProcessesRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    private void from(short _unused, Object object) {
      if (object instanceof PaginatedRequest) {
        PaginatedRequest instance = (PaginatedRequest) object;
        String orderByValue = instance.getOrderBy();
        if (orderByValue != null) {
          orderBy(orderByValue);
        }
        Integer perPageValue = instance.getPerPage();
        if (perPageValue != null) {
          perPage(perPageValue);
        }
        Integer pageValue = instance.getPage();
        if (pageValue != null) {
          page(pageValue);
        }
      }
      if (object instanceof org.cloudfoundry.client.v3.applications._ListApplicationProcessesRequest) {
        org.cloudfoundry.client.v3.applications._ListApplicationProcessesRequest instance = (org.cloudfoundry.client.v3.applications._ListApplicationProcessesRequest) object;
        this.applicationId(instance.getApplicationId());
        addAllProcessId(instance.getProcessId());
        addAllTypes(instance.getTypes());
      }
    }

    /**
     * Initializes the value for the {@link ListApplicationProcessesRequest#getOrderBy() orderBy} attribute.
     * @param orderBy The value for orderBy (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder orderBy(@Nullable String orderBy) {
      this.orderBy = orderBy;
      return this;
    }

    /**
     * Initializes the value for the {@link ListApplicationProcessesRequest#getPage() page} attribute.
     * @param page The value for page (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder page(@Nullable Integer page) {
      this.page = page;
      return this;
    }

    /**
     * Initializes the value for the {@link ListApplicationProcessesRequest#getPerPage() perPage} attribute.
     * @param perPage The value for perPage (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder perPage(@Nullable Integer perPage) {
      this.perPage = perPage;
      return this;
    }

    /**
     * Initializes the value for the {@link ListApplicationProcessesRequest#getApplicationId() applicationId} attribute.
     * @param applicationId The value for applicationId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationId(String applicationId) {
      this.applicationId = Objects.requireNonNull(applicationId, "applicationId");
      initBits &= ~INIT_BIT_APPLICATION_ID;
      return this;
    }

    /**
     * Adds one element to {@link ListApplicationProcessesRequest#getProcessId() processId} list.
     * @param element A processId element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder processId(String element) {
      this.processId.add(Objects.requireNonNull(element, "processId element"));
      return this;
    }

    /**
     * Adds elements to {@link ListApplicationProcessesRequest#getProcessId() processId} list.
     * @param elements An array of processId elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder processId(String... elements) {
      for (String element : elements) {
        this.processId.add(Objects.requireNonNull(element, "processId element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListApplicationProcessesRequest#getProcessId() processId} list.
     * @param elements An iterable of processId elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder processId(Iterable<String> elements) {
      this.processId.clear();
      return addAllProcessId(elements);
    }

    /**
     * Adds elements to {@link ListApplicationProcessesRequest#getProcessId() processId} list.
     * @param elements An iterable of processId elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllProcessId(Iterable<String> elements) {
      for (String element : elements) {
        this.processId.add(Objects.requireNonNull(element, "processId element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListApplicationProcessesRequest#getTypes() types} list.
     * @param element A types element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder type(String element) {
      this.types.add(Objects.requireNonNull(element, "types element"));
      return this;
    }

    /**
     * Adds elements to {@link ListApplicationProcessesRequest#getTypes() types} list.
     * @param elements An array of types elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder types(String... elements) {
      for (String element : elements) {
        this.types.add(Objects.requireNonNull(element, "types element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListApplicationProcessesRequest#getTypes() types} list.
     * @param elements An iterable of types elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder types(Iterable<String> elements) {
      this.types.clear();
      return addAllTypes(elements);
    }

    /**
     * Adds elements to {@link ListApplicationProcessesRequest#getTypes() types} list.
     * @param elements An iterable of types elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllTypes(Iterable<String> elements) {
      for (String element : elements) {
        this.types.add(Objects.requireNonNull(element, "types element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ListApplicationProcessesRequest ListApplicationProcessesRequest}.
     * @return An immutable instance of ListApplicationProcessesRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ListApplicationProcessesRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return ListApplicationProcessesRequest.validate(new ListApplicationProcessesRequest(this));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_APPLICATION_ID) != 0) attributes.add("applicationId");
      return "Cannot build ListApplicationProcessesRequest, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
