package org.cloudfoundry.client.v3.applications;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.client.v3.Relationship;
import org.immutables.value.Generated;

/**
 * The request payload for the Assign Application Droplet operation
 */
@Generated(from = "_SetApplicationCurrentDropletRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class SetApplicationCurrentDropletRequest
    extends org.cloudfoundry.client.v3.applications._SetApplicationCurrentDropletRequest {
  private final String applicationId;
  private final Relationship data;

  private SetApplicationCurrentDropletRequest(SetApplicationCurrentDropletRequest.Builder builder) {
    this.applicationId = builder.applicationId;
    this.data = builder.data;
  }

  /**
   * The application id
   */
  @JsonProperty("applicationId")
  @JsonIgnore
  @Override
  public String getApplicationId() {
    return applicationId;
  }

  /**
   * The entitled organizations
   */
  @JsonProperty("data")
  @Override
  public Relationship getData() {
    return data;
  }

  /**
   * This instance is equal to all instances of {@code SetApplicationCurrentDropletRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof SetApplicationCurrentDropletRequest
        && equalTo(0, (SetApplicationCurrentDropletRequest) another);
  }

  private boolean equalTo(int synthetic, SetApplicationCurrentDropletRequest another) {
    return applicationId.equals(another.applicationId)
        && data.equals(another.data);
  }

  /**
   * Computes a hash code from attributes: {@code applicationId}, {@code data}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + applicationId.hashCode();
    h += (h << 5) + data.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code SetApplicationCurrentDropletRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "SetApplicationCurrentDropletRequest{"
        + "applicationId=" + applicationId
        + ", data=" + data
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_SetApplicationCurrentDropletRequest", generator = "Immutables")
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.applications._SetApplicationCurrentDropletRequest {
    String applicationId;
    Relationship data;
    @JsonProperty("applicationId")
    @JsonIgnore
    public void setApplicationId(String applicationId) {
      this.applicationId = applicationId;
    }
    @JsonProperty("data")
    public void setData(Relationship data) {
      this.data = data;
    }
    @Override
    public String getApplicationId() { throw new UnsupportedOperationException(); }
    @Override
    public Relationship getData() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static SetApplicationCurrentDropletRequest fromJson(Json json) {
    SetApplicationCurrentDropletRequest.Builder builder = SetApplicationCurrentDropletRequest.builder();
    if (json.applicationId != null) {
      builder.applicationId(json.applicationId);
    }
    if (json.data != null) {
      builder.data(json.data);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link SetApplicationCurrentDropletRequest SetApplicationCurrentDropletRequest}.
   * <pre>
   * SetApplicationCurrentDropletRequest.builder()
   *    .applicationId(String) // required {@link SetApplicationCurrentDropletRequest#getApplicationId() applicationId}
   *    .data(org.cloudfoundry.client.v3.Relationship) // required {@link SetApplicationCurrentDropletRequest#getData() data}
   *    .build();
   * </pre>
   * @return A new SetApplicationCurrentDropletRequest builder
   */
  public static SetApplicationCurrentDropletRequest.Builder builder() {
    return new SetApplicationCurrentDropletRequest.Builder();
  }

  /**
   * Builds instances of type {@link SetApplicationCurrentDropletRequest SetApplicationCurrentDropletRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_SetApplicationCurrentDropletRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_APPLICATION_ID = 0x1L;
    private static final long INIT_BIT_DATA = 0x2L;
    private long initBits = 0x3L;

    private String applicationId;
    private Relationship data;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code SetApplicationCurrentDropletRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SetApplicationCurrentDropletRequest instance) {
      return from((_SetApplicationCurrentDropletRequest) instance);
    }

    /**
     * Copy abstract value type {@code _SetApplicationCurrentDropletRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_SetApplicationCurrentDropletRequest instance) {
      Objects.requireNonNull(instance, "instance");
      this.applicationId(instance.getApplicationId());
      this.data(instance.getData());
      return this;
    }

    /**
     * Initializes the value for the {@link SetApplicationCurrentDropletRequest#getApplicationId() applicationId} attribute.
     * @param applicationId The value for applicationId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationId(String applicationId) {
      this.applicationId = Objects.requireNonNull(applicationId, "applicationId");
      initBits &= ~INIT_BIT_APPLICATION_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link SetApplicationCurrentDropletRequest#getData() data} attribute.
     * @param data The value for data 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder data(Relationship data) {
      this.data = Objects.requireNonNull(data, "data");
      initBits &= ~INIT_BIT_DATA;
      return this;
    }

    /**
     * Builds a new {@link SetApplicationCurrentDropletRequest SetApplicationCurrentDropletRequest}.
     * @return An immutable instance of SetApplicationCurrentDropletRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public SetApplicationCurrentDropletRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new SetApplicationCurrentDropletRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_APPLICATION_ID) != 0) attributes.add("applicationId");
      if ((initBits & INIT_BIT_DATA) != 0) attributes.add("data");
      return "Cannot build SetApplicationCurrentDropletRequest, some of required attributes are not set " + attributes;
    }
  }
}
