package org.cloudfoundry.client.v3.buildpacks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.PaginatedRequest;
import org.immutables.value.Generated;

/**
 * The request payload for the List Buildpacks operation
 */
@Generated(from = "_ListBuildpacksRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ListBuildpacksRequest extends org.cloudfoundry.client.v3.buildpacks._ListBuildpacksRequest {
  private final @Nullable String orderBy;
  private final @Nullable Integer page;
  private final @Nullable Integer perPage;
  private final @Nullable List<String> names;
  private final @Nullable List<String> stacks;

  private ListBuildpacksRequest(ListBuildpacksRequest.Builder builder) {
    this.orderBy = builder.orderBy;
    this.page = builder.page;
    this.perPage = builder.perPage;
    this.names = builder.names == null ? null : createUnmodifiableList(true, builder.names);
    this.stacks = builder.stacks == null ? null : createUnmodifiableList(true, builder.stacks);
  }

  /**
   * The order by
   */
  @Override
  public @Nullable String getOrderBy() {
    return orderBy;
  }

  /**
   * The page
   */
  @Override
  public @Nullable Integer getPage() {
    return page;
  }

  /**
   * The results per page
   */
  @Override
  public @Nullable Integer getPerPage() {
    return perPage;
  }

  /**
   * The names
   */
  @Override
  public @Nullable List<String> getNames() {
    return names;
  }

  /**
   * The stacks
   */
  @Override
  public @Nullable List<String> getStacks() {
    return stacks;
  }

  /**
   * This instance is equal to all instances of {@code ListBuildpacksRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ListBuildpacksRequest
        && equalTo(0, (ListBuildpacksRequest) another);
  }

  private boolean equalTo(int synthetic, ListBuildpacksRequest another) {
    return Objects.equals(orderBy, another.orderBy)
        && Objects.equals(page, another.page)
        && Objects.equals(perPage, another.perPage)
        && Objects.equals(names, another.names)
        && Objects.equals(stacks, another.stacks);
  }

  /**
   * Computes a hash code from attributes: {@code orderBy}, {@code page}, {@code perPage}, {@code names}, {@code stacks}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(orderBy);
    h += (h << 5) + Objects.hashCode(page);
    h += (h << 5) + Objects.hashCode(perPage);
    h += (h << 5) + Objects.hashCode(names);
    h += (h << 5) + Objects.hashCode(stacks);
    return h;
  }

  /**
   * Prints the immutable value {@code ListBuildpacksRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ListBuildpacksRequest{"
        + "orderBy=" + orderBy
        + ", page=" + page
        + ", perPage=" + perPage
        + ", names=" + names
        + ", stacks=" + stacks
        + "}";
  }

  private static ListBuildpacksRequest validate(ListBuildpacksRequest instance) {
    instance.check();
    return instance;
  }

  /**
   * Creates a builder for {@link ListBuildpacksRequest ListBuildpacksRequest}.
   * <pre>
   * ListBuildpacksRequest.builder()
   *    .orderBy(String | null) // nullable {@link ListBuildpacksRequest#getOrderBy() orderBy}
   *    .page(Integer | null) // nullable {@link ListBuildpacksRequest#getPage() page}
   *    .perPage(Integer | null) // nullable {@link ListBuildpacksRequest#getPerPage() perPage}
   *    .names(List&amp;lt;String&amp;gt; | null) // nullable {@link ListBuildpacksRequest#getNames() names}
   *    .stacks(List&amp;lt;String&amp;gt; | null) // nullable {@link ListBuildpacksRequest#getStacks() stacks}
   *    .build();
   * </pre>
   * @return A new ListBuildpacksRequest builder
   */
  public static ListBuildpacksRequest.Builder builder() {
    return new ListBuildpacksRequest.Builder();
  }

  /**
   * Builds instances of type {@link ListBuildpacksRequest ListBuildpacksRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ListBuildpacksRequest", generator = "Immutables")
  public static final class Builder {
    private String orderBy;
    private Integer page;
    private Integer perPage;
    private List<String> names = null;
    private List<String> stacks = null;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v3.PaginatedRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PaginatedRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code ListBuildpacksRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ListBuildpacksRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _ListBuildpacksRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_ListBuildpacksRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    private void from(short _unused, Object object) {
      if (object instanceof PaginatedRequest) {
        PaginatedRequest instance = (PaginatedRequest) object;
        String orderByValue = instance.getOrderBy();
        if (orderByValue != null) {
          orderBy(orderByValue);
        }
        Integer perPageValue = instance.getPerPage();
        if (perPageValue != null) {
          perPage(perPageValue);
        }
        Integer pageValue = instance.getPage();
        if (pageValue != null) {
          page(pageValue);
        }
      }
      if (object instanceof org.cloudfoundry.client.v3.buildpacks._ListBuildpacksRequest) {
        org.cloudfoundry.client.v3.buildpacks._ListBuildpacksRequest instance = (org.cloudfoundry.client.v3.buildpacks._ListBuildpacksRequest) object;
        List<String> stacksValue = instance.getStacks();
        if (stacksValue != null) {
          addAllStacks(stacksValue);
        }
        List<String> namesValue = instance.getNames();
        if (namesValue != null) {
          addAllNames(namesValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link ListBuildpacksRequest#getOrderBy() orderBy} attribute.
     * @param orderBy The value for orderBy (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder orderBy(@Nullable String orderBy) {
      this.orderBy = orderBy;
      return this;
    }

    /**
     * Initializes the value for the {@link ListBuildpacksRequest#getPage() page} attribute.
     * @param page The value for page (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder page(@Nullable Integer page) {
      this.page = page;
      return this;
    }

    /**
     * Initializes the value for the {@link ListBuildpacksRequest#getPerPage() perPage} attribute.
     * @param perPage The value for perPage (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder perPage(@Nullable Integer perPage) {
      this.perPage = perPage;
      return this;
    }

    /**
     * Adds one element to {@link ListBuildpacksRequest#getNames() names} list.
     * @param element A names element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String element) {
      if (this.names == null) {
        this.names = new ArrayList<String>();
      }
      this.names.add(Objects.requireNonNull(element, "names element"));
      return this;
    }

    /**
     * Adds elements to {@link ListBuildpacksRequest#getNames() names} list.
     * @param elements An array of names elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder names(String... elements) {
      if (this.names == null) {
        this.names = new ArrayList<String>();
      }
      for (String element : elements) {
        this.names.add(Objects.requireNonNull(element, "names element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListBuildpacksRequest#getNames() names} list.
     * @param elements An iterable of names elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder names(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.names = null;
        return this;
      }
      this.names = new ArrayList<String>();
      return addAllNames(elements);
    }

    /**
     * Adds elements to {@link ListBuildpacksRequest#getNames() names} list.
     * @param elements An iterable of names elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllNames(Iterable<String> elements) {
      Objects.requireNonNull(elements, "names element");
      if (this.names == null) {
        this.names = new ArrayList<String>();
      }
      for (String element : elements) {
        this.names.add(Objects.requireNonNull(element, "names element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListBuildpacksRequest#getStacks() stacks} list.
     * @param element A stacks element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder stack(String element) {
      if (this.stacks == null) {
        this.stacks = new ArrayList<String>();
      }
      this.stacks.add(Objects.requireNonNull(element, "stacks element"));
      return this;
    }

    /**
     * Adds elements to {@link ListBuildpacksRequest#getStacks() stacks} list.
     * @param elements An array of stacks elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder stacks(String... elements) {
      if (this.stacks == null) {
        this.stacks = new ArrayList<String>();
      }
      for (String element : elements) {
        this.stacks.add(Objects.requireNonNull(element, "stacks element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListBuildpacksRequest#getStacks() stacks} list.
     * @param elements An iterable of stacks elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder stacks(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.stacks = null;
        return this;
      }
      this.stacks = new ArrayList<String>();
      return addAllStacks(elements);
    }

    /**
     * Adds elements to {@link ListBuildpacksRequest#getStacks() stacks} list.
     * @param elements An iterable of stacks elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllStacks(Iterable<String> elements) {
      Objects.requireNonNull(elements, "stacks element");
      if (this.stacks == null) {
        this.stacks = new ArrayList<String>();
      }
      for (String element : elements) {
        this.stacks.add(Objects.requireNonNull(element, "stacks element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ListBuildpacksRequest ListBuildpacksRequest}.
     * @return An immutable instance of ListBuildpacksRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ListBuildpacksRequest build() {
      return ListBuildpacksRequest.validate(new ListBuildpacksRequest(this));
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
