package org.cloudfoundry.client.v3.builds;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.Lifecycle;
import org.cloudfoundry.client.v3.Relationship;
import org.immutables.value.Generated;

/**
 * The request payload for the Create Build operation
 */
@Generated(from = "_CreateBuildRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class CreateBuildRequest extends org.cloudfoundry.client.v3.builds._CreateBuildRequest {
  private final @Nullable Lifecycle lifecycle;
  private final Relationship getPackage;

  private CreateBuildRequest(CreateBuildRequest.Builder builder) {
    this.lifecycle = builder.lifecycle;
    this.getPackage = builder.getPackage;
  }

  /**
   * The lifecycle
   */
  @JsonProperty("lifecycle")
  @Override
  public @Nullable Lifecycle getLifecycle() {
    return lifecycle;
  }

  /**
   * The package
   */
  @JsonProperty("package")
  @Override
  public Relationship getPackage() {
    return getPackage;
  }

  /**
   * This instance is equal to all instances of {@code CreateBuildRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof CreateBuildRequest
        && equalTo(0, (CreateBuildRequest) another);
  }

  private boolean equalTo(int synthetic, CreateBuildRequest another) {
    return Objects.equals(lifecycle, another.lifecycle)
        && getPackage.equals(another.getPackage);
  }

  /**
   * Computes a hash code from attributes: {@code lifecycle}, {@code getPackage}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(lifecycle);
    h += (h << 5) + getPackage.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code CreateBuildRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "CreateBuildRequest{"
        + "lifecycle=" + lifecycle
        + ", package=" + getPackage
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_CreateBuildRequest", generator = "Immutables")
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.builds._CreateBuildRequest {
    Lifecycle lifecycle;
    Relationship getPackage;
    @JsonProperty("lifecycle")
    public void setLifecycle(@Nullable Lifecycle lifecycle) {
      this.lifecycle = lifecycle;
    }
    @JsonProperty("package")
    public void setPackage(Relationship getPackage) {
      this.getPackage = getPackage;
    }
    @Override
    public Lifecycle getLifecycle() { throw new UnsupportedOperationException(); }
    @Override
    public Relationship getPackage() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static CreateBuildRequest fromJson(Json json) {
    CreateBuildRequest.Builder builder = CreateBuildRequest.builder();
    if (json.lifecycle != null) {
      builder.lifecycle(json.lifecycle);
    }
    if (json.getPackage != null) {
      builder.getPackage(json.getPackage);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link CreateBuildRequest CreateBuildRequest}.
   * <pre>
   * CreateBuildRequest.builder()
   *    .lifecycle(org.cloudfoundry.client.v3.Lifecycle | null) // nullable {@link CreateBuildRequest#getLifecycle() lifecycle}
   *    .getPackage(org.cloudfoundry.client.v3.Relationship) // required {@link CreateBuildRequest#getPackage() package}
   *    .build();
   * </pre>
   * @return A new CreateBuildRequest builder
   */
  public static CreateBuildRequest.Builder builder() {
    return new CreateBuildRequest.Builder();
  }

  /**
   * Builds instances of type {@link CreateBuildRequest CreateBuildRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_CreateBuildRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_GET_PACKAGE = 0x1L;
    private long initBits = 0x1L;

    private Lifecycle lifecycle;
    private Relationship getPackage;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CreateBuildRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(CreateBuildRequest instance) {
      return from((_CreateBuildRequest) instance);
    }

    /**
     * Copy abstract value type {@code _CreateBuildRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_CreateBuildRequest instance) {
      Objects.requireNonNull(instance, "instance");
      Lifecycle lifecycleValue = instance.getLifecycle();
      if (lifecycleValue != null) {
        lifecycle(lifecycleValue);
      }
      this.getPackage(instance.getPackage());
      return this;
    }

    /**
     * Initializes the value for the {@link CreateBuildRequest#getLifecycle() lifecycle} attribute.
     * @param lifecycle The value for lifecycle (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder lifecycle(@Nullable Lifecycle lifecycle) {
      this.lifecycle = lifecycle;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateBuildRequest#getPackage() package} attribute.
     * @param getPackage The value for getPackage 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder getPackage(Relationship getPackage) {
      this.getPackage = Objects.requireNonNull(getPackage, "getPackage");
      initBits &= ~INIT_BIT_GET_PACKAGE;
      return this;
    }

    /**
     * Builds a new {@link CreateBuildRequest CreateBuildRequest}.
     * @return An immutable instance of CreateBuildRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public CreateBuildRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new CreateBuildRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_GET_PACKAGE) != 0) attributes.add("package");
      return "Cannot build CreateBuildRequest, some of required attributes are not set " + attributes;
    }
  }
}
