package org.cloudfoundry.client.v3.builds;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.*;
import org.cloudfoundry.client.v3.Lifecycle;
import org.cloudfoundry.client.v3.Metadata;
import org.cloudfoundry.client.v3.Relationship;
import org.cloudfoundry.client.v3.Resource;
import org.immutables.value.Generated;

/**
 * The response payload for the Create Build operation
 */
@Generated(from = "_CreateBuildResponse", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class CreateBuildResponse extends org.cloudfoundry.client.v3.builds._CreateBuildResponse {
  private final String createdAt;
  private final String id;
  private final Map<String, Link> links;
  private final @Nullable String updatedAt;
  private final CreatedBy createdBy;
  private final @Nullable Droplet droplet;
  private final @Nullable String error;
  private final Relationship inputPackage;
  private final Lifecycle lifecycle;
  private final @Nullable Metadata metadata;
  private final @Nullable BuildRelationships relationships;
  private final BuildState state;
  private final @Nullable Integer stagingMemory;
  private final @Nullable Integer stagingDisk;
  private final @Nullable Integer stagingLogRateLimitBytesPerSecond;

  private CreateBuildResponse(CreateBuildResponse.Builder builder) {
    this.createdAt = builder.createdAt;
    this.id = builder.id;
    this.links = createUnmodifiableMap(false, false, builder.links);
    this.updatedAt = builder.updatedAt;
    this.createdBy = builder.createdBy;
    this.droplet = builder.droplet;
    this.error = builder.error;
    this.inputPackage = builder.inputPackage;
    this.lifecycle = builder.lifecycle;
    this.metadata = builder.metadata;
    this.relationships = builder.relationships;
    this.state = builder.state;
    this.stagingMemory = builder.stagingMemory;
    this.stagingDisk = builder.stagingDisk;
    this.stagingLogRateLimitBytesPerSecond = builder.stagingLogRateLimitBytesPerSecond;
  }

  /**
   * When the resource was created
   */
  @JsonProperty("created_at")
  @Override
  public String getCreatedAt() {
    return createdAt;
  }

  /**
   * The resource's id
   */
  @JsonProperty("guid")
  @Override
  public String getId() {
    return id;
  }

  /**
   * Links to related resources and actions for the resource
   */
  @JsonProperty("links")
  @Override
  public Map<String, Link> getLinks() {
    return links;
  }

  /**
   * When the resource was last updated
   */
  @JsonProperty("updated_at")
  @Override
  public @Nullable String getUpdatedAt() {
    return updatedAt;
  }

  /**
   * The user that created the build
   */
  @JsonProperty("created_by")
  @Override
  public CreatedBy getCreatedBy() {
    return createdBy;
  }

  /**
   * A resulting droplet from the staging process
   */
  @JsonProperty("droplet")
  @Override
  public @Nullable Droplet getDroplet() {
    return droplet;
  }

  /**
   * Describes errors during the build process
   */
  @JsonProperty("error")
  @Override
  public @Nullable String getError() {
    return error;
  }

  /**
   * The package that is the input to the staging process
   */
  @JsonProperty("package")
  @Override
  public Relationship getInputPackage() {
    return inputPackage;
  }

  /**
   * The lifecycle that was configured or discovered from the application
   */
  @JsonProperty("lifecycle")
  @Override
  public Lifecycle getLifecycle() {
    return lifecycle;
  }

  /**
   * The metadata
   */
  @JsonProperty("metadata")
  @Override
  public @Nullable Metadata getMetadata() {
    return metadata;
  }

  /**
   * The relationships
   */
  @JsonProperty("relationships")
  @Override
  public @Nullable BuildRelationships getRelationships() {
    return relationships;
  }

  /**
   * State of the build
   */
  @JsonProperty("state")
  @Override
  public BuildState getState() {
    return state;
  }

  /**
   * Memory used for the build (MB)
   */
  @JsonProperty("staging_memory_in_mb")
  @Override
  public @Nullable Integer getStagingMemory() {
    return stagingMemory;
  }

  /**
   * Disk space used for the build (MB)
   */
  @JsonProperty("staging_disk_in_mb")
  @Override
  public @Nullable Integer getStagingDisk() {
    return stagingDisk;
  }

  /**
   * Log rate limit in bytes per second allocated for staging of the build
   */
  @JsonProperty("staging_log_rate_limit_bytes_per_second")
  @Override
  public @Nullable Integer getStagingLogRateLimitBytesPerSecond() {
    return stagingLogRateLimitBytesPerSecond;
  }

  /**
   * This instance is equal to all instances of {@code CreateBuildResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof CreateBuildResponse
        && equalTo(0, (CreateBuildResponse) another);
  }

  private boolean equalTo(int synthetic, CreateBuildResponse another) {
    return createdAt.equals(another.createdAt)
        && id.equals(another.id)
        && links.equals(another.links)
        && Objects.equals(updatedAt, another.updatedAt)
        && createdBy.equals(another.createdBy)
        && Objects.equals(droplet, another.droplet)
        && Objects.equals(error, another.error)
        && inputPackage.equals(another.inputPackage)
        && lifecycle.equals(another.lifecycle)
        && Objects.equals(metadata, another.metadata)
        && Objects.equals(relationships, another.relationships)
        && state.equals(another.state)
        && Objects.equals(stagingMemory, another.stagingMemory)
        && Objects.equals(stagingDisk, another.stagingDisk)
        && Objects.equals(stagingLogRateLimitBytesPerSecond, another.stagingLogRateLimitBytesPerSecond);
  }

  /**
   * Computes a hash code from attributes: {@code createdAt}, {@code id}, {@code links}, {@code updatedAt}, {@code createdBy}, {@code droplet}, {@code error}, {@code inputPackage}, {@code lifecycle}, {@code metadata}, {@code relationships}, {@code state}, {@code stagingMemory}, {@code stagingDisk}, {@code stagingLogRateLimitBytesPerSecond}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + createdAt.hashCode();
    h += (h << 5) + id.hashCode();
    h += (h << 5) + links.hashCode();
    h += (h << 5) + Objects.hashCode(updatedAt);
    h += (h << 5) + createdBy.hashCode();
    h += (h << 5) + Objects.hashCode(droplet);
    h += (h << 5) + Objects.hashCode(error);
    h += (h << 5) + inputPackage.hashCode();
    h += (h << 5) + lifecycle.hashCode();
    h += (h << 5) + Objects.hashCode(metadata);
    h += (h << 5) + Objects.hashCode(relationships);
    h += (h << 5) + state.hashCode();
    h += (h << 5) + Objects.hashCode(stagingMemory);
    h += (h << 5) + Objects.hashCode(stagingDisk);
    h += (h << 5) + Objects.hashCode(stagingLogRateLimitBytesPerSecond);
    return h;
  }

  /**
   * Prints the immutable value {@code CreateBuildResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "CreateBuildResponse{"
        + "createdAt=" + createdAt
        + ", id=" + id
        + ", links=" + links
        + ", updatedAt=" + updatedAt
        + ", createdBy=" + createdBy
        + ", droplet=" + droplet
        + ", error=" + error
        + ", inputPackage=" + inputPackage
        + ", lifecycle=" + lifecycle
        + ", metadata=" + metadata
        + ", relationships=" + relationships
        + ", state=" + state
        + ", stagingMemory=" + stagingMemory
        + ", stagingDisk=" + stagingDisk
        + ", stagingLogRateLimitBytesPerSecond=" + stagingLogRateLimitBytesPerSecond
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_CreateBuildResponse", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.builds._CreateBuildResponse {
    String createdAt;
    String id;
    Map<String, Link> links = Collections.emptyMap();
    String updatedAt;
    CreatedBy createdBy;
    Droplet droplet;
    String error;
    Relationship inputPackage;
    Lifecycle lifecycle;
    Metadata metadata;
    BuildRelationships relationships;
    BuildState state;
    Integer stagingMemory;
    Integer stagingDisk;
    Integer stagingLogRateLimitBytesPerSecond;
    @JsonProperty("created_at")
    public void setCreatedAt(String createdAt) {
      this.createdAt = createdAt;
    }
    @JsonProperty("guid")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("links")
    public void setLinks(Map<String, Link> links) {
      this.links = links;
    }
    @JsonProperty("updated_at")
    public void setUpdatedAt(@Nullable String updatedAt) {
      this.updatedAt = updatedAt;
    }
    @JsonProperty("created_by")
    public void setCreatedBy(CreatedBy createdBy) {
      this.createdBy = createdBy;
    }
    @JsonProperty("droplet")
    public void setDroplet(@Nullable Droplet droplet) {
      this.droplet = droplet;
    }
    @JsonProperty("error")
    public void setError(@Nullable String error) {
      this.error = error;
    }
    @JsonProperty("package")
    public void setInputPackage(Relationship inputPackage) {
      this.inputPackage = inputPackage;
    }
    @JsonProperty("lifecycle")
    public void setLifecycle(Lifecycle lifecycle) {
      this.lifecycle = lifecycle;
    }
    @JsonProperty("metadata")
    public void setMetadata(@Nullable Metadata metadata) {
      this.metadata = metadata;
    }
    @JsonProperty("relationships")
    public void setRelationships(@Nullable BuildRelationships relationships) {
      this.relationships = relationships;
    }
    @JsonProperty("state")
    public void setState(BuildState state) {
      this.state = state;
    }
    @JsonProperty("staging_memory_in_mb")
    public void setStagingMemory(@Nullable Integer stagingMemory) {
      this.stagingMemory = stagingMemory;
    }
    @JsonProperty("staging_disk_in_mb")
    public void setStagingDisk(@Nullable Integer stagingDisk) {
      this.stagingDisk = stagingDisk;
    }
    @JsonProperty("staging_log_rate_limit_bytes_per_second")
    public void setStagingLogRateLimitBytesPerSecond(@Nullable Integer stagingLogRateLimitBytesPerSecond) {
      this.stagingLogRateLimitBytesPerSecond = stagingLogRateLimitBytesPerSecond;
    }
    @Override
    public String getCreatedAt() { throw new UnsupportedOperationException(); }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, Link> getLinks() { throw new UnsupportedOperationException(); }
    @Override
    public String getUpdatedAt() { throw new UnsupportedOperationException(); }
    @Override
    public CreatedBy getCreatedBy() { throw new UnsupportedOperationException(); }
    @Override
    public Droplet getDroplet() { throw new UnsupportedOperationException(); }
    @Override
    public String getError() { throw new UnsupportedOperationException(); }
    @Override
    public Relationship getInputPackage() { throw new UnsupportedOperationException(); }
    @Override
    public Lifecycle getLifecycle() { throw new UnsupportedOperationException(); }
    @Override
    public Metadata getMetadata() { throw new UnsupportedOperationException(); }
    @Override
    public BuildRelationships getRelationships() { throw new UnsupportedOperationException(); }
    @Override
    public BuildState getState() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getStagingMemory() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getStagingDisk() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getStagingLogRateLimitBytesPerSecond() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static CreateBuildResponse fromJson(Json json) {
    CreateBuildResponse.Builder builder = CreateBuildResponse.builder();
    if (json.createdAt != null) {
      builder.createdAt(json.createdAt);
    }
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.links != null) {
      builder.putAllLinks(json.links);
    }
    if (json.updatedAt != null) {
      builder.updatedAt(json.updatedAt);
    }
    if (json.createdBy != null) {
      builder.createdBy(json.createdBy);
    }
    if (json.droplet != null) {
      builder.droplet(json.droplet);
    }
    if (json.error != null) {
      builder.error(json.error);
    }
    if (json.inputPackage != null) {
      builder.inputPackage(json.inputPackage);
    }
    if (json.lifecycle != null) {
      builder.lifecycle(json.lifecycle);
    }
    if (json.metadata != null) {
      builder.metadata(json.metadata);
    }
    if (json.relationships != null) {
      builder.relationships(json.relationships);
    }
    if (json.state != null) {
      builder.state(json.state);
    }
    if (json.stagingMemory != null) {
      builder.stagingMemory(json.stagingMemory);
    }
    if (json.stagingDisk != null) {
      builder.stagingDisk(json.stagingDisk);
    }
    if (json.stagingLogRateLimitBytesPerSecond != null) {
      builder.stagingLogRateLimitBytesPerSecond(json.stagingLogRateLimitBytesPerSecond);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link CreateBuildResponse CreateBuildResponse}.
   * <pre>
   * CreateBuildResponse.builder()
   *    .createdAt(String) // required {@link CreateBuildResponse#getCreatedAt() createdAt}
   *    .id(String) // required {@link CreateBuildResponse#getId() id}
   *    .link|putAllLinks(String =&gt; Link) // {@link CreateBuildResponse#getLinks() links} mappings
   *    .updatedAt(String | null) // nullable {@link CreateBuildResponse#getUpdatedAt() updatedAt}
   *    .createdBy(org.cloudfoundry.client.v3.builds.CreatedBy) // required {@link CreateBuildResponse#getCreatedBy() createdBy}
   *    .droplet(org.cloudfoundry.client.v3.builds.Droplet | null) // nullable {@link CreateBuildResponse#getDroplet() droplet}
   *    .error(String | null) // nullable {@link CreateBuildResponse#getError() error}
   *    .inputPackage(org.cloudfoundry.client.v3.Relationship) // required {@link CreateBuildResponse#getInputPackage() inputPackage}
   *    .lifecycle(org.cloudfoundry.client.v3.Lifecycle) // required {@link CreateBuildResponse#getLifecycle() lifecycle}
   *    .metadata(org.cloudfoundry.client.v3.Metadata | null) // nullable {@link CreateBuildResponse#getMetadata() metadata}
   *    .relationships(org.cloudfoundry.client.v3.builds.BuildRelationships | null) // nullable {@link CreateBuildResponse#getRelationships() relationships}
   *    .state(org.cloudfoundry.client.v3.builds.BuildState) // required {@link CreateBuildResponse#getState() state}
   *    .stagingMemory(Integer | null) // nullable {@link CreateBuildResponse#getStagingMemory() stagingMemory}
   *    .stagingDisk(Integer | null) // nullable {@link CreateBuildResponse#getStagingDisk() stagingDisk}
   *    .stagingLogRateLimitBytesPerSecond(Integer | null) // nullable {@link CreateBuildResponse#getStagingLogRateLimitBytesPerSecond() stagingLogRateLimitBytesPerSecond}
   *    .build();
   * </pre>
   * @return A new CreateBuildResponse builder
   */
  public static CreateBuildResponse.Builder builder() {
    return new CreateBuildResponse.Builder();
  }

  /**
   * Builds instances of type {@link CreateBuildResponse CreateBuildResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_CreateBuildResponse", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_CREATED_AT = 0x1L;
    private static final long INIT_BIT_ID = 0x2L;
    private static final long INIT_BIT_CREATED_BY = 0x4L;
    private static final long INIT_BIT_INPUT_PACKAGE = 0x8L;
    private static final long INIT_BIT_LIFECYCLE = 0x10L;
    private static final long INIT_BIT_STATE = 0x20L;
    private long initBits = 0x3fL;

    private String createdAt;
    private String id;
    private Map<String, Link> links = new LinkedHashMap<String, Link>();
    private String updatedAt;
    private CreatedBy createdBy;
    private Droplet droplet;
    private String error;
    private Relationship inputPackage;
    private Lifecycle lifecycle;
    private Metadata metadata;
    private BuildRelationships relationships;
    private BuildState state;
    private Integer stagingMemory;
    private Integer stagingDisk;
    private Integer stagingLogRateLimitBytesPerSecond;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v3.builds.Build} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Build instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code CreateBuildResponse} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(CreateBuildResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _CreateBuildResponse} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_CreateBuildResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v3.Resource} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Resource instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    private void from(short _unused, Object object) {
      long bits = 0;
      if (object instanceof Build) {
        Build instance = (Build) object;
        if ((bits & 0x1L) == 0) {
          Metadata metadataValue = instance.getMetadata();
          if (metadataValue != null) {
            metadata(metadataValue);
          }
          bits |= 0x1L;
        }
        if ((bits & 0x2L) == 0) {
          Integer stagingDiskValue = instance.getStagingDisk();
          if (stagingDiskValue != null) {
            stagingDisk(stagingDiskValue);
          }
          bits |= 0x2L;
        }
        if ((bits & 0x4L) == 0) {
          Droplet dropletValue = instance.getDroplet();
          if (dropletValue != null) {
            droplet(dropletValue);
          }
          bits |= 0x4L;
        }
        if ((bits & 0x8L) == 0) {
          String errorValue = instance.getError();
          if (errorValue != null) {
            error(errorValue);
          }
          bits |= 0x8L;
        }
        if ((bits & 0x10L) == 0) {
          this.lifecycle(instance.getLifecycle());
          bits |= 0x10L;
        }
        if ((bits & 0x20L) == 0) {
          this.createdAt(instance.getCreatedAt());
          bits |= 0x20L;
        }
        if ((bits & 0x40L) == 0) {
          BuildRelationships relationshipsValue = instance.getRelationships();
          if (relationshipsValue != null) {
            relationships(relationshipsValue);
          }
          bits |= 0x40L;
        }
        if ((bits & 0x80L) == 0) {
          this.inputPackage(instance.getInputPackage());
          bits |= 0x80L;
        }
        if ((bits & 0x100L) == 0) {
          this.createdBy(instance.getCreatedBy());
          bits |= 0x100L;
        }
        if ((bits & 0x200L) == 0) {
          Integer stagingMemoryValue = instance.getStagingMemory();
          if (stagingMemoryValue != null) {
            stagingMemory(stagingMemoryValue);
          }
          bits |= 0x200L;
        }
        if ((bits & 0x400L) == 0) {
          putAllLinks(instance.getLinks());
          bits |= 0x400L;
        }
        if ((bits & 0x800L) == 0) {
          this.id(instance.getId());
          bits |= 0x800L;
        }
        if ((bits & 0x1000L) == 0) {
          this.state(instance.getState());
          bits |= 0x1000L;
        }
        if ((bits & 0x2000L) == 0) {
          Integer stagingLogRateLimitBytesPerSecondValue = instance.getStagingLogRateLimitBytesPerSecond();
          if (stagingLogRateLimitBytesPerSecondValue != null) {
            stagingLogRateLimitBytesPerSecond(stagingLogRateLimitBytesPerSecondValue);
          }
          bits |= 0x2000L;
        }
        if ((bits & 0x4000L) == 0) {
          String updatedAtValue = instance.getUpdatedAt();
          if (updatedAtValue != null) {
            updatedAt(updatedAtValue);
          }
          bits |= 0x4000L;
        }
      }
      if (object instanceof org.cloudfoundry.client.v3.builds._CreateBuildResponse) {
        org.cloudfoundry.client.v3.builds._CreateBuildResponse instance = (org.cloudfoundry.client.v3.builds._CreateBuildResponse) object;
        if ((bits & 0x10L) == 0) {
          this.lifecycle(instance.getLifecycle());
          bits |= 0x10L;
        }
        if ((bits & 0x40L) == 0) {
          BuildRelationships relationshipsValue = instance.getRelationships();
          if (relationshipsValue != null) {
            relationships(relationshipsValue);
          }
          bits |= 0x40L;
        }
        if ((bits & 0x1L) == 0) {
          Metadata metadataValue = instance.getMetadata();
          if (metadataValue != null) {
            metadata(metadataValue);
          }
          bits |= 0x1L;
        }
        if ((bits & 0x2L) == 0) {
          Integer stagingDiskValue = instance.getStagingDisk();
          if (stagingDiskValue != null) {
            stagingDisk(stagingDiskValue);
          }
          bits |= 0x2L;
        }
        if ((bits & 0x80L) == 0) {
          this.inputPackage(instance.getInputPackage());
          bits |= 0x80L;
        }
        if ((bits & 0x4L) == 0) {
          Droplet dropletValue = instance.getDroplet();
          if (dropletValue != null) {
            droplet(dropletValue);
          }
          bits |= 0x4L;
        }
        if ((bits & 0x100L) == 0) {
          this.createdBy(instance.getCreatedBy());
          bits |= 0x100L;
        }
        if ((bits & 0x200L) == 0) {
          Integer stagingMemoryValue = instance.getStagingMemory();
          if (stagingMemoryValue != null) {
            stagingMemory(stagingMemoryValue);
          }
          bits |= 0x200L;
        }
        if ((bits & 0x1000L) == 0) {
          this.state(instance.getState());
          bits |= 0x1000L;
        }
        if ((bits & 0x8L) == 0) {
          String errorValue = instance.getError();
          if (errorValue != null) {
            error(errorValue);
          }
          bits |= 0x8L;
        }
        if ((bits & 0x2000L) == 0) {
          Integer stagingLogRateLimitBytesPerSecondValue = instance.getStagingLogRateLimitBytesPerSecond();
          if (stagingLogRateLimitBytesPerSecondValue != null) {
            stagingLogRateLimitBytesPerSecond(stagingLogRateLimitBytesPerSecondValue);
          }
          bits |= 0x2000L;
        }
      }
      if (object instanceof Resource) {
        Resource instance = (Resource) object;
        if ((bits & 0x20L) == 0) {
          this.createdAt(instance.getCreatedAt());
          bits |= 0x20L;
        }
        if ((bits & 0x400L) == 0) {
          putAllLinks(instance.getLinks());
          bits |= 0x400L;
        }
        if ((bits & 0x800L) == 0) {
          this.id(instance.getId());
          bits |= 0x800L;
        }
        if ((bits & 0x4000L) == 0) {
          String updatedAtValue = instance.getUpdatedAt();
          if (updatedAtValue != null) {
            updatedAt(updatedAtValue);
          }
          bits |= 0x4000L;
        }
      }
    }

    /**
     * Initializes the value for the {@link CreateBuildResponse#getCreatedAt() createdAt} attribute.
     * @param createdAt The value for createdAt 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("created_at")
    public final Builder createdAt(String createdAt) {
      this.createdAt = Objects.requireNonNull(createdAt, "createdAt");
      initBits &= ~INIT_BIT_CREATED_AT;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateBuildResponse#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("guid")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Put one entry to the {@link CreateBuildResponse#getLinks() links} map.
     * @param key The key in the links map
     * @param value The associated value in the links map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder link(String key, Link value) {
      this.links.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link CreateBuildResponse#getLinks() links} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder link(Map.Entry<String, ? extends Link> entry) {
      String k = entry.getKey();
      Link v = entry.getValue();
      this.links.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link CreateBuildResponse#getLinks() links} map. Nulls are not permitted
     * @param entries The entries that will be added to the links map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("links")
    public final Builder links(Map<String, ? extends Link> entries) {
      this.links.clear();
      return putAllLinks(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link CreateBuildResponse#getLinks() links} map. Nulls are not permitted
     * @param entries The entries that will be added to the links map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllLinks(Map<String, ? extends Link> entries) {
      for (Map.Entry<String, ? extends Link> e : entries.entrySet()) {
        String k = e.getKey();
        Link v = e.getValue();
        this.links.put(k, v);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link CreateBuildResponse#getUpdatedAt() updatedAt} attribute.
     * @param updatedAt The value for updatedAt (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("updated_at")
    public final Builder updatedAt(@Nullable String updatedAt) {
      this.updatedAt = updatedAt;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateBuildResponse#getCreatedBy() createdBy} attribute.
     * @param createdBy The value for createdBy 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("created_by")
    public final Builder createdBy(CreatedBy createdBy) {
      this.createdBy = Objects.requireNonNull(createdBy, "createdBy");
      initBits &= ~INIT_BIT_CREATED_BY;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateBuildResponse#getDroplet() droplet} attribute.
     * @param droplet The value for droplet (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("droplet")
    public final Builder droplet(@Nullable Droplet droplet) {
      this.droplet = droplet;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateBuildResponse#getError() error} attribute.
     * @param error The value for error (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("error")
    public final Builder error(@Nullable String error) {
      this.error = error;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateBuildResponse#getInputPackage() inputPackage} attribute.
     * @param inputPackage The value for inputPackage 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("package")
    public final Builder inputPackage(Relationship inputPackage) {
      this.inputPackage = Objects.requireNonNull(inputPackage, "inputPackage");
      initBits &= ~INIT_BIT_INPUT_PACKAGE;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateBuildResponse#getLifecycle() lifecycle} attribute.
     * @param lifecycle The value for lifecycle 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("lifecycle")
    public final Builder lifecycle(Lifecycle lifecycle) {
      this.lifecycle = Objects.requireNonNull(lifecycle, "lifecycle");
      initBits &= ~INIT_BIT_LIFECYCLE;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateBuildResponse#getMetadata() metadata} attribute.
     * @param metadata The value for metadata (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("metadata")
    public final Builder metadata(@Nullable Metadata metadata) {
      this.metadata = metadata;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateBuildResponse#getRelationships() relationships} attribute.
     * @param relationships The value for relationships (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("relationships")
    public final Builder relationships(@Nullable BuildRelationships relationships) {
      this.relationships = relationships;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateBuildResponse#getState() state} attribute.
     * @param state The value for state 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("state")
    public final Builder state(BuildState state) {
      this.state = Objects.requireNonNull(state, "state");
      initBits &= ~INIT_BIT_STATE;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateBuildResponse#getStagingMemory() stagingMemory} attribute.
     * @param stagingMemory The value for stagingMemory (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("staging_memory_in_mb")
    public final Builder stagingMemory(@Nullable Integer stagingMemory) {
      this.stagingMemory = stagingMemory;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateBuildResponse#getStagingDisk() stagingDisk} attribute.
     * @param stagingDisk The value for stagingDisk (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("staging_disk_in_mb")
    public final Builder stagingDisk(@Nullable Integer stagingDisk) {
      this.stagingDisk = stagingDisk;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateBuildResponse#getStagingLogRateLimitBytesPerSecond() stagingLogRateLimitBytesPerSecond} attribute.
     * @param stagingLogRateLimitBytesPerSecond The value for stagingLogRateLimitBytesPerSecond (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("staging_log_rate_limit_bytes_per_second")
    public final Builder stagingLogRateLimitBytesPerSecond(@Nullable Integer stagingLogRateLimitBytesPerSecond) {
      this.stagingLogRateLimitBytesPerSecond = stagingLogRateLimitBytesPerSecond;
      return this;
    }

    /**
     * Builds a new {@link CreateBuildResponse CreateBuildResponse}.
     * @return An immutable instance of CreateBuildResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public CreateBuildResponse build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new CreateBuildResponse(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_CREATED_AT) != 0) attributes.add("createdAt");
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_CREATED_BY) != 0) attributes.add("createdBy");
      if ((initBits & INIT_BIT_INPUT_PACKAGE) != 0) attributes.add("inputPackage");
      if ((initBits & INIT_BIT_LIFECYCLE) != 0) attributes.add("lifecycle");
      if ((initBits & INIT_BIT_STATE) != 0) attributes.add("state");
      return "Cannot build CreateBuildResponse, some of required attributes are not set " + attributes;
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size() * 4 / 3 + 1);
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
