package org.cloudfoundry.client.v3.deployments;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * The request payload for the Get Deployment operation
 */
@Generated(from = "_GetDeploymentRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class GetDeploymentRequest extends org.cloudfoundry.client.v3.deployments._GetDeploymentRequest {
  private final String deploymentId;

  private GetDeploymentRequest(GetDeploymentRequest.Builder builder) {
    this.deploymentId = builder.deploymentId;
  }

  /**
   * The deployment id
   */
  @Override
  public String getDeploymentId() {
    return deploymentId;
  }

  /**
   * This instance is equal to all instances of {@code GetDeploymentRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GetDeploymentRequest
        && equalTo(0, (GetDeploymentRequest) another);
  }

  private boolean equalTo(int synthetic, GetDeploymentRequest another) {
    return deploymentId.equals(another.deploymentId);
  }

  /**
   * Computes a hash code from attributes: {@code deploymentId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + deploymentId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code GetDeploymentRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GetDeploymentRequest{"
        + "deploymentId=" + deploymentId
        + "}";
  }

  /**
   * Creates a builder for {@link GetDeploymentRequest GetDeploymentRequest}.
   * <pre>
   * GetDeploymentRequest.builder()
   *    .deploymentId(String) // required {@link GetDeploymentRequest#getDeploymentId() deploymentId}
   *    .build();
   * </pre>
   * @return A new GetDeploymentRequest builder
   */
  public static GetDeploymentRequest.Builder builder() {
    return new GetDeploymentRequest.Builder();
  }

  /**
   * Builds instances of type {@link GetDeploymentRequest GetDeploymentRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_GetDeploymentRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_DEPLOYMENT_ID = 0x1L;
    private long initBits = 0x1L;

    private String deploymentId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GetDeploymentRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GetDeploymentRequest instance) {
      return from((_GetDeploymentRequest) instance);
    }

    /**
     * Copy abstract value type {@code _GetDeploymentRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_GetDeploymentRequest instance) {
      Objects.requireNonNull(instance, "instance");
      this.deploymentId(instance.getDeploymentId());
      return this;
    }

    /**
     * Initializes the value for the {@link GetDeploymentRequest#getDeploymentId() deploymentId} attribute.
     * @param deploymentId The value for deploymentId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder deploymentId(String deploymentId) {
      this.deploymentId = Objects.requireNonNull(deploymentId, "deploymentId");
      initBits &= ~INIT_BIT_DEPLOYMENT_ID;
      return this;
    }

    /**
     * Builds a new {@link GetDeploymentRequest GetDeploymentRequest}.
     * @return An immutable instance of GetDeploymentRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GetDeploymentRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new GetDeploymentRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_DEPLOYMENT_ID) != 0) attributes.add("deploymentId");
      return "Cannot build GetDeploymentRequest, some of required attributes are not set " + attributes;
    }
  }
}
