package org.cloudfoundry.client.v3.deployments;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link _Options}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code Options.builder()}.
 */
@Generated(from = "_Options", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class Options extends org.cloudfoundry.client.v3.deployments._Options {
  private final Integer maxInFlight;

  private Options(Options.Builder builder) {
    this.maxInFlight = builder.maxInFlight;
  }

  /**
   * The The maximum number of new instances to deploy simultaneously
   */
  @JsonProperty("max_in_flight")
  @Override
  public Integer getMaxInFlight() {
    return maxInFlight;
  }

  /**
   * This instance is equal to all instances of {@code Options} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof Options
        && equalTo(0, (Options) another);
  }

  private boolean equalTo(int synthetic, Options another) {
    return maxInFlight.equals(another.maxInFlight);
  }

  /**
   * Computes a hash code from attributes: {@code maxInFlight}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + maxInFlight.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Options} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Options{"
        + "maxInFlight=" + maxInFlight
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_Options", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.deployments._Options {
    Integer maxInFlight;
    @JsonProperty("max_in_flight")
    public void setMaxInFlight(Integer maxInFlight) {
      this.maxInFlight = maxInFlight;
    }
    @Override
    public Integer getMaxInFlight() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static Options fromJson(Json json) {
    Options.Builder builder = Options.builder();
    if (json.maxInFlight != null) {
      builder.maxInFlight(json.maxInFlight);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link Options Options}.
   * <pre>
   * Options.builder()
   *    .maxInFlight(Integer) // required {@link Options#getMaxInFlight() maxInFlight}
   *    .build();
   * </pre>
   * @return A new Options builder
   */
  public static Options.Builder builder() {
    return new Options.Builder();
  }

  /**
   * Builds instances of type {@link Options Options}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_Options", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_MAX_IN_FLIGHT = 0x1L;
    private long initBits = 0x1L;

    private Integer maxInFlight;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Options} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Options instance) {
      return from((_Options) instance);
    }

    /**
     * Copy abstract value type {@code _Options} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_Options instance) {
      Objects.requireNonNull(instance, "instance");
      this.maxInFlight(instance.getMaxInFlight());
      return this;
    }

    /**
     * Initializes the value for the {@link Options#getMaxInFlight() maxInFlight} attribute.
     * @param maxInFlight The value for maxInFlight 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("max_in_flight")
    public final Builder maxInFlight(Integer maxInFlight) {
      this.maxInFlight = Objects.requireNonNull(maxInFlight, "maxInFlight");
      initBits &= ~INIT_BIT_MAX_IN_FLIGHT;
      return this;
    }

    /**
     * Builds a new {@link Options Options}.
     * @return An immutable instance of Options
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public Options build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new Options(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_MAX_IN_FLIGHT) != 0) attributes.add("maxInFlight");
      return "Cannot build Options, some of required attributes are not set " + attributes;
    }
  }
}
