package org.cloudfoundry.client.v3.deployments;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link _Revision}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code Revision.builder()}.
 */
@Generated(from = "_Revision", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class Revision extends org.cloudfoundry.client.v3.deployments._Revision {
  private final String id;
  private final Integer version;

  private Revision(Revision.Builder builder) {
    this.id = builder.id;
    this.version = builder.version;
  }

  /**
   * The revision's id
   */
  @JsonProperty("guid")
  @Override
  public String getId() {
    return id;
  }

  /**
   * The revision's version
   */
  @JsonProperty("version")
  @Override
  public Integer getVersion() {
    return version;
  }

  /**
   * This instance is equal to all instances of {@code Revision} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof Revision
        && equalTo(0, (Revision) another);
  }

  private boolean equalTo(int synthetic, Revision another) {
    return id.equals(another.id)
        && version.equals(another.version);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code version}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + version.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Revision} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Revision{"
        + "id=" + id
        + ", version=" + version
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_Revision", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.deployments._Revision {
    String id;
    Integer version;
    @JsonProperty("guid")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("version")
    public void setVersion(Integer version) {
      this.version = version;
    }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getVersion() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static Revision fromJson(Json json) {
    Revision.Builder builder = Revision.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.version != null) {
      builder.version(json.version);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link Revision Revision}.
   * <pre>
   * Revision.builder()
   *    .id(String) // required {@link Revision#getId() id}
   *    .version(Integer) // required {@link Revision#getVersion() version}
   *    .build();
   * </pre>
   * @return A new Revision builder
   */
  public static Revision.Builder builder() {
    return new Revision.Builder();
  }

  /**
   * Builds instances of type {@link Revision Revision}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_Revision", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_VERSION = 0x2L;
    private long initBits = 0x3L;

    private String id;
    private Integer version;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Revision} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Revision instance) {
      return from((_Revision) instance);
    }

    /**
     * Copy abstract value type {@code _Revision} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_Revision instance) {
      Objects.requireNonNull(instance, "instance");
      this.id(instance.getId());
      this.version(instance.getVersion());
      return this;
    }

    /**
     * Initializes the value for the {@link Revision#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("guid")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link Revision#getVersion() version} attribute.
     * @param version The value for version 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("version")
    public final Builder version(Integer version) {
      this.version = Objects.requireNonNull(version, "version");
      initBits &= ~INIT_BIT_VERSION;
      return this;
    }

    /**
     * Builds a new {@link Revision Revision}.
     * @return An immutable instance of Revision
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public Revision build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new Revision(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_VERSION) != 0) attributes.add("version");
      return "Cannot build Revision, some of required attributes are not set " + attributes;
    }
  }
}
