package org.cloudfoundry.client.v3.domains;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.*;
import org.cloudfoundry.client.v3.Metadata;
import org.cloudfoundry.client.v3.Resource;
import org.cloudfoundry.client.v3.routes.Protocol;
import org.immutables.value.Generated;

/**
 * The response payload for the Create a Domain operation
 */
@Generated(from = "_CreateDomainResponse", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class CreateDomainResponse extends org.cloudfoundry.client.v3.domains._CreateDomainResponse {
  private final String createdAt;
  private final String id;
  private final Map<String, Link> links;
  private final @Nullable String updatedAt;
  private final @Nullable Metadata metadata;
  private final String name;
  private final DomainRelationships relationships;
  private final @Nullable RouterGroup routerGroup;
  private final @Nullable List<Protocol> supportedProtocols;
  private final boolean isInternal;

  private CreateDomainResponse(CreateDomainResponse.Builder builder) {
    this.createdAt = builder.createdAt;
    this.id = builder.id;
    this.links = createUnmodifiableMap(false, false, builder.links);
    this.updatedAt = builder.updatedAt;
    this.metadata = builder.metadata;
    this.name = builder.name;
    this.relationships = builder.relationships;
    this.routerGroup = builder.routerGroup;
    this.supportedProtocols = builder.supportedProtocols == null ? null : createUnmodifiableList(true, builder.supportedProtocols);
    this.isInternal = builder.isInternal;
  }

  /**
   * When the resource was created
   */
  @JsonProperty("created_at")
  @Override
  public String getCreatedAt() {
    return createdAt;
  }

  /**
   * The resource's id
   */
  @JsonProperty("guid")
  @Override
  public String getId() {
    return id;
  }

  /**
   * Links to related resources and actions for the resource
   */
  @JsonProperty("links")
  @Override
  public Map<String, Link> getLinks() {
    return links;
  }

  /**
   * When the resource was last updated
   */
  @JsonProperty("updated_at")
  @Override
  public @Nullable String getUpdatedAt() {
    return updatedAt;
  }

  /**
   * Metadata applied to the domain.
   */
  @JsonProperty("metadata")
  @Override
  public @Nullable Metadata getMetadata() {
    return metadata;
  }

  /**
   * The name of the domain.
   * Must be between 3 ~ 253 characters and follow <a href="https://tools.ietf.org/html/rfc1035">RFC 1035</a>.
   */
  @JsonProperty("name")
  @Override
  public String getName() {
    return name;
  }

  /**
   * Relationships of the domain.
   */
  @JsonProperty("relationships")
  @Override
  public DomainRelationships getRelationships() {
    return relationships;
  }

  /**
   * Router group information
   */
  @JsonProperty("router_group")
  @Override
  public @Nullable RouterGroup getRouterGroup() {
    return routerGroup;
  }

  /**
   * Available protocols for routes using the domain
   */
  @JsonProperty("supported_protocols")
  @Override
  public @Nullable List<Protocol> getSupportedProtocols() {
    return supportedProtocols;
  }

  /**
   * Whether the domain is used for internal (container-to-container) traffic.
   */
  @JsonProperty("internal")
  @Override
  public boolean isInternal() {
    return isInternal;
  }

  /**
   * This instance is equal to all instances of {@code CreateDomainResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof CreateDomainResponse
        && equalTo(0, (CreateDomainResponse) another);
  }

  private boolean equalTo(int synthetic, CreateDomainResponse another) {
    return createdAt.equals(another.createdAt)
        && id.equals(another.id)
        && links.equals(another.links)
        && Objects.equals(updatedAt, another.updatedAt)
        && Objects.equals(metadata, another.metadata)
        && name.equals(another.name)
        && relationships.equals(another.relationships)
        && Objects.equals(routerGroup, another.routerGroup)
        && Objects.equals(supportedProtocols, another.supportedProtocols)
        && isInternal == another.isInternal;
  }

  /**
   * Computes a hash code from attributes: {@code createdAt}, {@code id}, {@code links}, {@code updatedAt}, {@code metadata}, {@code name}, {@code relationships}, {@code routerGroup}, {@code supportedProtocols}, {@code isInternal}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + createdAt.hashCode();
    h += (h << 5) + id.hashCode();
    h += (h << 5) + links.hashCode();
    h += (h << 5) + Objects.hashCode(updatedAt);
    h += (h << 5) + Objects.hashCode(metadata);
    h += (h << 5) + name.hashCode();
    h += (h << 5) + relationships.hashCode();
    h += (h << 5) + Objects.hashCode(routerGroup);
    h += (h << 5) + Objects.hashCode(supportedProtocols);
    h += (h << 5) + Boolean.hashCode(isInternal);
    return h;
  }

  /**
   * Prints the immutable value {@code CreateDomainResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "CreateDomainResponse{"
        + "createdAt=" + createdAt
        + ", id=" + id
        + ", links=" + links
        + ", updatedAt=" + updatedAt
        + ", metadata=" + metadata
        + ", name=" + name
        + ", relationships=" + relationships
        + ", routerGroup=" + routerGroup
        + ", supportedProtocols=" + supportedProtocols
        + ", isInternal=" + isInternal
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_CreateDomainResponse", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.domains._CreateDomainResponse {
    String createdAt;
    String id;
    Map<String, Link> links = Collections.emptyMap();
    String updatedAt;
    Metadata metadata;
    String name;
    DomainRelationships relationships;
    RouterGroup routerGroup;
    List<Protocol> supportedProtocols = null;
    boolean isInternal;
    boolean isInternalIsSet;
    @JsonProperty("created_at")
    public void setCreatedAt(String createdAt) {
      this.createdAt = createdAt;
    }
    @JsonProperty("guid")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("links")
    public void setLinks(Map<String, Link> links) {
      this.links = links;
    }
    @JsonProperty("updated_at")
    public void setUpdatedAt(@Nullable String updatedAt) {
      this.updatedAt = updatedAt;
    }
    @JsonProperty("metadata")
    public void setMetadata(@Nullable Metadata metadata) {
      this.metadata = metadata;
    }
    @JsonProperty("name")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty("relationships")
    public void setRelationships(DomainRelationships relationships) {
      this.relationships = relationships;
    }
    @JsonProperty("router_group")
    public void setRouterGroup(@Nullable RouterGroup routerGroup) {
      this.routerGroup = routerGroup;
    }
    @JsonProperty("supported_protocols")
    public void setSupportedProtocols(@Nullable List<Protocol> supportedProtocols) {
      this.supportedProtocols = supportedProtocols;
    }
    @JsonProperty("internal")
    public void setIsInternal(boolean isInternal) {
      this.isInternal = isInternal;
      this.isInternalIsSet = true;
    }
    @Override
    public String getCreatedAt() { throw new UnsupportedOperationException(); }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, Link> getLinks() { throw new UnsupportedOperationException(); }
    @Override
    public String getUpdatedAt() { throw new UnsupportedOperationException(); }
    @Override
    public Metadata getMetadata() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public DomainRelationships getRelationships() { throw new UnsupportedOperationException(); }
    @Override
    public RouterGroup getRouterGroup() { throw new UnsupportedOperationException(); }
    @Override
    public List<Protocol> getSupportedProtocols() { throw new UnsupportedOperationException(); }
    @Override
    public boolean isInternal() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static CreateDomainResponse fromJson(Json json) {
    CreateDomainResponse.Builder builder = CreateDomainResponse.builder();
    if (json.createdAt != null) {
      builder.createdAt(json.createdAt);
    }
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.links != null) {
      builder.putAllLinks(json.links);
    }
    if (json.updatedAt != null) {
      builder.updatedAt(json.updatedAt);
    }
    if (json.metadata != null) {
      builder.metadata(json.metadata);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.relationships != null) {
      builder.relationships(json.relationships);
    }
    if (json.routerGroup != null) {
      builder.routerGroup(json.routerGroup);
    }
    if (json.supportedProtocols != null) {
      builder.addAllSupportedProtocols(json.supportedProtocols);
    }
    if (json.isInternalIsSet) {
      builder.isInternal(json.isInternal);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link CreateDomainResponse CreateDomainResponse}.
   * <pre>
   * CreateDomainResponse.builder()
   *    .createdAt(String) // required {@link CreateDomainResponse#getCreatedAt() createdAt}
   *    .id(String) // required {@link CreateDomainResponse#getId() id}
   *    .link|putAllLinks(String =&gt; Link) // {@link CreateDomainResponse#getLinks() links} mappings
   *    .updatedAt(String | null) // nullable {@link CreateDomainResponse#getUpdatedAt() updatedAt}
   *    .metadata(org.cloudfoundry.client.v3.Metadata | null) // nullable {@link CreateDomainResponse#getMetadata() metadata}
   *    .name(String) // required {@link CreateDomainResponse#getName() name}
   *    .relationships(org.cloudfoundry.client.v3.domains.DomainRelationships) // required {@link CreateDomainResponse#getRelationships() relationships}
   *    .routerGroup(org.cloudfoundry.client.v3.domains.RouterGroup | null) // nullable {@link CreateDomainResponse#getRouterGroup() routerGroup}
   *    .supportedProtocols(List&amp;lt;org.cloudfoundry.client.v3.routes.Protocol&amp;gt; | null) // nullable {@link CreateDomainResponse#getSupportedProtocols() supportedProtocols}
   *    .isInternal(boolean) // required {@link CreateDomainResponse#isInternal() isInternal}
   *    .build();
   * </pre>
   * @return A new CreateDomainResponse builder
   */
  public static CreateDomainResponse.Builder builder() {
    return new CreateDomainResponse.Builder();
  }

  /**
   * Builds instances of type {@link CreateDomainResponse CreateDomainResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_CreateDomainResponse", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_CREATED_AT = 0x1L;
    private static final long INIT_BIT_ID = 0x2L;
    private static final long INIT_BIT_NAME = 0x4L;
    private static final long INIT_BIT_RELATIONSHIPS = 0x8L;
    private static final long INIT_BIT_IS_INTERNAL = 0x10L;
    private long initBits = 0x1fL;

    private String createdAt;
    private String id;
    private Map<String, Link> links = new LinkedHashMap<String, Link>();
    private String updatedAt;
    private Metadata metadata;
    private String name;
    private DomainRelationships relationships;
    private RouterGroup routerGroup;
    private List<Protocol> supportedProtocols = null;
    private boolean isInternal;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v3.domains.Domain} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Domain instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code CreateDomainResponse} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(CreateDomainResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _CreateDomainResponse} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_CreateDomainResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v3.Resource} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Resource instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    private void from(short _unused, Object object) {
      long bits = 0;
      if (object instanceof Domain) {
        Domain instance = (Domain) object;
        if ((bits & 0x8L) == 0) {
          this.isInternal(instance.isInternal());
          bits |= 0x8L;
        }
        if ((bits & 0x10L) == 0) {
          this.createdAt(instance.getCreatedAt());
          bits |= 0x10L;
        }
        if ((bits & 0x20L) == 0) {
          this.relationships(instance.getRelationships());
          bits |= 0x20L;
        }
        if ((bits & 0x1L) == 0) {
          Metadata metadataValue = instance.getMetadata();
          if (metadataValue != null) {
            metadata(metadataValue);
          }
          bits |= 0x1L;
        }
        if ((bits & 0x40L) == 0) {
          this.name(instance.getName());
          bits |= 0x40L;
        }
        if ((bits & 0x80L) == 0) {
          putAllLinks(instance.getLinks());
          bits |= 0x80L;
        }
        if ((bits & 0x100L) == 0) {
          this.id(instance.getId());
          bits |= 0x100L;
        }
        if ((bits & 0x2L) == 0) {
          RouterGroup routerGroupValue = instance.getRouterGroup();
          if (routerGroupValue != null) {
            routerGroup(routerGroupValue);
          }
          bits |= 0x2L;
        }
        if ((bits & 0x4L) == 0) {
          List<Protocol> supportedProtocolsValue = instance.getSupportedProtocols();
          if (supportedProtocolsValue != null) {
            addAllSupportedProtocols(supportedProtocolsValue);
          }
          bits |= 0x4L;
        }
        if ((bits & 0x200L) == 0) {
          String updatedAtValue = instance.getUpdatedAt();
          if (updatedAtValue != null) {
            updatedAt(updatedAtValue);
          }
          bits |= 0x200L;
        }
      }
      if (object instanceof org.cloudfoundry.client.v3.domains._CreateDomainResponse) {
        org.cloudfoundry.client.v3.domains._CreateDomainResponse instance = (org.cloudfoundry.client.v3.domains._CreateDomainResponse) object;
        if ((bits & 0x8L) == 0) {
          this.isInternal(instance.isInternal());
          bits |= 0x8L;
        }
        if ((bits & 0x40L) == 0) {
          this.name(instance.getName());
          bits |= 0x40L;
        }
        if ((bits & 0x20L) == 0) {
          this.relationships(instance.getRelationships());
          bits |= 0x20L;
        }
        if ((bits & 0x1L) == 0) {
          Metadata metadataValue = instance.getMetadata();
          if (metadataValue != null) {
            metadata(metadataValue);
          }
          bits |= 0x1L;
        }
        if ((bits & 0x2L) == 0) {
          RouterGroup routerGroupValue = instance.getRouterGroup();
          if (routerGroupValue != null) {
            routerGroup(routerGroupValue);
          }
          bits |= 0x2L;
        }
        if ((bits & 0x4L) == 0) {
          List<Protocol> supportedProtocolsValue = instance.getSupportedProtocols();
          if (supportedProtocolsValue != null) {
            addAllSupportedProtocols(supportedProtocolsValue);
          }
          bits |= 0x4L;
        }
      }
      if (object instanceof Resource) {
        Resource instance = (Resource) object;
        if ((bits & 0x10L) == 0) {
          this.createdAt(instance.getCreatedAt());
          bits |= 0x10L;
        }
        if ((bits & 0x80L) == 0) {
          putAllLinks(instance.getLinks());
          bits |= 0x80L;
        }
        if ((bits & 0x100L) == 0) {
          this.id(instance.getId());
          bits |= 0x100L;
        }
        if ((bits & 0x200L) == 0) {
          String updatedAtValue = instance.getUpdatedAt();
          if (updatedAtValue != null) {
            updatedAt(updatedAtValue);
          }
          bits |= 0x200L;
        }
      }
    }

    /**
     * Initializes the value for the {@link CreateDomainResponse#getCreatedAt() createdAt} attribute.
     * @param createdAt The value for createdAt 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("created_at")
    public final Builder createdAt(String createdAt) {
      this.createdAt = Objects.requireNonNull(createdAt, "createdAt");
      initBits &= ~INIT_BIT_CREATED_AT;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateDomainResponse#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("guid")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Put one entry to the {@link CreateDomainResponse#getLinks() links} map.
     * @param key The key in the links map
     * @param value The associated value in the links map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder link(String key, Link value) {
      this.links.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link CreateDomainResponse#getLinks() links} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder link(Map.Entry<String, ? extends Link> entry) {
      String k = entry.getKey();
      Link v = entry.getValue();
      this.links.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link CreateDomainResponse#getLinks() links} map. Nulls are not permitted
     * @param entries The entries that will be added to the links map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("links")
    public final Builder links(Map<String, ? extends Link> entries) {
      this.links.clear();
      return putAllLinks(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link CreateDomainResponse#getLinks() links} map. Nulls are not permitted
     * @param entries The entries that will be added to the links map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllLinks(Map<String, ? extends Link> entries) {
      for (Map.Entry<String, ? extends Link> e : entries.entrySet()) {
        String k = e.getKey();
        Link v = e.getValue();
        this.links.put(k, v);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link CreateDomainResponse#getUpdatedAt() updatedAt} attribute.
     * @param updatedAt The value for updatedAt (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("updated_at")
    public final Builder updatedAt(@Nullable String updatedAt) {
      this.updatedAt = updatedAt;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateDomainResponse#getMetadata() metadata} attribute.
     * @param metadata The value for metadata (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("metadata")
    public final Builder metadata(@Nullable Metadata metadata) {
      this.metadata = metadata;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateDomainResponse#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateDomainResponse#getRelationships() relationships} attribute.
     * @param relationships The value for relationships 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("relationships")
    public final Builder relationships(DomainRelationships relationships) {
      this.relationships = Objects.requireNonNull(relationships, "relationships");
      initBits &= ~INIT_BIT_RELATIONSHIPS;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateDomainResponse#getRouterGroup() routerGroup} attribute.
     * @param routerGroup The value for routerGroup (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("router_group")
    public final Builder routerGroup(@Nullable RouterGroup routerGroup) {
      this.routerGroup = routerGroup;
      return this;
    }

    /**
     * Adds one element to {@link CreateDomainResponse#getSupportedProtocols() supportedProtocols} list.
     * @param element A supportedProtocols element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder supportedProtocol(Protocol element) {
      if (this.supportedProtocols == null) {
        this.supportedProtocols = new ArrayList<Protocol>();
      }
      this.supportedProtocols.add(Objects.requireNonNull(element, "supportedProtocols element"));
      return this;
    }

    /**
     * Adds elements to {@link CreateDomainResponse#getSupportedProtocols() supportedProtocols} list.
     * @param elements An array of supportedProtocols elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder supportedProtocols(Protocol... elements) {
      if (this.supportedProtocols == null) {
        this.supportedProtocols = new ArrayList<Protocol>();
      }
      for (Protocol element : elements) {
        this.supportedProtocols.add(Objects.requireNonNull(element, "supportedProtocols element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link CreateDomainResponse#getSupportedProtocols() supportedProtocols} list.
     * @param elements An iterable of supportedProtocols elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("supported_protocols")
    public final Builder supportedProtocols(@Nullable Iterable<? extends Protocol> elements) {
      if (elements == null) {
        this.supportedProtocols = null;
        return this;
      }
      this.supportedProtocols = new ArrayList<Protocol>();
      return addAllSupportedProtocols(elements);
    }

    /**
     * Adds elements to {@link CreateDomainResponse#getSupportedProtocols() supportedProtocols} list.
     * @param elements An iterable of supportedProtocols elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllSupportedProtocols(Iterable<? extends Protocol> elements) {
      Objects.requireNonNull(elements, "supportedProtocols element");
      if (this.supportedProtocols == null) {
        this.supportedProtocols = new ArrayList<Protocol>();
      }
      for (Protocol element : elements) {
        this.supportedProtocols.add(Objects.requireNonNull(element, "supportedProtocols element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link CreateDomainResponse#isInternal() isInternal} attribute.
     * @param isInternal The value for isInternal 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("internal")
    public final Builder isInternal(boolean isInternal) {
      this.isInternal = isInternal;
      initBits &= ~INIT_BIT_IS_INTERNAL;
      return this;
    }

    /**
     * Builds a new {@link CreateDomainResponse CreateDomainResponse}.
     * @return An immutable instance of CreateDomainResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public CreateDomainResponse build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new CreateDomainResponse(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_CREATED_AT) != 0) attributes.add("createdAt");
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_RELATIONSHIPS) != 0) attributes.add("relationships");
      if ((initBits & INIT_BIT_IS_INTERNAL) != 0) attributes.add("isInternal");
      return "Cannot build CreateDomainResponse, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size() * 4 / 3 + 1);
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
