package org.cloudfoundry.client.v3.domains;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link _RouterGroup}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code RouterGroup.builder()}.
 */
@Generated(from = "_RouterGroup", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class RouterGroup extends org.cloudfoundry.client.v3.domains._RouterGroup {
  private final List<String> id;

  private RouterGroup(RouterGroup.Builder builder) {
    this.id = createUnmodifiableList(true, builder.id);
  }

  /**
   * The id of the desired router group to route tcp traffic through
   */
  @JsonProperty("guid")
  @Override
  public List<String> getId() {
    return id;
  }

  /**
   * This instance is equal to all instances of {@code RouterGroup} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof RouterGroup
        && equalTo(0, (RouterGroup) another);
  }

  private boolean equalTo(int synthetic, RouterGroup another) {
    return id.equals(another.id);
  }

  /**
   * Computes a hash code from attributes: {@code id}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + id.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code RouterGroup} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "RouterGroup{"
        + "id=" + id
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_RouterGroup", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.domains._RouterGroup {
    List<String> id = Collections.emptyList();
    @JsonProperty("guid")
    public void setId(List<String> id) {
      this.id = id;
    }
    @Override
    public List<String> getId() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static RouterGroup fromJson(Json json) {
    RouterGroup.Builder builder = RouterGroup.builder();
    if (json.id != null) {
      builder.addAllId(json.id);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link RouterGroup RouterGroup}.
   * <pre>
   * RouterGroup.builder()
   *    .id|addAllId(String) // {@link _RouterGroup#getId() id} elements
   *    .build();
   * </pre>
   * @return A new RouterGroup builder
   */
  public static RouterGroup.Builder builder() {
    return new RouterGroup.Builder();
  }

  /**
   * Builds instances of type {@link RouterGroup RouterGroup}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_RouterGroup", generator = "Immutables")
  public static final class Builder {
    private List<String> id = new ArrayList<String>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code _RouterGroup} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_RouterGroup instance) {
      Objects.requireNonNull(instance, "instance");
      addAllId(instance.getId());
      return this;
    }

    /**
     * Adds one element to {@link _RouterGroup#getId() id} list.
     * @param element A id element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder id(String element) {
      this.id.add(Objects.requireNonNull(element, "id element"));
      return this;
    }

    /**
     * Adds elements to {@link _RouterGroup#getId() id} list.
     * @param elements An array of id elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder id(String... elements) {
      for (String element : elements) {
        this.id.add(Objects.requireNonNull(element, "id element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link _RouterGroup#getId() id} list.
     * @param elements An iterable of id elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("guid")
    public final Builder id(Iterable<String> elements) {
      this.id.clear();
      return addAllId(elements);
    }

    /**
     * Adds elements to {@link _RouterGroup#getId() id} list.
     * @param elements An iterable of id elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllId(Iterable<String> elements) {
      for (String element : elements) {
        this.id.add(Objects.requireNonNull(element, "id element"));
      }
      return this;
    }

    /**
     * Builds a new {@link RouterGroup RouterGroup}.
     * @return An immutable instance of RouterGroup
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public RouterGroup build() {
      return new RouterGroup(this);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
