package org.cloudfoundry.client.v3.domains;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.client.v3.Relationship;
import org.immutables.value.Generated;

/**
 * The request payload for the Share Domain operation.
 */
@Generated(from = "_ShareDomainRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ShareDomainRequest extends org.cloudfoundry.client.v3.domains._ShareDomainRequest {
  private final List<Relationship> data;
  private final String domainId;

  private ShareDomainRequest(ShareDomainRequest.Builder builder) {
    this.data = createUnmodifiableList(true, builder.data);
    this.domainId = builder.domainId;
  }

  /**
   * The organizations the domain is shared to
   */
  @JsonProperty("data")
  @Override
  public List<Relationship> getData() {
    return data;
  }

  /**
   * The domain id
   */
  @JsonProperty("domainId")
  @JsonIgnore
  @Override
  public String getDomainId() {
    return domainId;
  }

  /**
   * This instance is equal to all instances of {@code ShareDomainRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ShareDomainRequest
        && equalTo(0, (ShareDomainRequest) another);
  }

  private boolean equalTo(int synthetic, ShareDomainRequest another) {
    return data.equals(another.data)
        && domainId.equals(another.domainId);
  }

  /**
   * Computes a hash code from attributes: {@code data}, {@code domainId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + data.hashCode();
    h += (h << 5) + domainId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ShareDomainRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ShareDomainRequest{"
        + "data=" + data
        + ", domainId=" + domainId
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_ShareDomainRequest", generator = "Immutables")
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.domains._ShareDomainRequest {
    List<Relationship> data = Collections.emptyList();
    String domainId;
    @JsonProperty("data")
    public void setData(List<Relationship> data) {
      this.data = data;
    }
    @JsonProperty("domainId")
    @JsonIgnore
    public void setDomainId(String domainId) {
      this.domainId = domainId;
    }
    @Override
    public List<Relationship> getData() { throw new UnsupportedOperationException(); }
    @Override
    public String getDomainId() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ShareDomainRequest fromJson(Json json) {
    ShareDomainRequest.Builder builder = ShareDomainRequest.builder();
    if (json.data != null) {
      builder.addAllData(json.data);
    }
    if (json.domainId != null) {
      builder.domainId(json.domainId);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link ShareDomainRequest ShareDomainRequest}.
   * <pre>
   * ShareDomainRequest.builder()
   *    .data|addAllData(org.cloudfoundry.client.v3.Relationship) // {@link ShareDomainRequest#getData() data} elements
   *    .domainId(String) // required {@link ShareDomainRequest#getDomainId() domainId}
   *    .build();
   * </pre>
   * @return A new ShareDomainRequest builder
   */
  public static ShareDomainRequest.Builder builder() {
    return new ShareDomainRequest.Builder();
  }

  /**
   * Builds instances of type {@link ShareDomainRequest ShareDomainRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ShareDomainRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_DOMAIN_ID = 0x1L;
    private long initBits = 0x1L;

    private List<Relationship> data = new ArrayList<Relationship>();
    private String domainId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ShareDomainRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ShareDomainRequest instance) {
      return from((_ShareDomainRequest) instance);
    }

    /**
     * Copy abstract value type {@code _ShareDomainRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ShareDomainRequest instance) {
      Objects.requireNonNull(instance, "instance");
      addAllData(instance.getData());
      this.domainId(instance.getDomainId());
      return this;
    }

    /**
     * Adds one element to {@link ShareDomainRequest#getData() data} list.
     * @param element A data element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder data(Relationship element) {
      this.data.add(Objects.requireNonNull(element, "data element"));
      return this;
    }

    /**
     * Adds elements to {@link ShareDomainRequest#getData() data} list.
     * @param elements An array of data elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder data(Relationship... elements) {
      for (Relationship element : elements) {
        this.data.add(Objects.requireNonNull(element, "data element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ShareDomainRequest#getData() data} list.
     * @param elements An iterable of data elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder data(Iterable<? extends Relationship> elements) {
      this.data.clear();
      return addAllData(elements);
    }

    /**
     * Adds elements to {@link ShareDomainRequest#getData() data} list.
     * @param elements An iterable of data elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllData(Iterable<? extends Relationship> elements) {
      for (Relationship element : elements) {
        this.data.add(Objects.requireNonNull(element, "data element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ShareDomainRequest#getDomainId() domainId} attribute.
     * @param domainId The value for domainId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder domainId(String domainId) {
      this.domainId = Objects.requireNonNull(domainId, "domainId");
      initBits &= ~INIT_BIT_DOMAIN_ID;
      return this;
    }

    /**
     * Builds a new {@link ShareDomainRequest ShareDomainRequest}.
     * @return An immutable instance of ShareDomainRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ShareDomainRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ShareDomainRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_DOMAIN_ID) != 0) attributes.add("domainId");
      return "Cannot build ShareDomainRequest, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
