package org.cloudfoundry.client.v3.domains;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * The request payload for the Unshare Domain operation.
 */
@Generated(from = "_UnshareDomainRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class UnshareDomainRequest extends org.cloudfoundry.client.v3.domains._UnshareDomainRequest {
  private final String domainId;
  private final String organizationId;

  private UnshareDomainRequest(UnshareDomainRequest.Builder builder) {
    this.domainId = builder.domainId;
    this.organizationId = builder.organizationId;
  }

  /**
   * The domain id
   */
  @Override
  public String getDomainId() {
    return domainId;
  }

  /**
   * The organization id
   */
  @Override
  public String getOrganizationId() {
    return organizationId;
  }

  /**
   * This instance is equal to all instances of {@code UnshareDomainRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof UnshareDomainRequest
        && equalTo(0, (UnshareDomainRequest) another);
  }

  private boolean equalTo(int synthetic, UnshareDomainRequest another) {
    return domainId.equals(another.domainId)
        && organizationId.equals(another.organizationId);
  }

  /**
   * Computes a hash code from attributes: {@code domainId}, {@code organizationId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + domainId.hashCode();
    h += (h << 5) + organizationId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code UnshareDomainRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UnshareDomainRequest{"
        + "domainId=" + domainId
        + ", organizationId=" + organizationId
        + "}";
  }

  /**
   * Creates a builder for {@link UnshareDomainRequest UnshareDomainRequest}.
   * <pre>
   * UnshareDomainRequest.builder()
   *    .domainId(String) // required {@link UnshareDomainRequest#getDomainId() domainId}
   *    .organizationId(String) // required {@link UnshareDomainRequest#getOrganizationId() organizationId}
   *    .build();
   * </pre>
   * @return A new UnshareDomainRequest builder
   */
  public static UnshareDomainRequest.Builder builder() {
    return new UnshareDomainRequest.Builder();
  }

  /**
   * Builds instances of type {@link UnshareDomainRequest UnshareDomainRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_UnshareDomainRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_DOMAIN_ID = 0x1L;
    private static final long INIT_BIT_ORGANIZATION_ID = 0x2L;
    private long initBits = 0x3L;

    private String domainId;
    private String organizationId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code UnshareDomainRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UnshareDomainRequest instance) {
      return from((_UnshareDomainRequest) instance);
    }

    /**
     * Copy abstract value type {@code _UnshareDomainRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_UnshareDomainRequest instance) {
      Objects.requireNonNull(instance, "instance");
      this.domainId(instance.getDomainId());
      this.organizationId(instance.getOrganizationId());
      return this;
    }

    /**
     * Initializes the value for the {@link UnshareDomainRequest#getDomainId() domainId} attribute.
     * @param domainId The value for domainId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder domainId(String domainId) {
      this.domainId = Objects.requireNonNull(domainId, "domainId");
      initBits &= ~INIT_BIT_DOMAIN_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link UnshareDomainRequest#getOrganizationId() organizationId} attribute.
     * @param organizationId The value for organizationId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationId(String organizationId) {
      this.organizationId = Objects.requireNonNull(organizationId, "organizationId");
      initBits &= ~INIT_BIT_ORGANIZATION_ID;
      return this;
    }

    /**
     * Builds a new {@link UnshareDomainRequest UnshareDomainRequest}.
     * @return An immutable instance of UnshareDomainRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public UnshareDomainRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new UnshareDomainRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_DOMAIN_ID) != 0) attributes.add("domainId");
      if ((initBits & INIT_BIT_ORGANIZATION_ID) != 0) attributes.add("organizationId");
      return "Cannot build UnshareDomainRequest, some of required attributes are not set " + attributes;
    }
  }
}
