package org.cloudfoundry.client.v3.droplets;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.*;
import org.cloudfoundry.client.v3.Checksum;
import org.cloudfoundry.client.v3.Lifecycle;
import org.cloudfoundry.client.v3.Metadata;
import org.cloudfoundry.client.v3.Resource;
import org.immutables.value.Generated;

/**
 * The Resource response payload for the List droplets operation
 */
@Generated(from = "_DropletResource", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class DropletResource extends org.cloudfoundry.client.v3.droplets._DropletResource {
  private final String createdAt;
  private final String id;
  private final Map<String, Link> links;
  private final @Nullable String updatedAt;
  private final @Nullable List<Buildpack> buildpacks;
  private final @Nullable Checksum checksum;
  private final @Nullable String error;
  private final String executionMetadata;
  private final @Nullable String image;
  private final Lifecycle lifecycle;
  private final @Nullable Metadata metadata;
  private final @Nullable Map<String, String> processTypes;
  private final @Nullable DropletRelationships relationships;
  private final @Nullable String stack;
  private final DropletState state;

  private DropletResource(DropletResource.Builder builder) {
    this.createdAt = builder.createdAt;
    this.id = builder.id;
    this.links = createUnmodifiableMap(false, false, builder.links);
    this.updatedAt = builder.updatedAt;
    this.buildpacks = builder.buildpacks == null ? null : createUnmodifiableList(true, builder.buildpacks);
    this.checksum = builder.checksum;
    this.error = builder.error;
    this.executionMetadata = builder.executionMetadata;
    this.image = builder.image;
    this.lifecycle = builder.lifecycle;
    this.metadata = builder.metadata;
    this.processTypes = builder.processTypes == null ? null : createUnmodifiableMap(false, false, builder.processTypes);
    this.relationships = builder.relationships;
    this.stack = builder.stack;
    this.state = builder.state;
  }

  /**
   * When the resource was created
   */
  @JsonProperty("created_at")
  @Override
  public String getCreatedAt() {
    return createdAt;
  }

  /**
   * The resource's id
   */
  @JsonProperty("guid")
  @Override
  public String getId() {
    return id;
  }

  /**
   * Links to related resources and actions for the resource
   */
  @JsonProperty("links")
  @Override
  public Map<String, Link> getLinks() {
    return links;
  }

  /**
   * When the resource was last updated
   */
  @JsonProperty("updated_at")
  @Override
  public @Nullable String getUpdatedAt() {
    return updatedAt;
  }

  /**
   * The buildpacks
   */
  @JsonProperty("buildpacks")
  @Override
  public @Nullable List<Buildpack> getBuildpacks() {
    return buildpacks;
  }

  /**
   * The checksum
   */
  @JsonProperty("checksum")
  @Override
  public @Nullable Checksum getChecksum() {
    return checksum;
  }

  /**
   * The error
   */
  @JsonProperty("error")
  @Override
  public @Nullable String getError() {
    return error;
  }

  /**
   * Serialized JSON data resulting from staging for use when executing a droplet
   */
  @JsonProperty("execution_metadata")
  @Override
  public String getExecutionMetadata() {
    return executionMetadata;
  }

  /**
   * The docker image
   */
  @JsonProperty("image")
  @Override
  public @Nullable String getImage() {
    return image;
  }

  /**
   * The lifecycle
   */
  @JsonProperty("lifecycle")
  @Override
  public Lifecycle getLifecycle() {
    return lifecycle;
  }

  /**
   * The metadata
   */
  @JsonProperty("metadata")
  @Override
  public @Nullable Metadata getMetadata() {
    return metadata;
  }

  /**
   * The process types and associated start commands
   */
  @JsonProperty("process_types")
  @Override
  public @Nullable Map<String, String> getProcessTypes() {
    return processTypes;
  }

  /**
   * The relationships
   */
  @JsonProperty("relationships")
  @Override
  public @Nullable DropletRelationships getRelationships() {
    return relationships;
  }

  /**
   * The stack
   */
  @JsonProperty("stack")
  @Override
  public @Nullable String getStack() {
    return stack;
  }

  /**
   * The state
   */
  @JsonProperty("state")
  @Override
  public DropletState getState() {
    return state;
  }

  /**
   * This instance is equal to all instances of {@code DropletResource} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof DropletResource
        && equalTo(0, (DropletResource) another);
  }

  private boolean equalTo(int synthetic, DropletResource another) {
    return createdAt.equals(another.createdAt)
        && id.equals(another.id)
        && links.equals(another.links)
        && Objects.equals(updatedAt, another.updatedAt)
        && Objects.equals(buildpacks, another.buildpacks)
        && Objects.equals(checksum, another.checksum)
        && Objects.equals(error, another.error)
        && executionMetadata.equals(another.executionMetadata)
        && Objects.equals(image, another.image)
        && lifecycle.equals(another.lifecycle)
        && Objects.equals(metadata, another.metadata)
        && Objects.equals(processTypes, another.processTypes)
        && Objects.equals(relationships, another.relationships)
        && Objects.equals(stack, another.stack)
        && state.equals(another.state);
  }

  /**
   * Computes a hash code from attributes: {@code createdAt}, {@code id}, {@code links}, {@code updatedAt}, {@code buildpacks}, {@code checksum}, {@code error}, {@code executionMetadata}, {@code image}, {@code lifecycle}, {@code metadata}, {@code processTypes}, {@code relationships}, {@code stack}, {@code state}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + createdAt.hashCode();
    h += (h << 5) + id.hashCode();
    h += (h << 5) + links.hashCode();
    h += (h << 5) + Objects.hashCode(updatedAt);
    h += (h << 5) + Objects.hashCode(buildpacks);
    h += (h << 5) + Objects.hashCode(checksum);
    h += (h << 5) + Objects.hashCode(error);
    h += (h << 5) + executionMetadata.hashCode();
    h += (h << 5) + Objects.hashCode(image);
    h += (h << 5) + lifecycle.hashCode();
    h += (h << 5) + Objects.hashCode(metadata);
    h += (h << 5) + Objects.hashCode(processTypes);
    h += (h << 5) + Objects.hashCode(relationships);
    h += (h << 5) + Objects.hashCode(stack);
    h += (h << 5) + state.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code DropletResource} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DropletResource{"
        + "createdAt=" + createdAt
        + ", id=" + id
        + ", links=" + links
        + ", updatedAt=" + updatedAt
        + ", buildpacks=" + buildpacks
        + ", checksum=" + checksum
        + ", error=" + error
        + ", executionMetadata=" + executionMetadata
        + ", image=" + image
        + ", lifecycle=" + lifecycle
        + ", metadata=" + metadata
        + ", processTypes=" + processTypes
        + ", relationships=" + relationships
        + ", stack=" + stack
        + ", state=" + state
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_DropletResource", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.droplets._DropletResource {
    String createdAt;
    String id;
    Map<String, Link> links = Collections.emptyMap();
    String updatedAt;
    List<Buildpack> buildpacks = null;
    Checksum checksum;
    String error;
    String executionMetadata;
    String image;
    Lifecycle lifecycle;
    Metadata metadata;
    Map<String, String> processTypes = null;
    DropletRelationships relationships;
    String stack;
    DropletState state;
    @JsonProperty("created_at")
    public void setCreatedAt(String createdAt) {
      this.createdAt = createdAt;
    }
    @JsonProperty("guid")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("links")
    public void setLinks(Map<String, Link> links) {
      this.links = links;
    }
    @JsonProperty("updated_at")
    public void setUpdatedAt(@Nullable String updatedAt) {
      this.updatedAt = updatedAt;
    }
    @JsonProperty("buildpacks")
    public void setBuildpacks(@Nullable List<Buildpack> buildpacks) {
      this.buildpacks = buildpacks;
    }
    @JsonProperty("checksum")
    public void setChecksum(@Nullable Checksum checksum) {
      this.checksum = checksum;
    }
    @JsonProperty("error")
    public void setError(@Nullable String error) {
      this.error = error;
    }
    @JsonProperty("execution_metadata")
    public void setExecutionMetadata(String executionMetadata) {
      this.executionMetadata = executionMetadata;
    }
    @JsonProperty("image")
    public void setImage(@Nullable String image) {
      this.image = image;
    }
    @JsonProperty("lifecycle")
    public void setLifecycle(Lifecycle lifecycle) {
      this.lifecycle = lifecycle;
    }
    @JsonProperty("metadata")
    public void setMetadata(@Nullable Metadata metadata) {
      this.metadata = metadata;
    }
    @JsonProperty("process_types")
    public void setProcessTypes(@Nullable Map<String, String> processTypes) {
      this.processTypes = processTypes;
    }
    @JsonProperty("relationships")
    public void setRelationships(@Nullable DropletRelationships relationships) {
      this.relationships = relationships;
    }
    @JsonProperty("stack")
    public void setStack(@Nullable String stack) {
      this.stack = stack;
    }
    @JsonProperty("state")
    public void setState(DropletState state) {
      this.state = state;
    }
    @Override
    public String getCreatedAt() { throw new UnsupportedOperationException(); }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, Link> getLinks() { throw new UnsupportedOperationException(); }
    @Override
    public String getUpdatedAt() { throw new UnsupportedOperationException(); }
    @Override
    public List<Buildpack> getBuildpacks() { throw new UnsupportedOperationException(); }
    @Override
    public Checksum getChecksum() { throw new UnsupportedOperationException(); }
    @Override
    public String getError() { throw new UnsupportedOperationException(); }
    @Override
    public String getExecutionMetadata() { throw new UnsupportedOperationException(); }
    @Override
    public String getImage() { throw new UnsupportedOperationException(); }
    @Override
    public Lifecycle getLifecycle() { throw new UnsupportedOperationException(); }
    @Override
    public Metadata getMetadata() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, String> getProcessTypes() { throw new UnsupportedOperationException(); }
    @Override
    public DropletRelationships getRelationships() { throw new UnsupportedOperationException(); }
    @Override
    public String getStack() { throw new UnsupportedOperationException(); }
    @Override
    public DropletState getState() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static DropletResource fromJson(Json json) {
    DropletResource.Builder builder = DropletResource.builder();
    if (json.createdAt != null) {
      builder.createdAt(json.createdAt);
    }
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.links != null) {
      builder.putAllLinks(json.links);
    }
    if (json.updatedAt != null) {
      builder.updatedAt(json.updatedAt);
    }
    if (json.buildpacks != null) {
      builder.addAllBuildpacks(json.buildpacks);
    }
    if (json.checksum != null) {
      builder.checksum(json.checksum);
    }
    if (json.error != null) {
      builder.error(json.error);
    }
    if (json.executionMetadata != null) {
      builder.executionMetadata(json.executionMetadata);
    }
    if (json.image != null) {
      builder.image(json.image);
    }
    if (json.lifecycle != null) {
      builder.lifecycle(json.lifecycle);
    }
    if (json.metadata != null) {
      builder.metadata(json.metadata);
    }
    if (json.processTypes != null) {
      builder.putAllProcessTypes(json.processTypes);
    }
    if (json.relationships != null) {
      builder.relationships(json.relationships);
    }
    if (json.stack != null) {
      builder.stack(json.stack);
    }
    if (json.state != null) {
      builder.state(json.state);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link DropletResource DropletResource}.
   * <pre>
   * DropletResource.builder()
   *    .createdAt(String) // required {@link DropletResource#getCreatedAt() createdAt}
   *    .id(String) // required {@link DropletResource#getId() id}
   *    .link|putAllLinks(String =&gt; Link) // {@link DropletResource#getLinks() links} mappings
   *    .updatedAt(String | null) // nullable {@link DropletResource#getUpdatedAt() updatedAt}
   *    .buildpacks(List&amp;lt;Buildpack&amp;gt; | null) // nullable {@link DropletResource#getBuildpacks() buildpacks}
   *    .checksum(org.cloudfoundry.client.v3.Checksum | null) // nullable {@link DropletResource#getChecksum() checksum}
   *    .error(String | null) // nullable {@link DropletResource#getError() error}
   *    .executionMetadata(String) // required {@link DropletResource#getExecutionMetadata() executionMetadata}
   *    .image(String | null) // nullable {@link DropletResource#getImage() image}
   *    .lifecycle(org.cloudfoundry.client.v3.Lifecycle) // required {@link DropletResource#getLifecycle() lifecycle}
   *    .metadata(org.cloudfoundry.client.v3.Metadata | null) // nullable {@link DropletResource#getMetadata() metadata}
   *    .processTypes(Map&amp;lt;String, String&amp;gt; | null) // nullable {@link DropletResource#getProcessTypes() processTypes}
   *    .relationships(org.cloudfoundry.client.v3.droplets.DropletRelationships | null) // nullable {@link DropletResource#getRelationships() relationships}
   *    .stack(String | null) // nullable {@link DropletResource#getStack() stack}
   *    .state(org.cloudfoundry.client.v3.droplets.DropletState) // required {@link DropletResource#getState() state}
   *    .build();
   * </pre>
   * @return A new DropletResource builder
   */
  public static DropletResource.Builder builder() {
    return new DropletResource.Builder();
  }

  /**
   * Builds instances of type {@link DropletResource DropletResource}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_DropletResource", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_CREATED_AT = 0x1L;
    private static final long INIT_BIT_ID = 0x2L;
    private static final long INIT_BIT_EXECUTION_METADATA = 0x4L;
    private static final long INIT_BIT_LIFECYCLE = 0x8L;
    private static final long INIT_BIT_STATE = 0x10L;
    private long initBits = 0x1fL;

    private String createdAt;
    private String id;
    private Map<String, Link> links = new LinkedHashMap<String, Link>();
    private String updatedAt;
    private List<Buildpack> buildpacks = null;
    private Checksum checksum;
    private String error;
    private String executionMetadata;
    private String image;
    private Lifecycle lifecycle;
    private Metadata metadata;
    private Map<String, String> processTypes = null;
    private DropletRelationships relationships;
    private String stack;
    private DropletState state;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v3.droplets.Droplet} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Droplet instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v3.Resource} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Resource instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code DropletResource} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DropletResource instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _DropletResource} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_DropletResource instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    private void from(short _unused, Object object) {
      long bits = 0;
      if (object instanceof Droplet) {
        Droplet instance = (Droplet) object;
        if ((bits & 0x1L) == 0) {
          String imageValue = instance.getImage();
          if (imageValue != null) {
            image(imageValue);
          }
          bits |= 0x1L;
        }
        if ((bits & 0x2L) == 0) {
          Metadata metadataValue = instance.getMetadata();
          if (metadataValue != null) {
            metadata(metadataValue);
          }
          bits |= 0x2L;
        }
        if ((bits & 0x4L) == 0) {
          String stackValue = instance.getStack();
          if (stackValue != null) {
            stack(stackValue);
          }
          bits |= 0x4L;
        }
        if ((bits & 0x8L) == 0) {
          String errorValue = instance.getError();
          if (errorValue != null) {
            error(errorValue);
          }
          bits |= 0x8L;
        }
        if ((bits & 0x10L) == 0) {
          List<Buildpack> buildpacksValue = instance.getBuildpacks();
          if (buildpacksValue != null) {
            addAllBuildpacks(buildpacksValue);
          }
          bits |= 0x10L;
        }
        if ((bits & 0x20L) == 0) {
          this.lifecycle(instance.getLifecycle());
          bits |= 0x20L;
        }
        if ((bits & 0x40L) == 0) {
          this.createdAt(instance.getCreatedAt());
          bits |= 0x40L;
        }
        if ((bits & 0x80L) == 0) {
          DropletRelationships relationshipsValue = instance.getRelationships();
          if (relationshipsValue != null) {
            relationships(relationshipsValue);
          }
          bits |= 0x80L;
        }
        if ((bits & 0x100L) == 0) {
          this.executionMetadata(instance.getExecutionMetadata());
          bits |= 0x100L;
        }
        if ((bits & 0x200L) == 0) {
          Checksum checksumValue = instance.getChecksum();
          if (checksumValue != null) {
            checksum(checksumValue);
          }
          bits |= 0x200L;
        }
        if ((bits & 0x400L) == 0) {
          putAllLinks(instance.getLinks());
          bits |= 0x400L;
        }
        if ((bits & 0x800L) == 0) {
          this.id(instance.getId());
          bits |= 0x800L;
        }
        if ((bits & 0x1000L) == 0) {
          this.state(instance.getState());
          bits |= 0x1000L;
        }
        if ((bits & 0x2000L) == 0) {
          Map<String, String> processTypesValue = instance.getProcessTypes();
          if (processTypesValue != null) {
            putAllProcessTypes(processTypesValue);
          }
          bits |= 0x2000L;
        }
        if ((bits & 0x4000L) == 0) {
          String updatedAtValue = instance.getUpdatedAt();
          if (updatedAtValue != null) {
            updatedAt(updatedAtValue);
          }
          bits |= 0x4000L;
        }
      }
      if (object instanceof Resource) {
        Resource instance = (Resource) object;
        if ((bits & 0x40L) == 0) {
          this.createdAt(instance.getCreatedAt());
          bits |= 0x40L;
        }
        if ((bits & 0x400L) == 0) {
          putAllLinks(instance.getLinks());
          bits |= 0x400L;
        }
        if ((bits & 0x800L) == 0) {
          this.id(instance.getId());
          bits |= 0x800L;
        }
        if ((bits & 0x4000L) == 0) {
          String updatedAtValue = instance.getUpdatedAt();
          if (updatedAtValue != null) {
            updatedAt(updatedAtValue);
          }
          bits |= 0x4000L;
        }
      }
      if (object instanceof org.cloudfoundry.client.v3.droplets._DropletResource) {
        org.cloudfoundry.client.v3.droplets._DropletResource instance = (org.cloudfoundry.client.v3.droplets._DropletResource) object;
        if ((bits & 0x10L) == 0) {
          List<Buildpack> buildpacksValue = instance.getBuildpacks();
          if (buildpacksValue != null) {
            addAllBuildpacks(buildpacksValue);
          }
          bits |= 0x10L;
        }
        if ((bits & 0x20L) == 0) {
          this.lifecycle(instance.getLifecycle());
          bits |= 0x20L;
        }
        if ((bits & 0x1L) == 0) {
          String imageValue = instance.getImage();
          if (imageValue != null) {
            image(imageValue);
          }
          bits |= 0x1L;
        }
        if ((bits & 0x80L) == 0) {
          DropletRelationships relationshipsValue = instance.getRelationships();
          if (relationshipsValue != null) {
            relationships(relationshipsValue);
          }
          bits |= 0x80L;
        }
        if ((bits & 0x2L) == 0) {
          Metadata metadataValue = instance.getMetadata();
          if (metadataValue != null) {
            metadata(metadataValue);
          }
          bits |= 0x2L;
        }
        if ((bits & 0x4L) == 0) {
          String stackValue = instance.getStack();
          if (stackValue != null) {
            stack(stackValue);
          }
          bits |= 0x4L;
        }
        if ((bits & 0x100L) == 0) {
          this.executionMetadata(instance.getExecutionMetadata());
          bits |= 0x100L;
        }
        if ((bits & 0x200L) == 0) {
          Checksum checksumValue = instance.getChecksum();
          if (checksumValue != null) {
            checksum(checksumValue);
          }
          bits |= 0x200L;
        }
        if ((bits & 0x1000L) == 0) {
          this.state(instance.getState());
          bits |= 0x1000L;
        }
        if ((bits & 0x8L) == 0) {
          String errorValue = instance.getError();
          if (errorValue != null) {
            error(errorValue);
          }
          bits |= 0x8L;
        }
        if ((bits & 0x2000L) == 0) {
          Map<String, String> processTypesValue = instance.getProcessTypes();
          if (processTypesValue != null) {
            putAllProcessTypes(processTypesValue);
          }
          bits |= 0x2000L;
        }
      }
    }

    /**
     * Initializes the value for the {@link DropletResource#getCreatedAt() createdAt} attribute.
     * @param createdAt The value for createdAt 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("created_at")
    public final Builder createdAt(String createdAt) {
      this.createdAt = Objects.requireNonNull(createdAt, "createdAt");
      initBits &= ~INIT_BIT_CREATED_AT;
      return this;
    }

    /**
     * Initializes the value for the {@link DropletResource#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("guid")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Put one entry to the {@link DropletResource#getLinks() links} map.
     * @param key The key in the links map
     * @param value The associated value in the links map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder link(String key, Link value) {
      this.links.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link DropletResource#getLinks() links} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder link(Map.Entry<String, ? extends Link> entry) {
      String k = entry.getKey();
      Link v = entry.getValue();
      this.links.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link DropletResource#getLinks() links} map. Nulls are not permitted
     * @param entries The entries that will be added to the links map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("links")
    public final Builder links(Map<String, ? extends Link> entries) {
      this.links.clear();
      return putAllLinks(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link DropletResource#getLinks() links} map. Nulls are not permitted
     * @param entries The entries that will be added to the links map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllLinks(Map<String, ? extends Link> entries) {
      for (Map.Entry<String, ? extends Link> e : entries.entrySet()) {
        String k = e.getKey();
        Link v = e.getValue();
        this.links.put(k, v);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link DropletResource#getUpdatedAt() updatedAt} attribute.
     * @param updatedAt The value for updatedAt (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("updated_at")
    public final Builder updatedAt(@Nullable String updatedAt) {
      this.updatedAt = updatedAt;
      return this;
    }

    /**
     * Adds one element to {@link DropletResource#getBuildpacks() buildpacks} list.
     * @param element A buildpacks element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder buildpack(Buildpack element) {
      if (this.buildpacks == null) {
        this.buildpacks = new ArrayList<Buildpack>();
      }
      this.buildpacks.add(Objects.requireNonNull(element, "buildpacks element"));
      return this;
    }

    /**
     * Adds elements to {@link DropletResource#getBuildpacks() buildpacks} list.
     * @param elements An array of buildpacks elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder buildpacks(Buildpack... elements) {
      if (this.buildpacks == null) {
        this.buildpacks = new ArrayList<Buildpack>();
      }
      for (Buildpack element : elements) {
        this.buildpacks.add(Objects.requireNonNull(element, "buildpacks element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link DropletResource#getBuildpacks() buildpacks} list.
     * @param elements An iterable of buildpacks elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("buildpacks")
    public final Builder buildpacks(@Nullable Iterable<? extends Buildpack> elements) {
      if (elements == null) {
        this.buildpacks = null;
        return this;
      }
      this.buildpacks = new ArrayList<Buildpack>();
      return addAllBuildpacks(elements);
    }

    /**
     * Adds elements to {@link DropletResource#getBuildpacks() buildpacks} list.
     * @param elements An iterable of buildpacks elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllBuildpacks(Iterable<? extends Buildpack> elements) {
      Objects.requireNonNull(elements, "buildpacks element");
      if (this.buildpacks == null) {
        this.buildpacks = new ArrayList<Buildpack>();
      }
      for (Buildpack element : elements) {
        this.buildpacks.add(Objects.requireNonNull(element, "buildpacks element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link DropletResource#getChecksum() checksum} attribute.
     * @param checksum The value for checksum (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("checksum")
    public final Builder checksum(@Nullable Checksum checksum) {
      this.checksum = checksum;
      return this;
    }

    /**
     * Initializes the value for the {@link DropletResource#getError() error} attribute.
     * @param error The value for error (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("error")
    public final Builder error(@Nullable String error) {
      this.error = error;
      return this;
    }

    /**
     * Initializes the value for the {@link DropletResource#getExecutionMetadata() executionMetadata} attribute.
     * @param executionMetadata The value for executionMetadata 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("execution_metadata")
    public final Builder executionMetadata(String executionMetadata) {
      this.executionMetadata = Objects.requireNonNull(executionMetadata, "executionMetadata");
      initBits &= ~INIT_BIT_EXECUTION_METADATA;
      return this;
    }

    /**
     * Initializes the value for the {@link DropletResource#getImage() image} attribute.
     * @param image The value for image (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("image")
    public final Builder image(@Nullable String image) {
      this.image = image;
      return this;
    }

    /**
     * Initializes the value for the {@link DropletResource#getLifecycle() lifecycle} attribute.
     * @param lifecycle The value for lifecycle 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("lifecycle")
    public final Builder lifecycle(Lifecycle lifecycle) {
      this.lifecycle = Objects.requireNonNull(lifecycle, "lifecycle");
      initBits &= ~INIT_BIT_LIFECYCLE;
      return this;
    }

    /**
     * Initializes the value for the {@link DropletResource#getMetadata() metadata} attribute.
     * @param metadata The value for metadata (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("metadata")
    public final Builder metadata(@Nullable Metadata metadata) {
      this.metadata = metadata;
      return this;
    }

    /**
     * Put one entry to the {@link DropletResource#getProcessTypes() processTypes} map.
     * @param key The key in the processTypes map
     * @param value The associated value in the processTypes map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder processType(String key, String value) {
      if (this.processTypes == null) {
        this.processTypes = new LinkedHashMap<String, String>();
      }
      this.processTypes.put(
          Objects.requireNonNull(key, "processTypes key"),
          Objects.requireNonNull(value, value == null ? "processTypes value for key: " + key : null));
      return this;
    }

    /**
     * Put one entry to the {@link DropletResource#getProcessTypes() processTypes} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder processType(Map.Entry<String, ? extends String> entry) {
      if (this.processTypes == null) {
        this.processTypes = new LinkedHashMap<String, String>();
      }
      String k = entry.getKey();
      String v = entry.getValue();
      this.processTypes.put(
          Objects.requireNonNull(k, "processTypes key"),
          Objects.requireNonNull(v, v == null ? "processTypes value for key: " + k : null));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link DropletResource#getProcessTypes() processTypes} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the processTypes map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("process_types")
    public final Builder processTypes(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.processTypes = null;
        return this;
      }
      this.processTypes = new LinkedHashMap<String, String>();
      return putAllProcessTypes(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link DropletResource#getProcessTypes() processTypes} map. Nulls are not permitted
     * @param entries The entries that will be added to the processTypes map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllProcessTypes(Map<String, ? extends String> entries) {
      if (this.processTypes == null) {
        this.processTypes = new LinkedHashMap<String, String>();
      }
      for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
        String k = e.getKey();
        String v = e.getValue();
        this.processTypes.put(
            Objects.requireNonNull(k, "processTypes key"),
            Objects.requireNonNull(v, v == null ? "processTypes value for key: " + k : null));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link DropletResource#getRelationships() relationships} attribute.
     * @param relationships The value for relationships (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("relationships")
    public final Builder relationships(@Nullable DropletRelationships relationships) {
      this.relationships = relationships;
      return this;
    }

    /**
     * Initializes the value for the {@link DropletResource#getStack() stack} attribute.
     * @param stack The value for stack (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("stack")
    public final Builder stack(@Nullable String stack) {
      this.stack = stack;
      return this;
    }

    /**
     * Initializes the value for the {@link DropletResource#getState() state} attribute.
     * @param state The value for state 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("state")
    public final Builder state(DropletState state) {
      this.state = Objects.requireNonNull(state, "state");
      initBits &= ~INIT_BIT_STATE;
      return this;
    }

    /**
     * Builds a new {@link DropletResource DropletResource}.
     * @return An immutable instance of DropletResource
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public DropletResource build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new DropletResource(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_CREATED_AT) != 0) attributes.add("createdAt");
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_EXECUTION_METADATA) != 0) attributes.add("executionMetadata");
      if ((initBits & INIT_BIT_LIFECYCLE) != 0) attributes.add("lifecycle");
      if ((initBits & INIT_BIT_STATE) != 0) attributes.add("state");
      return "Cannot build DropletResource, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size() * 4 / 3 + 1);
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
