package org.cloudfoundry.client.v3.droplets;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.PaginatedRequest;
import org.immutables.value.Generated;

/**
 * The request payload for the List Applications operation
 */
@Generated(from = "_ListDropletsRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ListDropletsRequest extends org.cloudfoundry.client.v3.droplets._ListDropletsRequest {
  private final @Nullable String orderBy;
  private final @Nullable Integer page;
  private final @Nullable Integer perPage;
  private final List<String> applicationIds;
  private final List<String> dropletIds;
  private final List<String> organizationIds;
  private final List<String> spaceIds;
  private final List<DropletState> states;

  private ListDropletsRequest(ListDropletsRequest.Builder builder) {
    this.orderBy = builder.orderBy;
    this.page = builder.page;
    this.perPage = builder.perPage;
    this.applicationIds = createUnmodifiableList(true, builder.applicationIds);
    this.dropletIds = createUnmodifiableList(true, builder.dropletIds);
    this.organizationIds = createUnmodifiableList(true, builder.organizationIds);
    this.spaceIds = createUnmodifiableList(true, builder.spaceIds);
    this.states = createUnmodifiableList(true, builder.states);
  }

  /**
   * The order by
   */
  @Override
  public @Nullable String getOrderBy() {
    return orderBy;
  }

  /**
   * The page
   */
  @Override
  public @Nullable Integer getPage() {
    return page;
  }

  /**
   * The results per page
   */
  @Override
  public @Nullable Integer getPerPage() {
    return perPage;
  }

  /**
   * The application ids
   */
  @Override
  public List<String> getApplicationIds() {
    return applicationIds;
  }

  /**
   * The droplet ids
   */
  @Override
  public List<String> getDropletIds() {
    return dropletIds;
  }

  /**
   * The organization ids
   */
  @Override
  public List<String> getOrganizationIds() {
    return organizationIds;
  }

  /**
   * The space ids
   */
  @Override
  public List<String> getSpaceIds() {
    return spaceIds;
  }

  /**
   * The states
   */
  @Override
  public List<DropletState> getStates() {
    return states;
  }

  /**
   * This instance is equal to all instances of {@code ListDropletsRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ListDropletsRequest
        && equalTo(0, (ListDropletsRequest) another);
  }

  private boolean equalTo(int synthetic, ListDropletsRequest another) {
    return Objects.equals(orderBy, another.orderBy)
        && Objects.equals(page, another.page)
        && Objects.equals(perPage, another.perPage)
        && applicationIds.equals(another.applicationIds)
        && dropletIds.equals(another.dropletIds)
        && organizationIds.equals(another.organizationIds)
        && spaceIds.equals(another.spaceIds)
        && states.equals(another.states);
  }

  /**
   * Computes a hash code from attributes: {@code orderBy}, {@code page}, {@code perPage}, {@code applicationIds}, {@code dropletIds}, {@code organizationIds}, {@code spaceIds}, {@code states}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(orderBy);
    h += (h << 5) + Objects.hashCode(page);
    h += (h << 5) + Objects.hashCode(perPage);
    h += (h << 5) + applicationIds.hashCode();
    h += (h << 5) + dropletIds.hashCode();
    h += (h << 5) + organizationIds.hashCode();
    h += (h << 5) + spaceIds.hashCode();
    h += (h << 5) + states.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ListDropletsRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ListDropletsRequest{"
        + "orderBy=" + orderBy
        + ", page=" + page
        + ", perPage=" + perPage
        + ", applicationIds=" + applicationIds
        + ", dropletIds=" + dropletIds
        + ", organizationIds=" + organizationIds
        + ", spaceIds=" + spaceIds
        + ", states=" + states
        + "}";
  }

  private static ListDropletsRequest validate(ListDropletsRequest instance) {
    instance.check();
    return instance;
  }

  /**
   * Creates a builder for {@link ListDropletsRequest ListDropletsRequest}.
   * <pre>
   * ListDropletsRequest.builder()
   *    .orderBy(String | null) // nullable {@link ListDropletsRequest#getOrderBy() orderBy}
   *    .page(Integer | null) // nullable {@link ListDropletsRequest#getPage() page}
   *    .perPage(Integer | null) // nullable {@link ListDropletsRequest#getPerPage() perPage}
   *    .applicationId|addAllApplicationIds(String) // {@link ListDropletsRequest#getApplicationIds() applicationIds} elements
   *    .dropletId|addAllDropletIds(String) // {@link ListDropletsRequest#getDropletIds() dropletIds} elements
   *    .organizationId|addAllOrganizationIds(String) // {@link ListDropletsRequest#getOrganizationIds() organizationIds} elements
   *    .spaceId|addAllSpaceIds(String) // {@link ListDropletsRequest#getSpaceIds() spaceIds} elements
   *    .state|addAllStates(org.cloudfoundry.client.v3.droplets.DropletState) // {@link ListDropletsRequest#getStates() states} elements
   *    .build();
   * </pre>
   * @return A new ListDropletsRequest builder
   */
  public static ListDropletsRequest.Builder builder() {
    return new ListDropletsRequest.Builder();
  }

  /**
   * Builds instances of type {@link ListDropletsRequest ListDropletsRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ListDropletsRequest", generator = "Immutables")
  public static final class Builder {
    private String orderBy;
    private Integer page;
    private Integer perPage;
    private List<String> applicationIds = new ArrayList<String>();
    private List<String> dropletIds = new ArrayList<String>();
    private List<String> organizationIds = new ArrayList<String>();
    private List<String> spaceIds = new ArrayList<String>();
    private List<DropletState> states = new ArrayList<DropletState>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v3.PaginatedRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PaginatedRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code ListDropletsRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ListDropletsRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _ListDropletsRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_ListDropletsRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    private void from(short _unused, Object object) {
      if (object instanceof PaginatedRequest) {
        PaginatedRequest instance = (PaginatedRequest) object;
        String orderByValue = instance.getOrderBy();
        if (orderByValue != null) {
          orderBy(orderByValue);
        }
        Integer perPageValue = instance.getPerPage();
        if (perPageValue != null) {
          perPage(perPageValue);
        }
        Integer pageValue = instance.getPage();
        if (pageValue != null) {
          page(pageValue);
        }
      }
      if (object instanceof org.cloudfoundry.client.v3.droplets._ListDropletsRequest) {
        org.cloudfoundry.client.v3.droplets._ListDropletsRequest instance = (org.cloudfoundry.client.v3.droplets._ListDropletsRequest) object;
        addAllDropletIds(instance.getDropletIds());
        addAllSpaceIds(instance.getSpaceIds());
        addAllOrganizationIds(instance.getOrganizationIds());
        addAllApplicationIds(instance.getApplicationIds());
        addAllStates(instance.getStates());
      }
    }

    /**
     * Initializes the value for the {@link ListDropletsRequest#getOrderBy() orderBy} attribute.
     * @param orderBy The value for orderBy (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder orderBy(@Nullable String orderBy) {
      this.orderBy = orderBy;
      return this;
    }

    /**
     * Initializes the value for the {@link ListDropletsRequest#getPage() page} attribute.
     * @param page The value for page (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder page(@Nullable Integer page) {
      this.page = page;
      return this;
    }

    /**
     * Initializes the value for the {@link ListDropletsRequest#getPerPage() perPage} attribute.
     * @param perPage The value for perPage (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder perPage(@Nullable Integer perPage) {
      this.perPage = perPage;
      return this;
    }

    /**
     * Adds one element to {@link ListDropletsRequest#getApplicationIds() applicationIds} list.
     * @param element A applicationIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationId(String element) {
      this.applicationIds.add(Objects.requireNonNull(element, "applicationIds element"));
      return this;
    }

    /**
     * Adds elements to {@link ListDropletsRequest#getApplicationIds() applicationIds} list.
     * @param elements An array of applicationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationIds(String... elements) {
      for (String element : elements) {
        this.applicationIds.add(Objects.requireNonNull(element, "applicationIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListDropletsRequest#getApplicationIds() applicationIds} list.
     * @param elements An iterable of applicationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationIds(Iterable<String> elements) {
      this.applicationIds.clear();
      return addAllApplicationIds(elements);
    }

    /**
     * Adds elements to {@link ListDropletsRequest#getApplicationIds() applicationIds} list.
     * @param elements An iterable of applicationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllApplicationIds(Iterable<String> elements) {
      for (String element : elements) {
        this.applicationIds.add(Objects.requireNonNull(element, "applicationIds element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListDropletsRequest#getDropletIds() dropletIds} list.
     * @param element A dropletIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder dropletId(String element) {
      this.dropletIds.add(Objects.requireNonNull(element, "dropletIds element"));
      return this;
    }

    /**
     * Adds elements to {@link ListDropletsRequest#getDropletIds() dropletIds} list.
     * @param elements An array of dropletIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder dropletIds(String... elements) {
      for (String element : elements) {
        this.dropletIds.add(Objects.requireNonNull(element, "dropletIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListDropletsRequest#getDropletIds() dropletIds} list.
     * @param elements An iterable of dropletIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder dropletIds(Iterable<String> elements) {
      this.dropletIds.clear();
      return addAllDropletIds(elements);
    }

    /**
     * Adds elements to {@link ListDropletsRequest#getDropletIds() dropletIds} list.
     * @param elements An iterable of dropletIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllDropletIds(Iterable<String> elements) {
      for (String element : elements) {
        this.dropletIds.add(Objects.requireNonNull(element, "dropletIds element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListDropletsRequest#getOrganizationIds() organizationIds} list.
     * @param element A organizationIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationId(String element) {
      this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
      return this;
    }

    /**
     * Adds elements to {@link ListDropletsRequest#getOrganizationIds() organizationIds} list.
     * @param elements An array of organizationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationIds(String... elements) {
      for (String element : elements) {
        this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListDropletsRequest#getOrganizationIds() organizationIds} list.
     * @param elements An iterable of organizationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationIds(Iterable<String> elements) {
      this.organizationIds.clear();
      return addAllOrganizationIds(elements);
    }

    /**
     * Adds elements to {@link ListDropletsRequest#getOrganizationIds() organizationIds} list.
     * @param elements An iterable of organizationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllOrganizationIds(Iterable<String> elements) {
      for (String element : elements) {
        this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListDropletsRequest#getSpaceIds() spaceIds} list.
     * @param element A spaceIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceId(String element) {
      this.spaceIds.add(Objects.requireNonNull(element, "spaceIds element"));
      return this;
    }

    /**
     * Adds elements to {@link ListDropletsRequest#getSpaceIds() spaceIds} list.
     * @param elements An array of spaceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceIds(String... elements) {
      for (String element : elements) {
        this.spaceIds.add(Objects.requireNonNull(element, "spaceIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListDropletsRequest#getSpaceIds() spaceIds} list.
     * @param elements An iterable of spaceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceIds(Iterable<String> elements) {
      this.spaceIds.clear();
      return addAllSpaceIds(elements);
    }

    /**
     * Adds elements to {@link ListDropletsRequest#getSpaceIds() spaceIds} list.
     * @param elements An iterable of spaceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllSpaceIds(Iterable<String> elements) {
      for (String element : elements) {
        this.spaceIds.add(Objects.requireNonNull(element, "spaceIds element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListDropletsRequest#getStates() states} list.
     * @param element A states element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder state(DropletState element) {
      this.states.add(Objects.requireNonNull(element, "states element"));
      return this;
    }

    /**
     * Adds elements to {@link ListDropletsRequest#getStates() states} list.
     * @param elements An array of states elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder states(DropletState... elements) {
      for (DropletState element : elements) {
        this.states.add(Objects.requireNonNull(element, "states element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListDropletsRequest#getStates() states} list.
     * @param elements An iterable of states elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder states(Iterable<? extends DropletState> elements) {
      this.states.clear();
      return addAllStates(elements);
    }

    /**
     * Adds elements to {@link ListDropletsRequest#getStates() states} list.
     * @param elements An iterable of states elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllStates(Iterable<? extends DropletState> elements) {
      for (DropletState element : elements) {
        this.states.add(Objects.requireNonNull(element, "states element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ListDropletsRequest ListDropletsRequest}.
     * @return An immutable instance of ListDropletsRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ListDropletsRequest build() {
      return ListDropletsRequest.validate(new ListDropletsRequest(this));
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
