package org.cloudfoundry.client.v3.jobs;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * The request payload for the Get Job operation
 */
@Generated(from = "_GetJobRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class GetJobRequest extends org.cloudfoundry.client.v3.jobs._GetJobRequest {
  private final String jobId;

  private GetJobRequest(GetJobRequest.Builder builder) {
    this.jobId = builder.jobId;
  }

  /**
   * The job id
   */
  @Override
  public String getJobId() {
    return jobId;
  }

  /**
   * This instance is equal to all instances of {@code GetJobRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GetJobRequest
        && equalTo(0, (GetJobRequest) another);
  }

  private boolean equalTo(int synthetic, GetJobRequest another) {
    return jobId.equals(another.jobId);
  }

  /**
   * Computes a hash code from attributes: {@code jobId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + jobId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code GetJobRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GetJobRequest{"
        + "jobId=" + jobId
        + "}";
  }

  /**
   * Creates a builder for {@link GetJobRequest GetJobRequest}.
   * <pre>
   * GetJobRequest.builder()
   *    .jobId(String) // required {@link GetJobRequest#getJobId() jobId}
   *    .build();
   * </pre>
   * @return A new GetJobRequest builder
   */
  public static GetJobRequest.Builder builder() {
    return new GetJobRequest.Builder();
  }

  /**
   * Builds instances of type {@link GetJobRequest GetJobRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_GetJobRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_JOB_ID = 0x1L;
    private long initBits = 0x1L;

    private String jobId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GetJobRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GetJobRequest instance) {
      return from((_GetJobRequest) instance);
    }

    /**
     * Copy abstract value type {@code _GetJobRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_GetJobRequest instance) {
      Objects.requireNonNull(instance, "instance");
      this.jobId(instance.getJobId());
      return this;
    }

    /**
     * Initializes the value for the {@link GetJobRequest#getJobId() jobId} attribute.
     * @param jobId The value for jobId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder jobId(String jobId) {
      this.jobId = Objects.requireNonNull(jobId, "jobId");
      initBits &= ~INIT_BIT_JOB_ID;
      return this;
    }

    /**
     * Builds a new {@link GetJobRequest GetJobRequest}.
     * @return An immutable instance of GetJobRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GetJobRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new GetJobRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_JOB_ID) != 0) attributes.add("jobId");
      return "Cannot build GetJobRequest, some of required attributes are not set " + attributes;
    }
  }
}
