package org.cloudfoundry.client.v3.jobs;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * The warning object
 */
@Generated(from = "_Warning", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class Warning extends org.cloudfoundry.client.v3.jobs._Warning {
  private final String detail;

  private Warning(Warning.Builder builder) {
    this.detail = builder.detail;
  }

  /**
   * Detailed description of the warning
   */
  @JsonProperty("detail")
  @Override
  public String getDetail() {
    return detail;
  }

  /**
   * This instance is equal to all instances of {@code Warning} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof Warning
        && equalTo(0, (Warning) another);
  }

  private boolean equalTo(int synthetic, Warning another) {
    return detail.equals(another.detail);
  }

  /**
   * Computes a hash code from attributes: {@code detail}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + detail.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Warning} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Warning{"
        + "detail=" + detail
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_Warning", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.jobs._Warning {
    String detail;
    @JsonProperty("detail")
    public void setDetail(String detail) {
      this.detail = detail;
    }
    @Override
    public String getDetail() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static Warning fromJson(Json json) {
    Warning.Builder builder = Warning.builder();
    if (json.detail != null) {
      builder.detail(json.detail);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link Warning Warning}.
   * <pre>
   * Warning.builder()
   *    .detail(String) // required {@link Warning#getDetail() detail}
   *    .build();
   * </pre>
   * @return A new Warning builder
   */
  public static Warning.Builder builder() {
    return new Warning.Builder();
  }

  /**
   * Builds instances of type {@link Warning Warning}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_Warning", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_DETAIL = 0x1L;
    private long initBits = 0x1L;

    private String detail;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Warning} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Warning instance) {
      return from((_Warning) instance);
    }

    /**
     * Copy abstract value type {@code _Warning} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_Warning instance) {
      Objects.requireNonNull(instance, "instance");
      this.detail(instance.getDetail());
      return this;
    }

    /**
     * Initializes the value for the {@link Warning#getDetail() detail} attribute.
     * @param detail The value for detail 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("detail")
    public final Builder detail(String detail) {
      this.detail = Objects.requireNonNull(detail, "detail");
      initBits &= ~INIT_BIT_DETAIL;
      return this;
    }

    /**
     * Builds a new {@link Warning Warning}.
     * @return An immutable instance of Warning
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public Warning build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new Warning(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_DETAIL) != 0) attributes.add("detail");
      return "Cannot build Warning, some of required attributes are not set " + attributes;
    }
  }
}
