package org.cloudfoundry.client.v3.organizations;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * The request payload for the Get Default Isolation Segment operation
 */
@Generated(from = "_GetOrganizationDefaultIsolationSegmentRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class GetOrganizationDefaultIsolationSegmentRequest
    extends org.cloudfoundry.client.v3.organizations._GetOrganizationDefaultIsolationSegmentRequest {
  private final String organizationId;

  private GetOrganizationDefaultIsolationSegmentRequest(GetOrganizationDefaultIsolationSegmentRequest.Builder builder) {
    this.organizationId = builder.organizationId;
  }

  /**
   * The organization id
   */
  @Override
  public String getOrganizationId() {
    return organizationId;
  }

  /**
   * This instance is equal to all instances of {@code GetOrganizationDefaultIsolationSegmentRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GetOrganizationDefaultIsolationSegmentRequest
        && equalTo(0, (GetOrganizationDefaultIsolationSegmentRequest) another);
  }

  private boolean equalTo(int synthetic, GetOrganizationDefaultIsolationSegmentRequest another) {
    return organizationId.equals(another.organizationId);
  }

  /**
   * Computes a hash code from attributes: {@code organizationId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + organizationId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code GetOrganizationDefaultIsolationSegmentRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GetOrganizationDefaultIsolationSegmentRequest{"
        + "organizationId=" + organizationId
        + "}";
  }

  /**
   * Creates a builder for {@link GetOrganizationDefaultIsolationSegmentRequest GetOrganizationDefaultIsolationSegmentRequest}.
   * <pre>
   * GetOrganizationDefaultIsolationSegmentRequest.builder()
   *    .organizationId(String) // required {@link GetOrganizationDefaultIsolationSegmentRequest#getOrganizationId() organizationId}
   *    .build();
   * </pre>
   * @return A new GetOrganizationDefaultIsolationSegmentRequest builder
   */
  public static GetOrganizationDefaultIsolationSegmentRequest.Builder builder() {
    return new GetOrganizationDefaultIsolationSegmentRequest.Builder();
  }

  /**
   * Builds instances of type {@link GetOrganizationDefaultIsolationSegmentRequest GetOrganizationDefaultIsolationSegmentRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_GetOrganizationDefaultIsolationSegmentRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_ORGANIZATION_ID = 0x1L;
    private long initBits = 0x1L;

    private String organizationId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GetOrganizationDefaultIsolationSegmentRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GetOrganizationDefaultIsolationSegmentRequest instance) {
      return from((_GetOrganizationDefaultIsolationSegmentRequest) instance);
    }

    /**
     * Copy abstract value type {@code _GetOrganizationDefaultIsolationSegmentRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_GetOrganizationDefaultIsolationSegmentRequest instance) {
      Objects.requireNonNull(instance, "instance");
      this.organizationId(instance.getOrganizationId());
      return this;
    }

    /**
     * Initializes the value for the {@link GetOrganizationDefaultIsolationSegmentRequest#getOrganizationId() organizationId} attribute.
     * @param organizationId The value for organizationId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationId(String organizationId) {
      this.organizationId = Objects.requireNonNull(organizationId, "organizationId");
      initBits &= ~INIT_BIT_ORGANIZATION_ID;
      return this;
    }

    /**
     * Builds a new {@link GetOrganizationDefaultIsolationSegmentRequest GetOrganizationDefaultIsolationSegmentRequest}.
     * @return An immutable instance of GetOrganizationDefaultIsolationSegmentRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GetOrganizationDefaultIsolationSegmentRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new GetOrganizationDefaultIsolationSegmentRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ORGANIZATION_ID) != 0) attributes.add("organizationId");
      return "Cannot build GetOrganizationDefaultIsolationSegmentRequest, some of required attributes are not set " + attributes;
    }
  }
}
