package org.cloudfoundry.client.v3.organizations;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.*;
import org.cloudfoundry.client.v3.Metadata;
import org.cloudfoundry.client.v3.Resource;
import org.immutables.value.Generated;

/**
 * The Resource response payload for the List Organizations operation
 */
@Generated(from = "_OrganizationResource", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class OrganizationResource extends org.cloudfoundry.client.v3.organizations._OrganizationResource {
  private final String createdAt;
  private final String id;
  private final Map<String, Link> links;
  private final @Nullable String updatedAt;
  private final Metadata metadata;
  private final String name;
  private final @Nullable OrganizationRelationships relationships;
  private final @Nullable OrganizationStatus status;
  private final @Nullable Boolean suspended;

  private OrganizationResource(OrganizationResource.Builder builder) {
    this.createdAt = builder.createdAt;
    this.id = builder.id;
    this.links = createUnmodifiableMap(false, false, builder.links);
    this.updatedAt = builder.updatedAt;
    this.metadata = builder.metadata;
    this.name = builder.name;
    this.relationships = builder.relationships;
    this.status = builder.status;
    this.suspended = builder.suspended;
  }

  /**
   * When the resource was created
   */
  @JsonProperty("created_at")
  @Override
  public String getCreatedAt() {
    return createdAt;
  }

  /**
   * The resource's id
   */
  @JsonProperty("guid")
  @Override
  public String getId() {
    return id;
  }

  /**
   * Links to related resources and actions for the resource
   */
  @JsonProperty("links")
  @Override
  public Map<String, Link> getLinks() {
    return links;
  }

  /**
   * When the resource was last updated
   */
  @JsonProperty("updated_at")
  @Override
  public @Nullable String getUpdatedAt() {
    return updatedAt;
  }

  /**
   * The metadata
   */
  @JsonProperty("metadata")
  @Override
  public Metadata getMetadata() {
    return metadata;
  }

  /**
   * The name
   */
  @JsonProperty("name")
  @Override
  public String getName() {
    return name;
  }

  /**
   * The relationships
   */
  @JsonProperty("relationships")
  @Override
  public @Nullable OrganizationRelationships getRelationships() {
    return relationships;
  }

  /**
   * The status
   */
  @JsonProperty("status")
  @Override
  public @Nullable OrganizationStatus getStatus() {
    return status;
  }

  /**
   * Whether the organization is suspended
   */
  @JsonProperty("suspended")
  @Override
  public @Nullable Boolean getSuspended() {
    return suspended;
  }

  /**
   * This instance is equal to all instances of {@code OrganizationResource} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof OrganizationResource
        && equalTo(0, (OrganizationResource) another);
  }

  private boolean equalTo(int synthetic, OrganizationResource another) {
    return createdAt.equals(another.createdAt)
        && id.equals(another.id)
        && links.equals(another.links)
        && Objects.equals(updatedAt, another.updatedAt)
        && metadata.equals(another.metadata)
        && name.equals(another.name)
        && Objects.equals(relationships, another.relationships)
        && Objects.equals(status, another.status)
        && Objects.equals(suspended, another.suspended);
  }

  /**
   * Computes a hash code from attributes: {@code createdAt}, {@code id}, {@code links}, {@code updatedAt}, {@code metadata}, {@code name}, {@code relationships}, {@code status}, {@code suspended}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + createdAt.hashCode();
    h += (h << 5) + id.hashCode();
    h += (h << 5) + links.hashCode();
    h += (h << 5) + Objects.hashCode(updatedAt);
    h += (h << 5) + metadata.hashCode();
    h += (h << 5) + name.hashCode();
    h += (h << 5) + Objects.hashCode(relationships);
    h += (h << 5) + Objects.hashCode(status);
    h += (h << 5) + Objects.hashCode(suspended);
    return h;
  }

  /**
   * Prints the immutable value {@code OrganizationResource} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "OrganizationResource{"
        + "createdAt=" + createdAt
        + ", id=" + id
        + ", links=" + links
        + ", updatedAt=" + updatedAt
        + ", metadata=" + metadata
        + ", name=" + name
        + ", relationships=" + relationships
        + ", status=" + status
        + ", suspended=" + suspended
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_OrganizationResource", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.organizations._OrganizationResource {
    String createdAt;
    String id;
    Map<String, Link> links = Collections.emptyMap();
    String updatedAt;
    Metadata metadata;
    String name;
    OrganizationRelationships relationships;
    OrganizationStatus status;
    Boolean suspended;
    @JsonProperty("created_at")
    public void setCreatedAt(String createdAt) {
      this.createdAt = createdAt;
    }
    @JsonProperty("guid")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("links")
    public void setLinks(Map<String, Link> links) {
      this.links = links;
    }
    @JsonProperty("updated_at")
    public void setUpdatedAt(@Nullable String updatedAt) {
      this.updatedAt = updatedAt;
    }
    @JsonProperty("metadata")
    public void setMetadata(Metadata metadata) {
      this.metadata = metadata;
    }
    @JsonProperty("name")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty("relationships")
    public void setRelationships(@Nullable OrganizationRelationships relationships) {
      this.relationships = relationships;
    }
    @JsonProperty("status")
    public void setStatus(@Nullable OrganizationStatus status) {
      this.status = status;
    }
    @JsonProperty("suspended")
    public void setSuspended(@Nullable Boolean suspended) {
      this.suspended = suspended;
    }
    @Override
    public String getCreatedAt() { throw new UnsupportedOperationException(); }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, Link> getLinks() { throw new UnsupportedOperationException(); }
    @Override
    public String getUpdatedAt() { throw new UnsupportedOperationException(); }
    @Override
    public Metadata getMetadata() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public OrganizationRelationships getRelationships() { throw new UnsupportedOperationException(); }
    @Override
    public OrganizationStatus getStatus() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getSuspended() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static OrganizationResource fromJson(Json json) {
    OrganizationResource.Builder builder = OrganizationResource.builder();
    if (json.createdAt != null) {
      builder.createdAt(json.createdAt);
    }
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.links != null) {
      builder.putAllLinks(json.links);
    }
    if (json.updatedAt != null) {
      builder.updatedAt(json.updatedAt);
    }
    if (json.metadata != null) {
      builder.metadata(json.metadata);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.relationships != null) {
      builder.relationships(json.relationships);
    }
    if (json.status != null) {
      builder.status(json.status);
    }
    if (json.suspended != null) {
      builder.suspended(json.suspended);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link OrganizationResource OrganizationResource}.
   * <pre>
   * OrganizationResource.builder()
   *    .createdAt(String) // required {@link OrganizationResource#getCreatedAt() createdAt}
   *    .id(String) // required {@link OrganizationResource#getId() id}
   *    .link|putAllLinks(String =&gt; Link) // {@link OrganizationResource#getLinks() links} mappings
   *    .updatedAt(String | null) // nullable {@link OrganizationResource#getUpdatedAt() updatedAt}
   *    .metadata(org.cloudfoundry.client.v3.Metadata) // required {@link OrganizationResource#getMetadata() metadata}
   *    .name(String) // required {@link OrganizationResource#getName() name}
   *    .relationships(org.cloudfoundry.client.v3.organizations.OrganizationRelationships | null) // nullable {@link OrganizationResource#getRelationships() relationships}
   *    .status(org.cloudfoundry.client.v3.organizations.OrganizationStatus | null) // nullable {@link OrganizationResource#getStatus() status}
   *    .suspended(Boolean | null) // nullable {@link OrganizationResource#getSuspended() suspended}
   *    .build();
   * </pre>
   * @return A new OrganizationResource builder
   */
  public static OrganizationResource.Builder builder() {
    return new OrganizationResource.Builder();
  }

  /**
   * Builds instances of type {@link OrganizationResource OrganizationResource}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_OrganizationResource", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_CREATED_AT = 0x1L;
    private static final long INIT_BIT_ID = 0x2L;
    private static final long INIT_BIT_METADATA = 0x4L;
    private static final long INIT_BIT_NAME = 0x8L;
    private long initBits = 0xfL;

    private String createdAt;
    private String id;
    private Map<String, Link> links = new LinkedHashMap<String, Link>();
    private String updatedAt;
    private Metadata metadata;
    private String name;
    private OrganizationRelationships relationships;
    private OrganizationStatus status;
    private Boolean suspended;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v3.Resource} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Resource instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v3.organizations.Organization} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Organization instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code OrganizationResource} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(OrganizationResource instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _OrganizationResource} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_OrganizationResource instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    private void from(short _unused, Object object) {
      long bits = 0;
      if (object instanceof Resource) {
        Resource instance = (Resource) object;
        if ((bits & 0x4L) == 0) {
          this.createdAt(instance.getCreatedAt());
          bits |= 0x4L;
        }
        if ((bits & 0x20L) == 0) {
          putAllLinks(instance.getLinks());
          bits |= 0x20L;
        }
        if ((bits & 0x40L) == 0) {
          this.id(instance.getId());
          bits |= 0x40L;
        }
        if ((bits & 0x80L) == 0) {
          String updatedAtValue = instance.getUpdatedAt();
          if (updatedAtValue != null) {
            updatedAt(updatedAtValue);
          }
          bits |= 0x80L;
        }
      }
      if (object instanceof Organization) {
        Organization instance = (Organization) object;
        if ((bits & 0x4L) == 0) {
          this.createdAt(instance.getCreatedAt());
          bits |= 0x4L;
        }
        if ((bits & 0x8L) == 0) {
          OrganizationRelationships relationshipsValue = instance.getRelationships();
          if (relationshipsValue != null) {
            relationships(relationshipsValue);
          }
          bits |= 0x8L;
        }
        if ((bits & 0x1L) == 0) {
          this.metadata(instance.getMetadata());
          bits |= 0x1L;
        }
        if ((bits & 0x10L) == 0) {
          this.name(instance.getName());
          bits |= 0x10L;
        }
        if ((bits & 0x20L) == 0) {
          putAllLinks(instance.getLinks());
          bits |= 0x20L;
        }
        if ((bits & 0x40L) == 0) {
          this.id(instance.getId());
          bits |= 0x40L;
        }
        if ((bits & 0x2L) == 0) {
          Boolean suspendedValue = instance.getSuspended();
          if (suspendedValue != null) {
            suspended(suspendedValue);
          }
          bits |= 0x2L;
        }
        if ((bits & 0x80L) == 0) {
          String updatedAtValue = instance.getUpdatedAt();
          if (updatedAtValue != null) {
            updatedAt(updatedAtValue);
          }
          bits |= 0x80L;
        }
        if ((bits & 0x100L) == 0) {
          OrganizationStatus statusValue = instance.getStatus();
          if (statusValue != null) {
            status(statusValue);
          }
          bits |= 0x100L;
        }
      }
      if (object instanceof org.cloudfoundry.client.v3.organizations._OrganizationResource) {
        org.cloudfoundry.client.v3.organizations._OrganizationResource instance = (org.cloudfoundry.client.v3.organizations._OrganizationResource) object;
        if ((bits & 0x10L) == 0) {
          this.name(instance.getName());
          bits |= 0x10L;
        }
        if ((bits & 0x8L) == 0) {
          OrganizationRelationships relationshipsValue = instance.getRelationships();
          if (relationshipsValue != null) {
            relationships(relationshipsValue);
          }
          bits |= 0x8L;
        }
        if ((bits & 0x1L) == 0) {
          this.metadata(instance.getMetadata());
          bits |= 0x1L;
        }
        if ((bits & 0x2L) == 0) {
          Boolean suspendedValue = instance.getSuspended();
          if (suspendedValue != null) {
            suspended(suspendedValue);
          }
          bits |= 0x2L;
        }
        if ((bits & 0x100L) == 0) {
          OrganizationStatus statusValue = instance.getStatus();
          if (statusValue != null) {
            status(statusValue);
          }
          bits |= 0x100L;
        }
      }
    }

    /**
     * Initializes the value for the {@link OrganizationResource#getCreatedAt() createdAt} attribute.
     * @param createdAt The value for createdAt 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("created_at")
    public final Builder createdAt(String createdAt) {
      this.createdAt = Objects.requireNonNull(createdAt, "createdAt");
      initBits &= ~INIT_BIT_CREATED_AT;
      return this;
    }

    /**
     * Initializes the value for the {@link OrganizationResource#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("guid")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Put one entry to the {@link OrganizationResource#getLinks() links} map.
     * @param key The key in the links map
     * @param value The associated value in the links map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder link(String key, Link value) {
      this.links.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link OrganizationResource#getLinks() links} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder link(Map.Entry<String, ? extends Link> entry) {
      String k = entry.getKey();
      Link v = entry.getValue();
      this.links.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link OrganizationResource#getLinks() links} map. Nulls are not permitted
     * @param entries The entries that will be added to the links map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("links")
    public final Builder links(Map<String, ? extends Link> entries) {
      this.links.clear();
      return putAllLinks(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link OrganizationResource#getLinks() links} map. Nulls are not permitted
     * @param entries The entries that will be added to the links map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllLinks(Map<String, ? extends Link> entries) {
      for (Map.Entry<String, ? extends Link> e : entries.entrySet()) {
        String k = e.getKey();
        Link v = e.getValue();
        this.links.put(k, v);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link OrganizationResource#getUpdatedAt() updatedAt} attribute.
     * @param updatedAt The value for updatedAt (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("updated_at")
    public final Builder updatedAt(@Nullable String updatedAt) {
      this.updatedAt = updatedAt;
      return this;
    }

    /**
     * Initializes the value for the {@link OrganizationResource#getMetadata() metadata} attribute.
     * @param metadata The value for metadata 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("metadata")
    public final Builder metadata(Metadata metadata) {
      this.metadata = Objects.requireNonNull(metadata, "metadata");
      initBits &= ~INIT_BIT_METADATA;
      return this;
    }

    /**
     * Initializes the value for the {@link OrganizationResource#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link OrganizationResource#getRelationships() relationships} attribute.
     * @param relationships The value for relationships (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("relationships")
    public final Builder relationships(@Nullable OrganizationRelationships relationships) {
      this.relationships = relationships;
      return this;
    }

    /**
     * Initializes the value for the {@link OrganizationResource#getStatus() status} attribute.
     * @param status The value for status (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("status")
    public final Builder status(@Nullable OrganizationStatus status) {
      this.status = status;
      return this;
    }

    /**
     * Initializes the value for the {@link OrganizationResource#getSuspended() suspended} attribute.
     * @param suspended The value for suspended (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("suspended")
    public final Builder suspended(@Nullable Boolean suspended) {
      this.suspended = suspended;
      return this;
    }

    /**
     * Builds a new {@link OrganizationResource OrganizationResource}.
     * @return An immutable instance of OrganizationResource
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public OrganizationResource build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new OrganizationResource(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_CREATED_AT) != 0) attributes.add("createdAt");
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_METADATA) != 0) attributes.add("metadata");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      return "Cannot build OrganizationResource, some of required attributes are not set " + attributes;
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size() * 4 / 3 + 1);
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
