package org.cloudfoundry.client.v3.organizations;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.Metadata;
import org.immutables.value.Generated;

/**
 * The request payload for the Update Organization operation
 */
@Generated(from = "_UpdateOrganizationRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class UpdateOrganizationRequest
    extends org.cloudfoundry.client.v3.organizations._UpdateOrganizationRequest {
  private final @Nullable Metadata metadata;
  private final String organizationId;

  private UpdateOrganizationRequest(UpdateOrganizationRequest.Builder builder) {
    this.metadata = builder.metadata;
    this.organizationId = builder.organizationId;
  }

  /**
   * The metadata
   */
  @JsonProperty("metadata")
  @Override
  public @Nullable Metadata getMetadata() {
    return metadata;
  }

  /**
   * The organization id
   */
  @JsonProperty("organizationId")
  @JsonIgnore
  @Override
  public String getOrganizationId() {
    return organizationId;
  }

  /**
   * This instance is equal to all instances of {@code UpdateOrganizationRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof UpdateOrganizationRequest
        && equalTo(0, (UpdateOrganizationRequest) another);
  }

  private boolean equalTo(int synthetic, UpdateOrganizationRequest another) {
    return Objects.equals(metadata, another.metadata)
        && organizationId.equals(another.organizationId);
  }

  /**
   * Computes a hash code from attributes: {@code metadata}, {@code organizationId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(metadata);
    h += (h << 5) + organizationId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code UpdateOrganizationRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UpdateOrganizationRequest{"
        + "metadata=" + metadata
        + ", organizationId=" + organizationId
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_UpdateOrganizationRequest", generator = "Immutables")
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.organizations._UpdateOrganizationRequest {
    Metadata metadata;
    String organizationId;
    @JsonProperty("metadata")
    public void setMetadata(@Nullable Metadata metadata) {
      this.metadata = metadata;
    }
    @JsonProperty("organizationId")
    @JsonIgnore
    public void setOrganizationId(String organizationId) {
      this.organizationId = organizationId;
    }
    @Override
    public Metadata getMetadata() { throw new UnsupportedOperationException(); }
    @Override
    public String getOrganizationId() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static UpdateOrganizationRequest fromJson(Json json) {
    UpdateOrganizationRequest.Builder builder = UpdateOrganizationRequest.builder();
    if (json.metadata != null) {
      builder.metadata(json.metadata);
    }
    if (json.organizationId != null) {
      builder.organizationId(json.organizationId);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link UpdateOrganizationRequest UpdateOrganizationRequest}.
   * <pre>
   * UpdateOrganizationRequest.builder()
   *    .metadata(org.cloudfoundry.client.v3.Metadata | null) // nullable {@link UpdateOrganizationRequest#getMetadata() metadata}
   *    .organizationId(String) // required {@link UpdateOrganizationRequest#getOrganizationId() organizationId}
   *    .build();
   * </pre>
   * @return A new UpdateOrganizationRequest builder
   */
  public static UpdateOrganizationRequest.Builder builder() {
    return new UpdateOrganizationRequest.Builder();
  }

  /**
   * Builds instances of type {@link UpdateOrganizationRequest UpdateOrganizationRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_UpdateOrganizationRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_ORGANIZATION_ID = 0x1L;
    private long initBits = 0x1L;

    private Metadata metadata;
    private String organizationId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code UpdateOrganizationRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UpdateOrganizationRequest instance) {
      return from((_UpdateOrganizationRequest) instance);
    }

    /**
     * Copy abstract value type {@code _UpdateOrganizationRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_UpdateOrganizationRequest instance) {
      Objects.requireNonNull(instance, "instance");
      Metadata metadataValue = instance.getMetadata();
      if (metadataValue != null) {
        metadata(metadataValue);
      }
      this.organizationId(instance.getOrganizationId());
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateOrganizationRequest#getMetadata() metadata} attribute.
     * @param metadata The value for metadata (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder metadata(@Nullable Metadata metadata) {
      this.metadata = metadata;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateOrganizationRequest#getOrganizationId() organizationId} attribute.
     * @param organizationId The value for organizationId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationId(String organizationId) {
      this.organizationId = Objects.requireNonNull(organizationId, "organizationId");
      initBits &= ~INIT_BIT_ORGANIZATION_ID;
      return this;
    }

    /**
     * Builds a new {@link UpdateOrganizationRequest UpdateOrganizationRequest}.
     * @return An immutable instance of UpdateOrganizationRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public UpdateOrganizationRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new UpdateOrganizationRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ORGANIZATION_ID) != 0) attributes.add("organizationId");
      return "Cannot build UpdateOrganizationRequest, some of required attributes are not set " + attributes;
    }
  }
}
