package org.cloudfoundry.client.v3.packages;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * Data type for docker packages
 */
@Generated(from = "_DockerData", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class DockerData extends org.cloudfoundry.client.v3.packages._DockerData {
  private final String image;
  private final @Nullable String password;
  private final @Nullable String username;

  private DockerData(DockerData.Builder builder) {
    this.image = builder.image;
    this.password = builder.password;
    this.username = builder.username;
  }

  /**
   * The Docker image
   */
  @JsonProperty("image")
  @Override
  public String getImage() {
    return image;
  }

  /**
   * The password for the image's registry
   */
  @JsonProperty("password")
  @Override
  public @Nullable String getPassword() {
    return password;
  }

  /**
   * The username for the image's registry
   */
  @JsonProperty("username")
  @Override
  public @Nullable String getUsername() {
    return username;
  }

  /**
   * This instance is equal to all instances of {@code DockerData} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof DockerData
        && equalTo(0, (DockerData) another);
  }

  private boolean equalTo(int synthetic, DockerData another) {
    return image.equals(another.image)
        && Objects.equals(password, another.password)
        && Objects.equals(username, another.username);
  }

  /**
   * Computes a hash code from attributes: {@code image}, {@code password}, {@code username}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + image.hashCode();
    h += (h << 5) + Objects.hashCode(password);
    h += (h << 5) + Objects.hashCode(username);
    return h;
  }

  /**
   * Prints the immutable value {@code DockerData} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DockerData{"
        + "image=" + image
        + ", password=" + password
        + ", username=" + username
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_DockerData", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.packages._DockerData {
    String image;
    String password;
    String username;
    @JsonProperty("image")
    public void setImage(String image) {
      this.image = image;
    }
    @JsonProperty("password")
    public void setPassword(@Nullable String password) {
      this.password = password;
    }
    @JsonProperty("username")
    public void setUsername(@Nullable String username) {
      this.username = username;
    }
    @Override
    public String getImage() { throw new UnsupportedOperationException(); }
    @Override
    public String getPassword() { throw new UnsupportedOperationException(); }
    @Override
    public String getUsername() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static DockerData fromJson(Json json) {
    DockerData.Builder builder = DockerData.builder();
    if (json.image != null) {
      builder.image(json.image);
    }
    if (json.password != null) {
      builder.password(json.password);
    }
    if (json.username != null) {
      builder.username(json.username);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link DockerData DockerData}.
   * <pre>
   * DockerData.builder()
   *    .image(String) // required {@link DockerData#getImage() image}
   *    .password(String | null) // nullable {@link DockerData#getPassword() password}
   *    .username(String | null) // nullable {@link DockerData#getUsername() username}
   *    .build();
   * </pre>
   * @return A new DockerData builder
   */
  public static DockerData.Builder builder() {
    return new DockerData.Builder();
  }

  /**
   * Builds instances of type {@link DockerData DockerData}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_DockerData", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_IMAGE = 0x1L;
    private long initBits = 0x1L;

    private String image;
    private String password;
    private String username;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DockerData} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DockerData instance) {
      return from((_DockerData) instance);
    }

    /**
     * Copy abstract value type {@code _DockerData} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_DockerData instance) {
      Objects.requireNonNull(instance, "instance");
      this.image(instance.getImage());
      String passwordValue = instance.getPassword();
      if (passwordValue != null) {
        password(passwordValue);
      }
      String usernameValue = instance.getUsername();
      if (usernameValue != null) {
        username(usernameValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link DockerData#getImage() image} attribute.
     * @param image The value for image 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("image")
    public final Builder image(String image) {
      this.image = Objects.requireNonNull(image, "image");
      initBits &= ~INIT_BIT_IMAGE;
      return this;
    }

    /**
     * Initializes the value for the {@link DockerData#getPassword() password} attribute.
     * @param password The value for password (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("password")
    public final Builder password(@Nullable String password) {
      this.password = password;
      return this;
    }

    /**
     * Initializes the value for the {@link DockerData#getUsername() username} attribute.
     * @param username The value for username (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("username")
    public final Builder username(@Nullable String username) {
      this.username = username;
      return this;
    }

    /**
     * Builds a new {@link DockerData DockerData}.
     * @return An immutable instance of DockerData
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public DockerData build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new DockerData(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_IMAGE) != 0) attributes.add("image");
      return "Cannot build DockerData, some of required attributes are not set " + attributes;
    }
  }
}
