package org.cloudfoundry.client.v3.packages;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * The request payload for the Get Package operation
 */
@Generated(from = "_GetPackageRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class GetPackageRequest extends org.cloudfoundry.client.v3.packages._GetPackageRequest {
  private final String packageId;

  private GetPackageRequest(GetPackageRequest.Builder builder) {
    this.packageId = builder.packageId;
  }

  /**
   * The package id
   */
  @Override
  public String getPackageId() {
    return packageId;
  }

  /**
   * This instance is equal to all instances of {@code GetPackageRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GetPackageRequest
        && equalTo(0, (GetPackageRequest) another);
  }

  private boolean equalTo(int synthetic, GetPackageRequest another) {
    return packageId.equals(another.packageId);
  }

  /**
   * Computes a hash code from attributes: {@code packageId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + packageId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code GetPackageRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GetPackageRequest{"
        + "packageId=" + packageId
        + "}";
  }

  /**
   * Creates a builder for {@link GetPackageRequest GetPackageRequest}.
   * <pre>
   * GetPackageRequest.builder()
   *    .packageId(String) // required {@link GetPackageRequest#getPackageId() packageId}
   *    .build();
   * </pre>
   * @return A new GetPackageRequest builder
   */
  public static GetPackageRequest.Builder builder() {
    return new GetPackageRequest.Builder();
  }

  /**
   * Builds instances of type {@link GetPackageRequest GetPackageRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_GetPackageRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_PACKAGE_ID = 0x1L;
    private long initBits = 0x1L;

    private String packageId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GetPackageRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GetPackageRequest instance) {
      return from((_GetPackageRequest) instance);
    }

    /**
     * Copy abstract value type {@code _GetPackageRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_GetPackageRequest instance) {
      Objects.requireNonNull(instance, "instance");
      this.packageId(instance.getPackageId());
      return this;
    }

    /**
     * Initializes the value for the {@link GetPackageRequest#getPackageId() packageId} attribute.
     * @param packageId The value for packageId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder packageId(String packageId) {
      this.packageId = Objects.requireNonNull(packageId, "packageId");
      initBits &= ~INIT_BIT_PACKAGE_ID;
      return this;
    }

    /**
     * Builds a new {@link GetPackageRequest GetPackageRequest}.
     * @return An immutable instance of GetPackageRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GetPackageRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new GetPackageRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_PACKAGE_ID) != 0) attributes.add("packageId");
      return "Cannot build GetPackageRequest, some of required attributes are not set " + attributes;
    }
  }
}
